/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.patterns;

import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DTOHelper {
    private final Project project;
    private org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar;
    private Entity entity;
    private final TypeElement classElm;
    private EnterpriseBeans beans;
    private final FileObject fileObject;

    public DTOHelper(CompilationController compilationController, Element element) {
        this.classElm = (TypeElement)element.getEnclosingElement();
        this.fileObject = compilationController.getFileObject();
        this.project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
        EjbJar ejbJar = EjbJar.getEjbJar((FileObject)this.fileObject);
        DDProvider dDProvider = DDProvider.getDefault();
        try {
            this.ejbJar = dDProvider.getDDRoot(ejbJar.getDeploymentDescriptor());
            this.beans = this.ejbJar.getEnterpriseBeans();
            this.entity = (Entity)this.beans.findBeanByName("Entity", "EjbClass", this.classElm.getQualifiedName().toString());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public CmrField[] getCmrFields() {
        ArrayList<CmrField> arrayList = new ArrayList<CmrField>();
        EjbRelation[] ejbRelationArray = this.getRelation();
        if (ejbRelationArray != null) {
            for (EjbRelation ejbRelation : ejbRelationArray) {
                EjbRelationshipRole ejbRelationshipRole = ejbRelation.getEjbRelationshipRole();
                if (this.isUseEjb(ejbRelationshipRole)) {
                    arrayList.add(ejbRelationshipRole.getCmrField());
                }
                if (!this.isUseEjb(ejbRelationshipRole = ejbRelation.getEjbRelationshipRole2())) continue;
                arrayList.add(ejbRelationshipRole.getCmrField());
            }
        }
        return arrayList.toArray(new CmrField[0]);
    }

    private EjbRelation[] getRelation() {
        Relationships relationships = this.ejbJar.getSingleRelationships();
        return relationships != null ? relationships.getEjbRelation() : null;
    }

    public boolean isMultiple(CmrField cmrField) {
        boolean bl = false;
        EjbRelation[] ejbRelationArray = this.getRelation();
        if (ejbRelationArray != null) {
            for (EjbRelation ejbRelation : ejbRelationArray) {
                EjbRelationshipRole ejbRelationshipRole = ejbRelation.getEjbRelationshipRole();
                if (cmrField == ejbRelationshipRole.getCmrField()) {
                    if ("Many".equals(ejbRelation.getEjbRelationshipRole2().getMultiplicity())) {
                        bl = true;
                    }
                }
                if (cmrField != (ejbRelationshipRole = ejbRelation.getEjbRelationshipRole2()).getCmrField()) continue;
                if (!"Many".equals(ejbRelation.getEjbRelationshipRole().getMultiplicity())) continue;
                bl = true;
            }
        }
        return bl;
    }

    public String getOppositeFieldType(CmrField cmrField) {
        String string = "";
        EjbRelation[] ejbRelationArray = this.getRelation();
        if (ejbRelationArray != null) {
            for (EjbRelation ejbRelation : ejbRelationArray) {
                EjbRelationshipRole ejbRelationshipRole = ejbRelation.getEjbRelationshipRole();
                if (cmrField == ejbRelationshipRole.getCmrField()) {
                    String string2 = ejbRelation.getEjbRelationshipRole2().getRelationshipRoleSource().getEjbName();
                    string = this.findLocalIntNameByEntityName(string2);
                    break;
                }
                ejbRelationshipRole = ejbRelation.getEjbRelationshipRole2();
                if (cmrField != ejbRelationshipRole.getCmrField()) continue;
                String string3 = ejbRelation.getEjbRelationshipRole().getRelationshipRoleSource().getEjbName();
                string = this.findLocalIntNameByEntityName(string3);
                break;
            }
        }
        return string;
    }

    public String findLocalIntNameByEntityName(String string) {
        Entity[] entityArray = this.beans.getEntity();
        String string2 = "";
        for (int i = 0; i < entityArray.length; ++i) {
            if (!string.equals(entityArray[i].getEjbName())) continue;
            string2 = entityArray[i].getLocal();
            break;
        }
        return string2;
    }

    public String findEntityNameByLocalInt(String string) {
        Entity[] entityArray = this.beans.getEntity();
        String string2 = "";
        for (int i = 0; i < entityArray.length; ++i) {
            if (!string.equals(entityArray[i].getLocal())) continue;
            string2 = entityArray[i].getEjbName();
            break;
        }
        return string2;
    }

    private boolean isUseEjb(EjbRelationshipRole ejbRelationshipRole) {
        return ejbRelationshipRole != null && ejbRelationshipRole.getRelationshipRoleSource() != null && ejbRelationshipRole.getRelationshipRoleSource().getEjbName().equals(this.getEntityName());
    }

    public CmpField[] getCmpFields() {
        return this.entity.getCmpField();
    }

    public String getFieldType(String string) {
        String string2 = "";
        return string2;
    }

    public String getEntityName() {
        return this.entity.getEjbName();
    }

    public String getLocalName() {
        return this.entity.getLocal();
    }

    public String getFullName() {
        return this.classElm.getQualifiedName().toString();
    }

    public String getPackage() {
        return this.getFullName().substring(0, this.getFullName().lastIndexOf(46));
    }

    public Project getProject() {
        return this.project;
    }

    public SourceGroup getSourceGroup() {
        SourceGroup sourceGroup = null;
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)this.project);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!sourceGroupArray[i].contains(this.fileObject)) continue;
            sourceGroup = sourceGroupArray[i];
        }
        return sourceGroup;
    }
}

