/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui;

import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.common.ui.BrokenServerAlertPanel;
import org.netbeans.modules.j2ee.common.ui.J2EEUISettings;
import org.netbeans.modules.j2ee.common.ui.NoSelectedServerWarning;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class BrokenServerSupport {
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;

    private BrokenServerSupport() {
    }

    public static boolean isBroken(String string) {
        return Deployment.getDefault().getServerID(string) == null;
    }

    public static String selectServer(String string, Object object) {
        return NoSelectedServerWarning.selectServerDialog(new Object[]{object}, string, NbBundle.getMessage(BrokenServerSupport.class, (String)"LBL_Resolve_Missing_Server_Title"), NbBundle.getMessage(BrokenServerSupport.class, (String)"ACSD_Resolve_Missing_Server"));
    }

    public static String selectServer(Profile profile, J2eeModule.Type type) {
        return NoSelectedServerWarning.selectServerDialog(new J2eeModule.Type[]{type}, profile, NbBundle.getMessage(BrokenServerSupport.class, (String)"LBL_Resolve_Missing_Server_Title"), NbBundle.getMessage(BrokenServerSupport.class, (String)"ACSD_Resolve_Missing_Server"));
    }

    public static synchronized void showAlert() {
        if (Boolean.getBoolean("j2eeserver.no.server.instance.check")) {
            return;
        }
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis() || !J2EEUISettings.getDefault().isShowAgainBrokenServerAlert()) {
            return;
        }
        brokenAlertShown = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                try {
                    object = new BrokenServerAlertPanel();
                    JButton jButton = new JButton(NbBundle.getMessage(BrokenServerSupport.class, (String)"LBL_BrokenServerCustomizer_Close"));
                    jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenServerSupport.class, (String)"ACSD_BrokenServerCustomizer_Close"));
                    DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage(BrokenServerAlertPanel.class, (String)"MSG_Broken_Server_Title"), true, new Object[]{jButton}, (Object)jButton, 0, null, null);
                    dialogDescriptor.setMessageType(2);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    dialog.setVisible(true);
                }
                finally {
                    object = BrokenServerSupport.class;
                    synchronized (BrokenServerSupport.class) {
                        brokenAlertLastTime = System.currentTimeMillis();
                        brokenAlertShown = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        });
    }
}

