/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSearchUtility {
    private FileSearchUtility() {
    }

    public static Enumeration<FileObject> getChildrenToDepth(FileObject fileObject, final int n, final boolean bl) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WithChildren
        implements Enumerations.Processor<FileObject, FileObject> {
            private int rootDepth;

            public WithChildren(int n3) {
                this.rootDepth = n3;
            }

            public FileObject process(FileObject fileObject, Collection<FileObject> collection) {
                if ((!bl || bl && fileObject.canWrite()) && fileObject.isFolder() && FileSearchUtility.getDepth(fileObject) - this.rootDepth < n) {
                    collection.addAll(Arrays.asList(fileObject.getChildren()));
                }
                return fileObject;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.array((Object[])fileObject.getChildren()), (Enumerations.Processor)new WithChildren(FileSearchUtility.getDepth(fileObject)));
    }

    public static FileObject guessWebInf(FileObject fileObject) {
        Enumeration<FileObject> enumeration = FileSearchUtility.getChildrenToDepth(fileObject, 3, true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2;
            FileObject fileObject3 = enumeration.nextElement();
            if (!fileObject3.isFolder() || (fileObject2 = fileObject3.getFileObject("web.xml")) == null || !fileObject2.isData()) continue;
            return fileObject3;
        }
        return null;
    }

    public static FileObject guessDocBase(FileObject fileObject) {
        FileObject fileObject2 = null;
        Enumeration<FileObject> enumeration = FileSearchUtility.getChildrenToDepth(fileObject, 3, true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject3 = enumeration.nextElement();
            if (fileObject3.isData() && fileObject3.getExt().equals("jsp")) {
                return fileObject3.getParent();
            }
            if (!fileObject3.isFolder() || !fileObject3.getName().equalsIgnoreCase("web") && !fileObject3.getName().equalsIgnoreCase("webroot")) continue;
            fileObject2 = fileObject3;
        }
        return fileObject2;
    }

    public static FileObject guessLibrariesFolder(FileObject fileObject) {
        Object object;
        FileObject fileObject2 = FileSearchUtility.guessWebInf(fileObject);
        if (fileObject2 != null && (object = fileObject2.getFileObject("lib")) != null) {
            return object;
        }
        object = FileSearchUtility.getChildrenToDepth(fileObject, 3, true);
        while (object.hasMoreElements()) {
            FileObject fileObject3 = (FileObject)object.nextElement();
            if (!fileObject3.getExt().equals("jar")) continue;
            return fileObject3.getParent();
        }
        return null;
    }

    public static FileObject[] guessJavaRoots(FileObject fileObject) {
        Object object;
        FileObject[] fileObjectArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (null == fileObject) {
            return null;
        }
        Enumeration<FileObject> enumeration = FileSearchUtility.getChildrenToDepth(fileObject, 10, true);
        try {
            while (enumeration.hasMoreElements() && arrayList.isEmpty()) {
                fileObjectArray = enumeration.nextElement();
                if (!fileObjectArray.getExt().equals("java") || fileObjectArray.isFolder()) continue;
                object = FileSearchUtility.guessPackageName((FileObject)fileObjectArray);
                String string = fileObjectArray.getParent().getPath();
                if (object == null || !string.endsWith(((String)object).replace('.', '/'))) continue;
                String string2 = string.substring(0, string.length() - ((String)object).length());
                FileObject fileObject2 = fileObjectArray.getFileSystem().findResource(string2);
                if (fileObject2.getNameExt().equals("test") || arrayList.contains(fileObject2)) continue;
                arrayList.add(fileObject2);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Logger.getLogger("global").log(Level.INFO, null, fileStateInvalidException);
        }
        if (arrayList.size() == 0 && (fileObjectArray = FileSearchUtility.guessWebInf(fileObject)) != null && (object = fileObjectArray.getFileObject("classes")) != null) {
            arrayList.add((FileObject)object);
        }
        if (arrayList.size() == 0 && fileObject.getFileObject("src/java") != null) {
            arrayList.add(fileObject.getFileObject("src/java"));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        fileObjectArray = new FileObject[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            fileObjectArray[i] = (FileObject)arrayList.get(i);
        }
        return fileObjectArray;
    }

    public static File[] guessJavaRootsAsFiles(FileObject fileObject) {
        FileObject[] fileObjectArray = FileSearchUtility.guessJavaRoots(fileObject);
        if (fileObjectArray == null) {
            return new File[0];
        }
        File[] fileArray = new File[fileObjectArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = FileUtil.toFile((FileObject)fileObjectArray[i]);
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String guessPackageName(FileObject fileObject) {
        Reader reader = null;
        try {
            int n;
            int n2;
            reader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "utf-8"));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[4096];
            while ((n2 = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n2);
            }
            int n3 = stringBuffer.indexOf("package");
            if (n3 >= 0 && (n = stringBuffer.indexOf(";", n3)) >= 0) {
                String string = stringBuffer.substring(n3 + "package".length(), n).trim();
                return string;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    private static int getDepth(FileObject fileObject) {
        String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        return stringTokenizer.countTokens();
    }

    public static FileObject guessConfigFilesPath(FileObject fileObject, String string) {
        if (null == fileObject) {
            return null;
        }
        Enumeration<FileObject> enumeration = FileSearchUtility.getChildrenToDepth(fileObject, 3, true);
        try {
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = enumeration.nextElement();
                if (!fileObject2.getNameExt().equals(string)) continue;
                String string2 = fileObject2.getParent().getPath();
                return fileObject2.getFileSystem().findResource(string2);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Logger.getLogger("global").log(Level.INFO, null, fileStateInvalidException);
        }
        return null;
    }
}

