/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.webservices;

import org.netbeans.modules.websvc.spi.webservices.WebServicesViewImpl;
import org.netbeans.modules.websvc.spi.webservices.WebServicesViewProvider;
import org.netbeans.modules.websvc.webservices.WebServicesViewAccessor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class WebServicesView {
    private WebServicesViewImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebServicesViewProvider.class));

    private WebServicesView(WebServicesViewImpl webServicesViewImpl) {
        if (webServicesViewImpl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = webServicesViewImpl;
    }

    public static WebServicesView getWebServicesView(FileObject fileObject) {
        if (fileObject != null) {
            for (WebServicesViewProvider webServicesViewProvider : implementations.allInstances()) {
                WebServicesView webServicesView = webServicesViewProvider.findWebServicesView(fileObject);
                if (webServicesView == null) continue;
                return webServicesView;
            }
        }
        return null;
    }

    public Node createWebServicesView(FileObject fileObject) {
        return this.impl.createWebServicesView(fileObject);
    }

    static {
        WebServicesViewAccessor.DEFAULT = new WebServicesViewAccessor(){

            public WebServicesView createWebServicesView(WebServicesViewImpl webServicesViewImpl) {
                return new WebServicesView(webServicesViewImpl);
            }

            public WebServicesViewImpl getWebServicesViewImpl(WebServicesView webServicesView) {
                return webServicesView == null ? null : webServicesView.impl;
            }
        };
    }
}

