/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;

public class ExamineManifest {
    private File jarFile;
    private File manifestFile;
    private boolean netbeansModule;
    private boolean localized;
    private String specVersion;
    private String implVersion;
    private String module;
    private String moduleDeps;
    private String locBundle;
    private boolean publicPackages;
    private boolean populateDependencies = false;
    private List dependencyTokens = Collections.EMPTY_LIST;

    public void checkFile() throws MojoExecutionException {
        this.resetExamination();
        Manifest manifest = null;
        if (this.jarFile != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(this.jarFile);
                manifest = jarFile.getManifest();
            }
            catch (Exception exception) {
                throw new MojoExecutionException(exception.getMessage(), exception);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
                    }
                }
            }
        }
        if (this.manifestFile != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.manifestFile);
                manifest = new Manifest(fileInputStream);
            }
            catch (Exception exception) {
                throw new MojoExecutionException(exception.getMessage(), exception);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
                    }
                }
            }
        }
        if (manifest == null) {
            throw new MojoExecutionException("Cannot read jar file or manifest file");
        }
        this.processManifest(manifest);
    }

    void resetExamination() {
        this.setNetbeansModule(false);
        this.setLocalized(false);
        this.setSpecVersion(null);
        this.setImplVersion(null);
        this.setModule(null);
        this.setModuleDeps(null);
        this.setLocBundle(null);
        this.setPublicPackages(false);
    }

    void processManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.setModule(attributes.getValue("OpenIDE-Module"));
        this.setNetbeansModule(this.getModule() != null);
        if (this.isNetbeansModule()) {
            String string;
            this.setLocBundle(attributes.getValue("OpenIDE-Module-Localizing-Bundle"));
            this.setLocalized(this.getLocBundle() != null);
            this.setSpecVersion(attributes.getValue("OpenIDE-Module-Specification-Version"));
            this.setImplVersion(attributes.getValue("OpenIDE-Module-Implementation-Version"));
            this.setModuleDeps(attributes.getValue("OpenIDE-Module-Module-Dependencies"));
            String string2 = attributes.getValue("OpenIDE-Module-Public-Packages");
            if (attributes.getValue("OpenIDE-Module-Friends") != null || string2 == null || string2.trim().equals("-")) {
                this.setPublicPackages(false);
            } else {
                this.setPublicPackages(true);
            }
            if (this.isPopulateDependencies() && (string = attributes.getValue("OpenIDE-Module-Module-Dependencies")) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    int n;
                    String string3 = stringTokenizer.nextToken();
                    int n2 = string3.indexOf(">");
                    if (n2 <= 0 && (string3.indexOf("=") != -1 || n2 != -1)) continue;
                    if (n2 > 0) {
                        string3 = string3.substring(0, n2 - 1);
                    }
                    if ((n = string3.indexOf("/")) > 0) {
                        string3 = string3.substring(0, n - 1);
                    }
                    arrayList.add(string3.trim());
                }
                this.setDependencyTokens(arrayList);
            }
        } else {
            this.setSpecVersion(attributes.getValue("Specification-Version"));
            this.setImplVersion(attributes.getValue("Implementation-Version"));
            this.setModule(attributes.getValue("Package"));
            this.setPublicPackages(false);
            if (this.getModule() == null) {
                this.setModule(attributes.getValue("Extension-Name"));
            }
        }
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(File file) {
        this.jarFile = file;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(File file) {
        this.manifestFile = file;
    }

    public boolean isNetbeansModule() {
        return this.netbeansModule;
    }

    public void setNetbeansModule(boolean bl) {
        this.netbeansModule = bl;
    }

    public boolean isLocalized() {
        return this.localized;
    }

    public void setLocalized(boolean bl) {
        this.localized = bl;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String string) {
        this.specVersion = string;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public void setImplVersion(String string) {
        this.implVersion = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getModuleDeps() {
        return this.moduleDeps;
    }

    public void setModuleDeps(String string) {
        this.moduleDeps = string;
    }

    public String getLocBundle() {
        return this.locBundle;
    }

    public void setLocBundle(String string) {
        this.locBundle = string;
    }

    public boolean hasPublicPackages() {
        return this.publicPackages;
    }

    public void setPublicPackages(boolean bl) {
        this.publicPackages = bl;
    }

    public boolean isPopulateDependencies() {
        return this.populateDependencies;
    }

    public void setPopulateDependencies(boolean bl) {
        this.populateDependencies = bl;
    }

    public List getDependencyTokens() {
        return this.dependencyTokens;
    }

    public void setDependencyTokens(List list) {
        this.dependencyTokens = list;
    }
}

