/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.AbstractInterp;
import org.netbeans.lib.terminalemulator.InterpDumb;
import org.netbeans.lib.terminalemulator.Ops;

public class InterpANSI
extends InterpDumb {
    private InterpTypeANSI type;
    public static final InterpTypeANSI type_singleton = new InterpTypeANSI();

    public InterpANSI(Ops ops) {
        super(ops, type_singleton);
        this.type = type_singleton;
        this.setup();
    }

    protected InterpANSI(Ops ops, InterpTypeANSI interpTypeANSI) {
        super(ops, interpTypeANSI);
        this.type = interpTypeANSI;
        this.setup();
    }

    public String name() {
        return "ansi";
    }

    public void reset() {
        super.reset();
    }

    private void setup() {
        this.state = this.type.st_base;
    }

    protected static class InterpTypeANSI
    extends InterpDumb.InterpTypeDumb {
        protected final AbstractInterp.State st_esc = new AbstractInterp.State("esc");
        protected final AbstractInterp.State st_esc_lb = new AbstractInterp.State("esc_lb");
        protected final AbstractInterp.Actor act_reset_number = new ACT_RESET_NUMBER();
        protected final AbstractInterp.Actor act_remember_digit = new ACT_REMEMBER_DIGIT();

        protected InterpTypeANSI() {
            this.st_base.setAction('\u001b', this.st_esc, new ACT_TO_ESC());
            this.st_base.setAction('\u000e', this.st_base, new ACT_AS());
            this.st_base.setAction('\u000f', this.st_base, new ACT_AE());
            this.st_esc.setRegular(this.st_esc, this.act_regular);
            this.st_esc.setAction('7', this.st_base, new ACT_SC());
            this.st_esc.setAction('8', this.st_base, new ACT_RC());
            this.st_esc.setAction('c', this.st_base, new ACT_FULL_RESET());
            this.st_esc.setAction('[', this.st_esc_lb, this.act_reset_number);
            this.st_esc_lb.setRegular(this.st_esc_lb, this.act_regular);
            for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                this.st_esc_lb.setAction(c, this.st_esc_lb, this.act_remember_digit);
            }
            this.st_esc_lb.setAction(';', this.st_esc_lb, new ACT_PUSH_NUMBER());
            this.st_esc_lb.setAction('A', this.st_base, new ACT_UP());
            this.st_esc_lb.setAction('B', this.st_base, new ACT_DO());
            this.st_esc_lb.setAction('C', this.st_base, new ACT_ND());
            this.st_esc_lb.setAction('D', this.st_base, new ACT_BC());
            this.st_esc_lb.setAction('H', this.st_base, new ACT_HO());
            this.st_esc_lb.setAction('i', this.st_base, new ACT_PRINT());
            this.st_esc_lb.setAction('J', this.st_base, new ACT_J());
            this.st_esc_lb.setAction('K', this.st_base, new ACT_K());
            this.st_esc_lb.setAction('L', this.st_base, new ACT_AL());
            this.st_esc_lb.setAction('M', this.st_base, new ACT_DL());
            this.st_esc_lb.setAction('m', this.st_base, new ACT_ATTR());
            this.st_esc_lb.setAction('n', this.st_base, new ACT_DSR());
            this.st_esc_lb.setAction('P', this.st_base, new ACT_DC());
            this.st_esc_lb.setAction('h', this.st_base, new ACT_SM());
            this.st_esc_lb.setAction('l', this.st_base, new ACT_RM());
            this.st_esc_lb.setAction('r', this.st_base, new ACT_MARGIN());
            this.st_esc_lb.setAction('t', this.st_base, new ACT_GLYPH());
            this.st_esc_lb.setAction('@', this.st_base, new ACT_IC());
        }

        static final class ACT_GLYPH
        implements AbstractInterp.Actor {
            ACT_GLYPH() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    return "ACT GLYPH: missing number";
                }
                int n = abstractInterp.numberAt(0);
                int n2 = abstractInterp.numberAt(1);
                int n3 = abstractInterp.numberAt(2);
                if (n != 22) {
                    return "ACT GLYPH: op othger than 22 not supported";
                }
                abstractInterp.ops.op_glyph(n2, n3);
                return null;
            }
        }

        static final class ACT_DSR
        implements AbstractInterp.Actor {
            ACT_DSR() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_status_report(5);
                } else {
                    abstractInterp.ops.op_status_report(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_ATTR
        implements AbstractInterp.Actor {
            ACT_ATTR() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_attr(0);
                } else {
                    for (int i = 0; i <= abstractInterp.nNumbers(); ++i) {
                        abstractInterp.ops.op_attr(abstractInterp.numberAt(i));
                    }
                }
                return null;
            }
        }

        static final class ACT_AE
        implements AbstractInterp.Actor {
            ACT_AE() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                abstractInterp.ops.op_ae();
                return null;
            }
        }

        static final class ACT_AS
        implements AbstractInterp.Actor {
            ACT_AS() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                abstractInterp.ops.op_as();
                return null;
            }
        }

        static final class ACT_AL
        implements AbstractInterp.Actor {
            ACT_AL() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_al(1);
                } else {
                    abstractInterp.ops.op_al(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_K
        implements AbstractInterp.Actor {
            ACT_K() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_ce();
                } else {
                    int n = abstractInterp.numberAt(0);
                    if (n == 1) {
                        return "ACT K: count of 1 not supported";
                    }
                    if (n == 2) {
                        return "ACT K: count of 2 not supported";
                    }
                }
                return null;
            }
        }

        static final class ACT_J
        implements AbstractInterp.Actor {
            ACT_J() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_cd();
                } else {
                    int n = abstractInterp.numberAt(0);
                    if (n == 1) {
                        return "ACT J: count of 1 not supported";
                    }
                    if (n == 2) {
                        abstractInterp.ops.op_cl();
                    }
                }
                return null;
            }
        }

        static final class ACT_PRINT
        implements AbstractInterp.Actor {
            ACT_PRINT() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (!abstractInterp.noNumber()) {
                    switch (abstractInterp.numberAt(0)) {
                        case 1: 
                        case 4: 
                        case 5: {
                            break;
                        }
                        case 10: {
                            abstractInterp.ops.op_time(true);
                            break;
                        }
                        case 11: {
                            abstractInterp.ops.op_time(false);
                        }
                    }
                }
                return null;
            }
        }

        static final class ACT_HO
        implements AbstractInterp.Actor {
            ACT_HO() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_ho();
                } else {
                    abstractInterp.ops.op_cm(abstractInterp.numberAt(0), abstractInterp.numberAt(1));
                }
                return null;
            }
        }

        static final class ACT_DL
        implements AbstractInterp.Actor {
            ACT_DL() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_dl(1);
                } else {
                    abstractInterp.ops.op_dl(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_IC
        implements AbstractInterp.Actor {
            ACT_IC() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_ic(1);
                } else {
                    abstractInterp.ops.op_ic(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_RM
        implements AbstractInterp.Actor {
            ACT_RM() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_reset_mode(1);
                } else {
                    abstractInterp.ops.op_reset_mode(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_SM
        implements AbstractInterp.Actor {
            ACT_SM() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_set_mode(1);
                } else {
                    abstractInterp.ops.op_set_mode(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_DC
        implements AbstractInterp.Actor {
            ACT_DC() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_dc(1);
                } else {
                    abstractInterp.ops.op_dc(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_MARGIN
        implements AbstractInterp.Actor {
            ACT_MARGIN() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_margin(0, 0);
                } else {
                    abstractInterp.ops.op_margin(abstractInterp.numberAt(0), abstractInterp.numberAt(1));
                }
                return null;
            }
        }

        static final class ACT_BC
        implements AbstractInterp.Actor {
            ACT_BC() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_bc(1);
                } else {
                    abstractInterp.ops.op_bc(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_ND
        implements AbstractInterp.Actor {
            ACT_ND() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_nd(1);
                } else {
                    abstractInterp.ops.op_nd(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_DO
        implements AbstractInterp.Actor {
            ACT_DO() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_do(1);
                } else {
                    abstractInterp.ops.op_do(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_UP
        implements AbstractInterp.Actor {
            ACT_UP() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (abstractInterp.noNumber()) {
                    abstractInterp.ops.op_up(1);
                } else {
                    abstractInterp.ops.op_up(abstractInterp.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_PUSH_NUMBER
        implements AbstractInterp.Actor {
            ACT_PUSH_NUMBER() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                if (!abstractInterp.pushNumber()) {
                    return "ACT PUSH_NUMBER";
                }
                return null;
            }
        }

        static final class ACT_REMEMBER_DIGIT
        implements AbstractInterp.Actor {
            ACT_REMEMBER_DIGIT() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                abstractInterp.remember_digit(c);
                return null;
            }
        }

        static class ACT_RESET_NUMBER
        implements AbstractInterp.Actor {
            ACT_RESET_NUMBER() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                abstractInterp.resetNumber();
                return null;
            }
        }

        static final class ACT_FULL_RESET
        implements AbstractInterp.Actor {
            ACT_FULL_RESET() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                abstractInterp.ops.op_full_reset();
                return null;
            }
        }

        static final class ACT_RC
        implements AbstractInterp.Actor {
            ACT_RC() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                abstractInterp.ops.op_rc();
                return null;
            }
        }

        static final class ACT_SC
        implements AbstractInterp.Actor {
            ACT_SC() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                abstractInterp.ops.op_sc();
                return null;
            }
        }

        static final class ACT_TO_ESC
        implements AbstractInterp.Actor {
            ACT_TO_ESC() {
            }

            public String action(AbstractInterp abstractInterp, char c) {
                InterpDumb interpDumb = (InterpDumb)abstractInterp;
                interpDumb.ctl_sequence = "";
                return null;
            }
        }
    }

    private static class Ascii {
        public static final char ESC = '\u001b';
        public static final char CTRL_N = '\u000e';
        public static final char CTRL_O = '\u000f';

        private Ascii() {
        }
    }
}

