/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.eecommon.api.Utils;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorListener
implements PropertyChangeListener {
    private final GlassfishConfiguration config;
    private RootInterface stdRootDD = null;
    private PropertyChangeListener stdRootDDWeakListener = null;
    private RootInterface wsRootDD = null;
    private PropertyChangeListener wsRootDDWeakListener = null;
    private static final int EVENT_DELAY = 100;
    private PropertyChangeEvent lastEvent = null;
    private final Object lastEventMonitor = new Object();
    private final RequestProcessor.Task lastEventTask = RequestProcessor.getDefault().create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = DescriptorListener.this.lastEventMonitor;
            synchronized (object) {
                if (DescriptorListener.this.lastEvent != null) {
                    DescriptorListener.this.processEvent(DescriptorListener.this.lastEvent);
                    DescriptorListener.this.lastEvent = null;
                }
            }
        }
    }, true);
    private static WeakHashMap<Class, WeakReference<NameVisitor>> visitorCache = new WeakHashMap();
    private static final List<NameVisitorFactory> nameVisitorFactories = new CopyOnWriteArrayList<NameVisitorFactory>();
    private static Map<String, BeanVisitor> handlerCache;

    public DescriptorListener(GlassfishConfiguration glassfishConfiguration) {
        this.config = glassfishConfiguration;
    }

    public void addListener(RootInterface rootInterface) {
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)rootInterface);
        if (rootInterface instanceof Webservices) {
            if (this.wsRootDD != null && this.wsRootDDWeakListener != null) {
                this.wsRootDD.removePropertyChangeListener(this.wsRootDDWeakListener);
            }
            this.wsRootDD = rootInterface;
            this.wsRootDDWeakListener = propertyChangeListener;
        } else {
            if (this.stdRootDD != null && this.stdRootDDWeakListener != null) {
                this.stdRootDD.removePropertyChangeListener(this.stdRootDDWeakListener);
            }
            this.stdRootDD = rootInterface;
            this.stdRootDDWeakListener = propertyChangeListener;
        }
        rootInterface.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeListener(RootInterface rootInterface) {
        if (this.wsRootDD == rootInterface) {
            this.wsRootDD.removePropertyChangeListener(this.wsRootDDWeakListener);
            this.wsRootDDWeakListener = null;
            this.wsRootDD = null;
        } else if (this.stdRootDD == rootInterface) {
            this.stdRootDD.removePropertyChangeListener(this.stdRootDDWeakListener);
            this.stdRootDDWeakListener = null;
            this.stdRootDD = null;
        }
    }

    public void removeListeners() {
        if (this.stdRootDD != null) {
            this.removeListener(this.stdRootDD);
        }
        if (this.wsRootDD != null) {
            this.removeListener(this.wsRootDD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.lastEventMonitor;
        synchronized (object) {
            Logger.getLogger("glassfish-eecommon").log(Level.FINEST, "RAW EVENT: " + propertyChangeEvent.getPropertyName() + ", old = " + propertyChangeEvent.getOldValue() + ", new = " + propertyChangeEvent.getNewValue() + ", source = " + propertyChangeEvent.getSource());
            if (this.lastEvent != null) {
                this.lastEventTask.cancel();
                if (!(this.isCreateBeanEvent(propertyChangeEvent) && this.isVeiledRenameEvent(this.lastEvent, propertyChangeEvent) && this.processAsChangeNameEvent(this.lastEvent, propertyChangeEvent))) {
                    this.processEvent(this.lastEvent);
                    this.processEvent(propertyChangeEvent);
                }
                this.lastEvent = null;
            } else if (this.isDeleteBeanEvent(propertyChangeEvent)) {
                this.lastEvent = propertyChangeEvent;
                this.lastEventTask.schedule(100);
            } else {
                this.processEvent(propertyChangeEvent);
            }
        }
    }

    private boolean isDeleteBeanEvent(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getOldValue() instanceof CommonDDBean && propertyChangeEvent.getNewValue() == null;
    }

    private boolean isCreateBeanEvent(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() instanceof CommonDDBean;
    }

    private boolean isVeiledRenameEvent(PropertyChangeEvent propertyChangeEvent, PropertyChangeEvent propertyChangeEvent2) {
        if (propertyChangeEvent.getSource() != propertyChangeEvent2.getSource()) {
            return false;
        }
        if (!propertyChangeEvent.getOldValue().getClass().equals(propertyChangeEvent2.getNewValue().getClass())) {
            return false;
        }
        return DescriptorListener.xcompare(propertyChangeEvent.getPropertyName(), propertyChangeEvent2.getPropertyName());
    }

    private boolean processAsChangeNameEvent(PropertyChangeEvent propertyChangeEvent, PropertyChangeEvent propertyChangeEvent2) {
        boolean bl = false;
        CommonDDBean commonDDBean = (CommonDDBean)propertyChangeEvent2.getNewValue();
        NameVisitor nameVisitor = DescriptorListener.getNameVisitor(commonDDBean);
        if (nameVisitor != null) {
            String string;
            CommonDDBean commonDDBean2 = (CommonDDBean)propertyChangeEvent.getOldValue();
            String string2 = nameVisitor.getName(commonDDBean2);
            if (!Utils.strEquals(string2, string = nameVisitor.getName(commonDDBean))) {
                PropertyChangeEvent propertyChangeEvent3 = new PropertyChangeEvent(commonDDBean, propertyChangeEvent2.getPropertyName() + nameVisitor.getNameProperty(), string2, string);
                Logger.getLogger("glassfish-eecommon").log(Level.FINE, "processing delete/create sequence as change name event.");
                this.processEvent(propertyChangeEvent3);
                bl = true;
            }
        } else {
            Logger.getLogger("glassfish-eecommon").log(Level.FINE, "No support for delete/create sequence from type " + commonDDBean.getClass().getSimpleName());
        }
        return bl;
    }

    private void processEvent(PropertyChangeEvent propertyChangeEvent) {
        Logger.getLogger("glassfish-eecommon").log(Level.FINER, "PROCESSED EVENT: " + propertyChangeEvent.getPropertyName() + ", old = " + propertyChangeEvent.getOldValue() + ", new = " + propertyChangeEvent.getNewValue() + ", source = " + propertyChangeEvent.getSource());
        String string = this.makeXpath(propertyChangeEvent.getPropertyName());
        BeanVisitor beanVisitor = handlerCache.get(string);
        if (beanVisitor != null) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object == null) {
                if (object2 instanceof CommonDDBean) {
                    beanVisitor.beanCreated(this.config, string, (CommonDDBean)propertyChangeEvent.getSource(), (CommonDDBean)object2);
                } else if (object2 != null) {
                    beanVisitor.fieldCreated(this.config, string, (CommonDDBean)propertyChangeEvent.getSource(), object2);
                }
            } else if (object2 == null) {
                if (object instanceof CommonDDBean) {
                    beanVisitor.beanDeleted(this.config, string, (CommonDDBean)propertyChangeEvent.getSource(), (CommonDDBean)object);
                } else if (object != null) {
                    beanVisitor.fieldDeleted(this.config, string, (CommonDDBean)propertyChangeEvent.getSource(), object);
                }
            } else if (object instanceof CommonDDBean && object2 instanceof CommonDDBean) {
                beanVisitor.beanChanged(this.config, string, (CommonDDBean)propertyChangeEvent.getSource(), (CommonDDBean)object, (CommonDDBean)object2);
            } else if (object != null && object2 != null) {
                beanVisitor.fieldChanged(this.config, string, (CommonDDBean)propertyChangeEvent.getSource(), object, object2);
            }
        }
    }

    private String makeXpath(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                while (++i < n && (c = string.charAt(i)) != '/') {
                }
            }
            if (i >= n) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean xcompare(String string, String string2) {
        int n;
        boolean bl = true;
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = 0;
        for (n = 0; n4 < n2 && n < n3; ++n4, ++n) {
            char c;
            char c2 = string.charAt(n4);
            if (c2 == (c = string2.charAt(n))) {
                if (c2 != '.') continue;
                boolean bl2 = false;
                boolean bl3 = false;
                while (++n4 < n2) {
                    if (string.charAt(n4) != '/') continue;
                    bl2 = true;
                    break;
                }
                while (++n < n3) {
                    if (string2.charAt(n) != '/') continue;
                    bl3 = true;
                    break;
                }
                if (bl2 == bl3) continue;
                bl = false;
                break;
            }
            bl = false;
            break;
        }
        if (bl && (n4 < n2 || n < n3)) {
            bl = false;
        }
        return bl;
    }

    public static synchronized NameVisitor getNameVisitor(CommonDDBean commonDDBean) {
        NameVisitor nameVisitor = null;
        Class<?> clazz = commonDDBean.getClass();
        WeakReference<NameVisitor> weakReference = visitorCache.get(clazz);
        if (weakReference != null) {
            nameVisitor = (NameVisitor)weakReference.get();
        }
        if (nameVisitor == null && (nameVisitor = DescriptorListener.createNameVisitor(commonDDBean)) != null) {
            visitorCache.put(clazz, new WeakReference<NameVisitor>(nameVisitor));
        }
        return nameVisitor;
    }

    public static void addNameVisitorFactory(NameVisitorFactory nameVisitorFactory) {
        nameVisitorFactories.add(nameVisitorFactory);
    }

    private static final NameVisitor createNameVisitor(CommonDDBean commonDDBean) {
        NameVisitorFactory nameVisitorFactory;
        NameVisitor nameVisitor = null;
        Iterator<NameVisitorFactory> iterator = nameVisitorFactories.iterator();
        while (iterator.hasNext() && (nameVisitor = (nameVisitorFactory = iterator.next()).createNameVisitor(commonDDBean)) == null) {
        }
        return nameVisitor;
    }

    public static void addBeanVisitorMappings(Map<String, BeanVisitor> map) {
        handlerCache.putAll(map);
    }

    private static void initBeanVisitorMap() {
        EntityAndSessionVisitor entityAndSessionVisitor = new EntityAndSessionVisitor();
        EntityAndSessionRemoteVisitor entityAndSessionRemoteVisitor = new EntityAndSessionRemoteVisitor();
        handlerCache.put("/EjbJar/EnterpriseBeans", entityAndSessionVisitor);
        handlerCache.put("/EjbJar/EnterpriseBeans/Session", entityAndSessionVisitor);
        handlerCache.put("/EjbJar/EnterpriseBeans/Session/Remote", entityAndSessionRemoteVisitor);
        handlerCache.put("/EjbJar/EnterpriseBeans/Entity", entityAndSessionVisitor);
        handlerCache.put("/EjbJar/EnterpriseBeans/Entity/Remote", entityAndSessionRemoteVisitor);
        WebserviceDescriptionBeanVisitor webserviceDescriptionBeanVisitor = new WebserviceDescriptionBeanVisitor();
        handlerCache.put("/Webservices/WebserviceDescription", webserviceDescriptionBeanVisitor);
        handlerCache.put("/Webservices/WebserviceDescription/PortComponent", webserviceDescriptionBeanVisitor);
    }

    static {
        nameVisitorFactories.add(new BasicNameVisitorFactory());
        handlerCache = new HashMap<String, BeanVisitor>(37);
        DescriptorListener.initBeanVisitorMap();
    }

    public static final class MessageDrivenVisitor
    extends AbstractBeanVisitor {
        public void beanCreated(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2) {
            this.mdbUpdated(glassfishConfiguration, (MessageDriven)commonDDBean2, GlassfishConfiguration.ChangeOperation.CREATE);
        }

        public void beanDeleted(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2) {
            this.mdbUpdated(glassfishConfiguration, (MessageDriven)commonDDBean2, GlassfishConfiguration.ChangeOperation.DELETE);
        }

        private void mdbUpdated(GlassfishConfiguration glassfishConfiguration, MessageDriven messageDriven, GlassfishConfiguration.ChangeOperation changeOperation) {
            String string = messageDriven.getEjbName();
            if (Utils.notEmpty(string)) {
                glassfishConfiguration.updateDefaultEjbJndiName(string, "jms/", changeOperation);
            }
        }
    }

    public static final class EntityAndSessionRemoteVisitor
    extends AbstractBeanVisitor {
        public void fieldCreated(GlassfishConfiguration glassfishConfiguration, String string, Object object, Object object2) {
            this.remoteFieldUpdated(glassfishConfiguration, (EntityAndSession)object, (String)object2, GlassfishConfiguration.ChangeOperation.CREATE);
        }

        public void fieldDeleted(GlassfishConfiguration glassfishConfiguration, String string, Object object, Object object2) {
            this.remoteFieldUpdated(glassfishConfiguration, (EntityAndSession)object, null, GlassfishConfiguration.ChangeOperation.DELETE);
        }

        private void remoteFieldUpdated(GlassfishConfiguration glassfishConfiguration, EntityAndSession entityAndSession, String string, GlassfishConfiguration.ChangeOperation changeOperation) {
            String string2 = entityAndSession.getEjbName();
            if (Utils.notEmpty(string2) && (changeOperation == GlassfishConfiguration.ChangeOperation.DELETE || Utils.notEmpty(string))) {
                glassfishConfiguration.updateDefaultEjbJndiName(string2, "ejb/", changeOperation);
            }
        }
    }

    public static class EntityAndSessionVisitor
    extends AbstractBeanVisitor {
        public void beanCreated(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2) {
            if (commonDDBean2 instanceof EntityAndSession) {
                this.entitySessionUpdated(glassfishConfiguration, (EntityAndSession)commonDDBean2, GlassfishConfiguration.ChangeOperation.CREATE);
            } else if (commonDDBean2 instanceof EnterpriseBeans) {
                this.enterpriseBeansUpdated(glassfishConfiguration, (EnterpriseBeans)commonDDBean2, GlassfishConfiguration.ChangeOperation.CREATE);
            }
        }

        public void beanDeleted(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2) {
            if (commonDDBean2 instanceof EntityAndSession) {
                this.entitySessionUpdated(glassfishConfiguration, (EntityAndSession)commonDDBean2, GlassfishConfiguration.ChangeOperation.DELETE);
            } else if (commonDDBean2 instanceof EnterpriseBeans) {
                this.enterpriseBeansUpdated(glassfishConfiguration, (EnterpriseBeans)commonDDBean2, GlassfishConfiguration.ChangeOperation.DELETE);
            }
        }

        private void enterpriseBeansUpdated(GlassfishConfiguration glassfishConfiguration, EnterpriseBeans enterpriseBeans, GlassfishConfiguration.ChangeOperation changeOperation) {
            Entity[] entityArray;
            Session[] sessionArray = enterpriseBeans.getSession();
            if (sessionArray != null && sessionArray.length > 0) {
                entityArray = sessionArray;
                int n = entityArray.length;
                for (int i = 0; i < n; ++i) {
                    Entity entity = entityArray[i];
                    if (entity == null) continue;
                    this.entitySessionUpdated(glassfishConfiguration, (EntityAndSession)entity, changeOperation);
                }
            }
            if ((entityArray = enterpriseBeans.getEntity()) != null && entityArray.length > 0) {
                for (Entity entity : entityArray) {
                    if (entity == null) continue;
                    this.entitySessionUpdated(glassfishConfiguration, (EntityAndSession)entity, changeOperation);
                }
            }
        }

        private void entitySessionUpdated(GlassfishConfiguration glassfishConfiguration, EntityAndSession entityAndSession, GlassfishConfiguration.ChangeOperation changeOperation) {
            String string = entityAndSession.getEjbName();
            String string2 = entityAndSession.getRemote();
            if (Utils.notEmpty(string) && (changeOperation == GlassfishConfiguration.ChangeOperation.DELETE || Utils.notEmpty(string2))) {
                glassfishConfiguration.updateDefaultEjbJndiName(string, "ejb/", changeOperation);
            }
        }
    }

    public static final class WebserviceDescriptionBeanVisitor
    extends AbstractBeanVisitor {
        public void beanCreated(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2) {
            if (commonDDBean2 instanceof WebserviceDescription) {
                this.webserviceDescriptionUpdated(glassfishConfiguration, (WebserviceDescription)commonDDBean2, GlassfishConfiguration.ChangeOperation.CREATE);
            } else if (commonDDBean2 instanceof PortComponent) {
                this.portComponentUpdated(glassfishConfiguration, (PortComponent)commonDDBean2, GlassfishConfiguration.ChangeOperation.CREATE);
            }
        }

        public void beanDeleted(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2) {
            if (commonDDBean2 instanceof WebserviceDescription) {
                this.webserviceDescriptionUpdated(glassfishConfiguration, (WebserviceDescription)commonDDBean2, GlassfishConfiguration.ChangeOperation.DELETE);
            } else if (commonDDBean2 instanceof PortComponent) {
                this.portComponentUpdated(glassfishConfiguration, (PortComponent)commonDDBean2, GlassfishConfiguration.ChangeOperation.DELETE);
            }
        }

        private void webserviceDescriptionUpdated(GlassfishConfiguration glassfishConfiguration, WebserviceDescription webserviceDescription, GlassfishConfiguration.ChangeOperation changeOperation) {
            PortComponent[] portComponentArray = webserviceDescription.getPortComponent();
            if (portComponentArray != null && portComponentArray.length > 0) {
                for (PortComponent portComponent : portComponentArray) {
                    if (portComponent == null) continue;
                    this.portComponentUpdated(glassfishConfiguration, portComponent, changeOperation);
                }
            }
        }

        private void portComponentUpdated(GlassfishConfiguration glassfishConfiguration, PortComponent portComponent, GlassfishConfiguration.ChangeOperation changeOperation) {
            String string = portComponent.getPortComponentName();
            String string2 = this.getLinkName(portComponent);
            if (Utils.notEmpty(string) && Utils.notEmpty(string2)) {
                glassfishConfiguration.updateDefaultEjbEndpointUri(string2, string, changeOperation);
            }
        }

        private String getLinkName(PortComponent portComponent) {
            String string = null;
            ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
            if (serviceImplBean != null && (string = serviceImplBean.getServletLink()) == null) {
                string = serviceImplBean.getEjbLink();
            }
            return string;
        }
    }

    public static abstract class AbstractBeanVisitor
    implements BeanVisitor {
        public void beanCreated(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2) {
        }

        public void beanDeleted(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2) {
        }

        public void beanChanged(GlassfishConfiguration glassfishConfiguration, String string, CommonDDBean commonDDBean, CommonDDBean commonDDBean2, CommonDDBean commonDDBean3) {
        }

        public void fieldCreated(GlassfishConfiguration glassfishConfiguration, String string, Object object, Object object2) {
        }

        public void fieldDeleted(GlassfishConfiguration glassfishConfiguration, String string, Object object, Object object2) {
        }

        public void fieldChanged(GlassfishConfiguration glassfishConfiguration, String string, Object object, Object object2, Object object3) {
        }
    }

    public static interface BeanVisitor {
        public void beanCreated(GlassfishConfiguration var1, String var2, CommonDDBean var3, CommonDDBean var4);

        public void beanDeleted(GlassfishConfiguration var1, String var2, CommonDDBean var3, CommonDDBean var4);

        public void beanChanged(GlassfishConfiguration var1, String var2, CommonDDBean var3, CommonDDBean var4, CommonDDBean var5);

        public void fieldCreated(GlassfishConfiguration var1, String var2, Object var3, Object var4);

        public void fieldDeleted(GlassfishConfiguration var1, String var2, Object var3, Object var4);

        public void fieldChanged(GlassfishConfiguration var1, String var2, Object var3, Object var4, Object var5);
    }

    public static class SecurityRoleVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((SecurityRole)commonDDBean).getRoleName();
        }

        public String getNameProperty() {
            return "/RoleName";
        }
    }

    public static class MessageDestinationVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((MessageDestination)commonDDBean).getMessageDestinationName();
        }

        public String getNameProperty() {
            return "/MessageDestinationName";
        }
    }

    public static class PortComponentVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((PortComponent)commonDDBean).getPortComponentName();
        }

        public String getNameProperty() {
            return "/PortComponentName";
        }
    }

    public static class PortComponentRefVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((PortComponentRef)commonDDBean).getServiceEndpointInterface();
        }

        public String getNameProperty() {
            return "/ServiceEndpointInterface";
        }
    }

    public static class ServiceRefVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((ServiceRef)commonDDBean).getServiceRefName();
        }

        public String getNameProperty() {
            return "/ServiceRefName";
        }
    }

    public static class ResourceRefVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((ResourceRef)commonDDBean).getResRefName();
        }

        public String getNameProperty() {
            return "/ResRefName";
        }
    }

    public static class ResourceEnvRefVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((ResourceEnvRef)commonDDBean).getResourceEnvRefName();
        }

        public String getNameProperty() {
            return "/ResourceEnvRefName";
        }
    }

    public static class MessageDestinationRefVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((MessageDestinationRef)commonDDBean).getMessageDestinationRefName();
        }

        public String getNameProperty() {
            return "/MessageDestinationRefName";
        }
    }

    public static class EjbRefVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((EjbRef)commonDDBean).getEjbRefName();
        }

        public String getNameProperty() {
            return "/EjbRefName";
        }
    }

    public static class EntityBeanVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((Entity)commonDDBean).getEjbName();
        }

        public String getNameProperty() {
            return "/EjbName";
        }
    }

    public static class MDBeanVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((MessageDriven)commonDDBean).getEjbName();
        }

        public String getNameProperty() {
            return "/EjbName";
        }
    }

    public static class SessionBeanVisitor
    implements NameVisitor {
        public String getName(CommonDDBean commonDDBean) {
            return ((Session)commonDDBean).getEjbName();
        }

        public String getNameProperty() {
            return "/EjbName";
        }
    }

    public static interface NameVisitor {
        public String getName(CommonDDBean var1);

        public String getNameProperty();
    }

    private static final class BasicNameVisitorFactory
    implements NameVisitorFactory {
        private BasicNameVisitorFactory() {
        }

        public NameVisitor createNameVisitor(CommonDDBean commonDDBean) {
            NameVisitor nameVisitor = null;
            if (commonDDBean instanceof Session) {
                nameVisitor = new SessionBeanVisitor();
            } else if (commonDDBean instanceof MessageDriven) {
                nameVisitor = new MDBeanVisitor();
            } else if (commonDDBean instanceof Entity) {
                nameVisitor = new EntityBeanVisitor();
            } else if (commonDDBean instanceof EjbRef) {
                nameVisitor = new EjbRefVisitor();
            } else if (commonDDBean instanceof MessageDestinationRef) {
                nameVisitor = new MessageDestinationRefVisitor();
            } else if (commonDDBean instanceof ResourceEnvRef) {
                nameVisitor = new ResourceEnvRefVisitor();
            } else if (commonDDBean instanceof ResourceRef) {
                nameVisitor = new ResourceRefVisitor();
            } else if (commonDDBean instanceof ServiceRef) {
                nameVisitor = new ServiceRefVisitor();
            } else if (commonDDBean instanceof MessageDestination) {
                nameVisitor = new MessageDestinationVisitor();
            } else if (commonDDBean instanceof SecurityRole) {
                nameVisitor = new SecurityRoleVisitor();
            } else if (commonDDBean instanceof PortComponent) {
                nameVisitor = new PortComponentVisitor();
            } else if (commonDDBean instanceof PortComponentRef) {
                nameVisitor = new PortComponentRefVisitor();
            }
            return nameVisitor;
        }
    }

    public static interface NameVisitorFactory {
        public NameVisitor createNameVisitor(CommonDDBean var1);
    }
}

