/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainEditor {
    private static final String HTTP_PROXY_HOST = "-Dhttp.proxyHost=";
    private static final String HTTP_PROXY_PORT = "-Dhttp.proxyPort=";
    private static final String HTTPS_PROXY_HOST = "-Dhttps.proxyHost=";
    private static final String HTTPS_PROXY_PORT = "-Dhttps.proxyPort=";
    private static final String HTTP_PROXY_NO_HOST = "-Dhttp.nonProxyHosts=";
    private static String SAMPLE_DATASOURCE = "jdbc/sample";
    private static String SAMPLE_CONNPOOL = "SamplePool";
    private static String NBPROFILERNAME = "NetBeansProfiler";
    private static String CONST_USER = "User";
    private static String CONST_PASSWORD = "Password";
    private static String CONST_URL = "URL";
    private static String CONST_LOWER_DATABASE_NAME = "databaseName";
    private static String CONST_LOWER_PORT_NUMBER = "portNumber";
    private static String CONST_DATABASE_NAME = "DatabaseName";
    private static String CONST_PORT_NUMBER = "PortNumber";
    private static String CONST_SID = "SID";
    private static String CONST_SERVER_NAME = "serverName";
    private static String CONST_DRIVER_CLASS = "driverClass";
    private static String CONST_NAME = "name";
    private static String CONST_VALUE = "value";
    private static String CONST_DS_CLASS = "datasource-classname";
    private static String CONST_RES_TYPE = "res-type";
    private static String CONST_JVM_OPTIONS = "jvm-options";
    private static String CONST_DERBY_CONN_ATTRS = "connectionAttributes";
    private static String CONST_JNDINAME = "jndi-name";
    private static String CONST_PROP = "property";
    private static String CONST_POOLNAME = "pool-name";
    private static String CONST_ENABLED = "enabled";
    private static String CONST_OBJTYPE = "object-type";
    private static String CONST_JDBC = "jdbc-resource";
    private static String CONST_CP = "jdbc-connection-pool";
    private static String CONST_AO = "admin-object-resource";
    private String dmLoc;
    private String dmName;
    private boolean isGlassfishV1OrV2;
    static final String[] sysDatasources = new String[]{"jdbc/__TimerPool", "jdbc/__CallFlowPool"};

    public DomainEditor(String string, String string2, boolean bl) {
        this.dmLoc = string;
        this.dmName = string2;
        this.isGlassfishV1OrV2 = bl;
    }

    public String getDomainLocation() {
        String string = this.dmLoc + "/" + this.dmName + "/config/domain.xml";
        return string;
    }

    public Document getDomainDocument() {
        String string = this.getDomainLocation();
        Document document = this.getDomainDocument(string);
        return document;
    }

    public Document getDomainDocument(String string) {
        Document document = this.loadDomainScriptFile(string);
        return document;
    }

    public boolean addProfilerElements(Document document, String string, String[] stringArray) {
        String string2 = this.getDomainLocation();
        this.removeProfiler(document);
        if (string != null || stringArray != null) {
            NodeList nodeList;
            Node node;
            Element element = document.createElement("profiler");
            element.setAttribute("enabled", "true");
            element.setAttribute(CONST_NAME, NBPROFILERNAME);
            if (string != null) {
                element.setAttribute("native-library-path", string);
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    node = document.createElement(CONST_JVM_OPTIONS);
                    Text text = document.createTextNode(this.formatJvmOption(stringArray[i]));
                    node.appendChild(text);
                    element.appendChild(node);
                }
            }
            if ((nodeList = document.getElementsByTagName("java-config")) == null || nodeList.getLength() == 0) {
                System.err.println("ConfigFilesUtils: cannot find 'java-config' section in domain config file " + string2);
                return false;
            }
            node = nodeList.item(0);
            if (node.getFirstChild() != null) {
                node.insertBefore(element, node.getFirstChild());
            } else {
                node.appendChild(element);
            }
        }
        return this.saveDomainScriptFile(document, string2);
    }

    public boolean removeProfilerElements(Document document) {
        boolean bl = this.removeProfiler(document);
        if (bl) {
            return this.saveDomainScriptFile(document, this.getDomainLocation());
        }
        return true;
    }

    private boolean removeProfiler(Document document) {
        NodeList nodeList = document.getElementsByTagName("profiler");
        if (nodeList != null && nodeList.getLength() > 0) {
            Node node;
            int n;
            Vector<Node> vector = new Vector<Node>();
            for (n = 0; n < nodeList.getLength(); ++n) {
                node = nodeList.item(n);
                Node node2 = node.getAttributes().getNamedItem(CONST_NAME);
                if (node2 == null || !node2.getNodeValue().equals(NBPROFILERNAME)) continue;
                vector.add(node);
            }
            for (n = 0; n < vector.size(); ++n) {
                node = (Node)vector.get(n);
                node.getParentNode().removeChild(node);
            }
            return true;
        }
        return false;
    }

    public String[] getHttpProxyOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Document document = this.getDomainDocument();
        NodeList nodeList = document.getElementsByTagName("java-config");
        if (nodeList == null || nodeList.getLength() == 0) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        NodeList nodeList2 = document.getElementsByTagName(CONST_JVM_OPTIONS);
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node;
            String string;
            Node node2 = nodeList2.item(i);
            if (!node2.hasChildNodes() || (string = (node = node2.getFirstChild()).getNodeValue()).indexOf(HTTP_PROXY_HOST) == -1 && string.indexOf(HTTP_PROXY_PORT) == -1 && string.indexOf(HTTPS_PROXY_HOST) == -1 && string.indexOf(HTTPS_PROXY_PORT) == -1 && string.indexOf(HTTP_PROXY_NO_HOST) == -1) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public boolean setHttpProxyOptions(String[] stringArray) {
        Document document = this.getDomainDocument();
        NodeList nodeList = document.getElementsByTagName("java-config");
        if (nodeList == null || nodeList.getLength() == 0) {
            return false;
        }
        this.removeProxyOptions(document, nodeList.item(0));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Element element = document.createElement(CONST_JVM_OPTIONS);
            Text text = document.createTextNode(string);
            element.appendChild(text);
            nodeList.item(0).appendChild(element);
        }
        return this.saveDomainScriptFile(document, this.getDomainLocation(), false);
    }

    private boolean removeProxyOptions(Document document, Node node) {
        int n;
        NodeList nodeList = document.getElementsByTagName(CONST_JVM_OPTIONS);
        Vector<Node> vector = new Vector<Node>();
        for (n = 0; n < nodeList.getLength(); ++n) {
            Node node2;
            String string;
            Node node3 = nodeList.item(n);
            if (!node3.hasChildNodes() || (string = (node2 = node3.getFirstChild()).getNodeValue()).indexOf(HTTP_PROXY_HOST) == -1 && string.indexOf(HTTP_PROXY_PORT) == -1 && string.indexOf(HTTPS_PROXY_HOST) == -1 && string.indexOf(HTTPS_PROXY_PORT) == -1 && string.indexOf(HTTP_PROXY_NO_HOST) == -1) continue;
            vector.add(node3);
        }
        for (n = 0; n < vector.size(); ++n) {
            node.removeChild((Node)vector.get(n));
        }
        return this.saveDomainScriptFile(document, this.getDomainLocation(), false);
    }

    private Document loadDomainScriptFile(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new InnerResolver());
            return documentBuilder.parse(new File(string));
        }
        catch (Exception exception) {
            System.err.println("ConfigFilesUtils: unable to parse domain config file " + string);
            return null;
        }
    }

    private boolean saveDomainScriptFile(Document document, String string) {
        return this.saveDomainScriptFile(document, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveDomainScriptFile(Document document, String string, boolean bl) {
        boolean bl2 = false;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (bl) {
                    transformer.setOutputProperty("indent", "yes");
                }
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("standalone", "no");
                if (document.getDoctype() != null) {
                    transformer.setOutputProperty("doctype-public", document.getDoctype().getPublicId());
                    transformer.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
                }
                if (!this.isGlassfishV1OrV2) {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                }
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(fileWriter);
                transformer.transform(dOMSource, streamResult);
                bl2 = true;
            }
            catch (Exception exception) {
                System.err.println("ConfigFilesUtils: Unable to save domain config file " + string);
                bl2 = false;
            }
        }
        catch (IOException iOException) {
            System.err.println("ConfigFilesUtils: cannot create output stream for domain config file " + string);
            bl2 = false;
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("SunAS8IntegrationProvider: cannot close output stream for " + string);
            }
        }
        return bl2;
    }

    private String formatJvmOption(String string) {
        if (string.indexOf("\"") != -1) {
            if (string.indexOf("\\\"") != -1 && string.indexOf("-agentpath") != -1) {
                String string2 = string.replaceAll("\\\\\"", "#");
                string2 = string2.replaceAll("\\\"", "");
                string2 = string2.replaceAll("#", "\"");
                String string3 = System.getProperty("os.name");
                if (string3.startsWith("Mac OS") || this.isGlassfishV1OrV2) {
                    string2 = "\"" + string2.replaceAll("\\\"", "\\\\\"") + "\"";
                }
                return string2;
            }
            return string.replace('\"', ' ');
        }
        return string;
    }

    public HashMap<String, Map> getSunDatasourcesFromXml() {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        Document document = this.getDomainDocument();
        if (document != null) {
            HashMap<String, NamedNodeMap> hashMap2 = this.getDataSourcesAttrMap(document);
            HashMap<String, Node> hashMap3 = this.getConnPoolsNodeMap(document);
            hashMap2.keySet().removeAll(Arrays.asList(sysDatasources));
            String[] stringArray = hashMap2.keySet().toArray(new String[hashMap2.size()]);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                NamedNodeMap namedNodeMap = hashMap2.get(string);
                String string2 = namedNodeMap.getNamedItem(CONST_POOLNAME).getNodeValue();
                hashMap.put(string, this.getPoolValues(hashMap3, string2));
            }
        }
        return hashMap;
    }

    private HashMap<String, String> getPoolValues(HashMap hashMap, String string) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Node node = (Node)hashMap.get(string);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(CONST_DS_CLASS);
        Node node3 = namedNodeMap.getNamedItem(CONST_RES_TYPE);
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName(CONST_PROP);
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node4 = nodeList.item(i);
            NamedNodeMap namedNodeMap2 = node4.getAttributes();
            String string2 = namedNodeMap2.getNamedItem(CONST_NAME).getNodeValue();
            String string3 = namedNodeMap2.getNamedItem(CONST_VALUE).getNodeValue();
            if (string2.equalsIgnoreCase(CONST_USER)) {
                hashMap2.put(CONST_USER, string3);
                continue;
            }
            if (string2.equalsIgnoreCase(CONST_PASSWORD)) {
                hashMap2.put(CONST_PASSWORD, string3);
                continue;
            }
            if (string2.equalsIgnoreCase(CONST_URL)) {
                hashMap2.put(CONST_URL, string3);
                continue;
            }
            if (string2.equalsIgnoreCase(CONST_SERVER_NAME)) {
                hashMap2.put(CONST_SERVER_NAME, string3);
                continue;
            }
            hashMap3.put(string2, string3);
        }
        hashMap2.put(CONST_LOWER_DATABASE_NAME, (String)hashMap3.get(CONST_LOWER_DATABASE_NAME));
        hashMap2.put(CONST_PORT_NUMBER, (String)hashMap3.get(CONST_PORT_NUMBER));
        hashMap2.put(CONST_LOWER_PORT_NUMBER, (String)hashMap3.get(CONST_LOWER_PORT_NUMBER));
        hashMap2.put(CONST_DATABASE_NAME, (String)hashMap3.get(CONST_DATABASE_NAME));
        hashMap2.put(CONST_SID, (String)hashMap3.get(CONST_SID));
        hashMap2.put(CONST_DRIVER_CLASS, (String)hashMap3.get(CONST_DRIVER_CLASS));
        hashMap2.put(CONST_DERBY_CONN_ATTRS, (String)hashMap3.get(CONST_DERBY_CONN_ATTRS));
        if (node2 != null) {
            hashMap2.put("dsClassName", node2.getNodeValue());
        }
        if (node3 != null) {
            hashMap2.put("resType", node3.getNodeValue());
        }
        return hashMap2;
    }

    public HashMap<String, Map> getConnPoolsFromXml() {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        Document document = this.getDomainDocument();
        if (document != null) {
            HashMap<String, Node> hashMap2 = this.getConnPoolsNodeMap(document);
            String[] stringArray = hashMap2.keySet().toArray(new String[hashMap2.size()]);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                hashMap.put(string, this.getPoolValues(hashMap2, string));
            }
        }
        return hashMap;
    }

    private HashMap<String, NamedNodeMap> getDataSourcesAttrMap(Document document) {
        HashMap<String, NamedNodeMap> hashMap = new HashMap<String, NamedNodeMap>();
        this.updateWithSampleDataSource(document);
        NodeList nodeList = document.getElementsByTagName(CONST_JDBC);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem(CONST_JNDINAME).getNodeValue();
            hashMap.put(string, namedNodeMap);
        }
        return hashMap;
    }

    public void createSampleDatasource() {
        Document document = this.getDomainDocument();
        if (document != null) {
            this.updateWithSampleDataSource(document);
        }
    }

    private boolean updateWithSampleDataSource(Document document) {
        boolean bl = false;
        NodeList nodeList = document.getElementsByTagName(CONST_JDBC);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem(CONST_JNDINAME).getNodeValue();
            if (!string.equals(SAMPLE_DATASOURCE)) continue;
            bl = true;
        }
        if (!bl) {
            return this.createSampleDatasource(document);
        }
        return true;
    }

    private boolean createSampleDatasource(Document document) {
        Object object;
        Node node;
        Node node2;
        NodeList nodeList = document.getElementsByTagName("resources");
        NodeList nodeList2 = document.getElementsByTagName("server");
        if (nodeList == null || nodeList.getLength() == 0 || nodeList2 == null || nodeList2.getLength() == 0) {
            return true;
        }
        Node node3 = nodeList.item(0);
        HashMap<String, Node> hashMap = this.getConnPoolsNodeMap(document);
        if (!hashMap.containsKey(SAMPLE_CONNPOOL)) {
            if (hashMap.size() == 0) {
                System.err.println("Cannot create sample datasource :" + SAMPLE_DATASOURCE);
                return false;
            }
            node2 = (Node)hashMap.values().iterator().next();
            node = node2.cloneNode(false);
            object = node.getAttributes();
            if (object.getNamedItem(CONST_NAME) != null) {
                object.getNamedItem(CONST_NAME).setNodeValue(SAMPLE_CONNPOOL);
            }
            if (object.getNamedItem(CONST_DS_CLASS) != null) {
                object.getNamedItem(CONST_DS_CLASS).setNodeValue("org.apache.derby.jdbc.ClientDataSource");
            }
            if (object.getNamedItem(CONST_RES_TYPE) != null) {
                object.getNamedItem(CONST_RES_TYPE).setNodeValue("javax.sql.DataSource");
            }
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put(CONST_SERVER_NAME, "localhost");
            hashMap2.put(CONST_PASSWORD, "app");
            hashMap2.put(CONST_USER, "app");
            hashMap2.put(CONST_DATABASE_NAME, "sample");
            hashMap2.put(CONST_PORT_NUMBER, "1527");
            hashMap2.put(CONST_URL, "jdbc:derby://localhost:1527/sample");
            Object[] objectArray = hashMap2.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                Element element = document.createElement(CONST_PROP);
                element.setAttribute(CONST_NAME, string);
                element.setAttribute(CONST_VALUE, (String)hashMap2.get(string));
                node.appendChild(element);
            }
            node3.appendChild(node);
        }
        node2 = document.createElement(CONST_JDBC);
        node2.setAttribute(CONST_JNDINAME, SAMPLE_DATASOURCE);
        node2.setAttribute(CONST_POOLNAME, SAMPLE_CONNPOOL);
        node2.setAttribute(CONST_OBJTYPE, "user");
        node2.setAttribute(CONST_ENABLED, "true");
        if (node3.getFirstChild() != null) {
            node3.insertBefore(node2, node3.getFirstChild());
        } else {
            node3.appendChild(node2);
        }
        node = document.createElement("resource-ref");
        node.setAttribute("ref", SAMPLE_DATASOURCE);
        node.setAttribute(CONST_ENABLED, "true");
        object = nodeList2.item(0);
        if (object.getLastChild() != null) {
            object.insertBefore(node, object.getLastChild());
        } else {
            object.appendChild(node);
        }
        return this.saveDomainScriptFile(document, this.getDomainLocation());
    }

    private HashMap<String, Node> getConnPoolsNodeMap(Document document) {
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        NodeList nodeList = document.getElementsByTagName(CONST_CP);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem(CONST_NAME).getNodeValue();
            hashMap.put(string, node);
        }
        return hashMap;
    }

    public HashMap<String, String> getAdminObjectResourcesFromXml() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Document document = this.getDomainDocument();
        if (document != null) {
            NodeList nodeList = document.getElementsByTagName(CONST_AO);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string = namedNodeMap.getNamedItem(CONST_JNDINAME).getNodeValue();
                Node node2 = namedNodeMap.getNamedItem(CONST_RES_TYPE);
                if (node2 == null) continue;
                hashMap.put(string, node2.getNodeValue());
            }
        }
        return hashMap;
    }

    static class InnerResolver
    implements EntityResolver {
        InnerResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            StringReader stringReader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            InputSource inputSource = new InputSource(stringReader);
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
            return inputSource;
        }
    }
}

