/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.modules.cnd.repository.sfs.BufferDataInput;
import org.netbeans.modules.cnd.repository.sfs.FileRWAccess;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class BufferedRWAccess
implements FileRWAccess {
    private RandomAccessFile randomAccessFile;
    protected FileChannel channel;
    private ByteBuffer writeBuffer;
    private int bufSize = Stats.bufSize > 0 ? Stats.bufSize : 32768;

    public BufferedRWAccess(File file) throws IOException {
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        this.channel = this.randomAccessFile.getChannel();
        ByteBuffer.allocateDirect(this.bufSize);
    }

    public Persistent read(PersistentFactory persistentFactory, long l, int n) throws IOException {
        try {
            ByteBuffer byteBuffer = this.getReadBuffer(n);
            this.channel.read(byteBuffer, l);
            byteBuffer.flip();
            BufferDataInput bufferDataInput = new BufferDataInput(byteBuffer);
            return persistentFactory.read((DataInput)bufferDataInput);
        }
        catch (BufferOverflowException bufferOverflowException) {
            bufferOverflowException.printStackTrace(System.err);
            throw bufferOverflowException;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace(System.err);
            throw bufferUnderflowException;
        }
    }

    public int write(PersistentFactory persistentFactory, Persistent persistent, long l) throws IOException {
        this.channel.position(l);
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(this.getWriteBuffer());
        DataOutputStream dataOutputStream = new DataOutputStream(byteBufferOutputStream);
        persistentFactory.write((DataOutput)dataOutputStream, persistent);
        int n = byteBufferOutputStream.count();
        this.writeBuffer();
        return n;
    }

    protected ByteBuffer getWriteBuffer() {
        if (this.writeBuffer == null) {
            this.writeBuffer = ByteBuffer.allocateDirect(this.bufSize);
        }
        return this.writeBuffer;
    }

    protected ByteBuffer getReadBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        return byteBuffer;
    }

    protected void writeBuffer() throws IOException {
        this.writeBuffer.flip();
        this.channel.write(this.writeBuffer);
        this.writeBuffer.clear();
    }

    public long size() throws IOException {
        return this.channel.size();
    }

    public void truncate(long l) throws IOException {
        this.channel.truncate(l);
        this.channel.position(l);
    }

    public void move(long l, int n, long l2) throws IOException {
        ByteBuffer byteBuffer = this.getReadBuffer(n);
        this.channel.read(byteBuffer, l);
        byteBuffer.flip();
        this.channel.write(byteBuffer, l2);
    }

    public void move(FileRWAccess fileRWAccess, long l, int n, long l2) throws IOException {
        if (!(fileRWAccess instanceof BufferedRWAccess)) {
            throw new IllegalArgumentException("Illegal class to move from: " + fileRWAccess.getClass().getName());
        }
        BufferedRWAccess bufferedRWAccess = (BufferedRWAccess)fileRWAccess;
        ByteBuffer byteBuffer = this.getReadBuffer(n);
        bufferedRWAccess.channel.read(byteBuffer, l);
        byteBuffer.flip();
        this.channel.write(byteBuffer, l2);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    private class ByteBufferOutputStream
    extends OutputStream {
        private int oldPosition;
        private int flushed = 0;
        private ByteBuffer buffer;

        public ByteBufferOutputStream(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
            this.oldPosition = byteBuffer.position();
        }

        public void write(int n) throws IOException {
            if (this.buffer.remaining() <= 0) {
                this.flushed += this.buffer.position();
                BufferedRWAccess.this.writeBuffer();
            }
            this.buffer.put((byte)n);
        }

        private int count() {
            return this.flushed + this.buffer.position() - this.oldPosition;
        }
    }
}

