/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.RubyString;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private final IRubyObject io;
    private final CallSite writeAdapter;
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    public IOOutputStream(IRubyObject io2, boolean checkAppend, boolean verifyCanWrite) {
        this.io = io2;
        CallSite writeSite = MethodIndex.getFunctionalCallSite("write");
        if (io2.respondsTo("write")) {
            this.writeAdapter = writeSite;
        } else if (checkAppend && io2.respondsTo("<<")) {
            this.writeAdapter = MethodIndex.getFunctionalCallSite("<<");
        } else {
            if (verifyCanWrite) {
                throw new IllegalArgumentException("Object: " + io2 + " is not a legal argument to this wrapper, " + "cause it doesn't respond to \"write\".");
            }
            this.writeAdapter = writeSite;
        }
    }

    public IOOutputStream(IRubyObject io2) {
        this(io2, true, true);
    }

    public void write(int bite) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, (IRubyObject)RubyString.newStringLight(this.io.getRuntime(), new ByteList(new byte[]{(byte)bite}, false)));
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, (IRubyObject)RubyString.newStringLight(this.io.getRuntime(), new ByteList(b, off, len, false)));
    }

    public void close() throws IOException {
        if (this.io.respondsTo("close")) {
            this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io);
        }
    }
}

