/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.encoding;

import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncodingService {
    private final Ruby runtime;
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> encodings;
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> aliases;
    private final IRubyObject[] encodingList;
    private RubyEncoding[] encodingIndex = new RubyEncoding[4];

    public EncodingService(Ruby runtime2) {
        this.runtime = runtime2;
        this.encodings = EncodingDB.getEncodings();
        this.aliases = EncodingDB.getAliases();
        this.encodingList = new IRubyObject[this.encodings.size()];
        this.defineEncodings();
        this.defineAliases();
    }

    public CaseInsensitiveBytesHash<EncodingDB.Entry> getEncodings() {
        return this.encodings;
    }

    public CaseInsensitiveBytesHash<EncodingDB.Entry> getAliases() {
        return this.aliases;
    }

    public EncodingDB.Entry findEncodingEntry(ByteList bytes2) {
        return this.encodings.get(bytes2.bytes, bytes2.begin, bytes2.begin + bytes2.realSize);
    }

    public EncodingDB.Entry findAliasEntry(ByteList bytes2) {
        return this.aliases.get(bytes2.bytes, bytes2.begin, bytes2.begin + bytes2.realSize);
    }

    public EncodingDB.Entry findEncodingOrAliasEntry(ByteList bytes2) {
        EncodingDB.Entry e = this.findEncodingEntry(bytes2);
        return e != null ? e : this.findAliasEntry(bytes2);
    }

    public IRubyObject[] getEncodingList() {
        return this.encodingList;
    }

    public Encoding loadEncoding(ByteList name2) {
        EncodingDB.Entry entry = this.findEncodingOrAliasEntry(name2);
        Encoding enc = entry.getEncoding();
        int index2 = enc.getIndex();
        if (index2 >= this.encodingIndex.length) {
            RubyEncoding[] tmp = new RubyEncoding[index2 + 4];
            System.arraycopy(this.encodingIndex, 0, tmp, 0, this.encodingIndex.length);
            this.encodingIndex = tmp;
        }
        this.encodingIndex[index2] = (RubyEncoding)this.encodingList[entry.getIndex()];
        return enc;
    }

    public RubyEncoding getEncoding(Encoding enc) {
        RubyEncoding rubyEncoding;
        int index2 = enc.getIndex();
        if (index2 < this.encodingIndex.length && (rubyEncoding = this.encodingIndex[index2]) != null) {
            return rubyEncoding;
        }
        this.loadEncoding(new ByteList(enc.getName(), false));
        return this.encodingIndex[index2];
    }

    private void defineEncodings() {
        Hash.HashEntryIterator hei = this.encodings.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)hei.next();
            EncodingDB.Entry ee = (EncodingDB.Entry)e.value;
            RubyEncoding encoding2 = RubyEncoding.newEncoding(this.runtime, e.bytes, e.p, e.end, ee.isDummy());
            this.encodingList[ee.getIndex()] = encoding2;
            this.defineEncodingConstants(encoding2, e.bytes, e.p, e.end);
        }
    }

    private void defineAliases() {
        Hash.HashEntryIterator hei = this.aliases.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)hei.next();
            EncodingDB.Entry ee = (EncodingDB.Entry)e.value;
            RubyEncoding encoding2 = (RubyEncoding)this.encodingList[ee.getIndex()];
            this.defineEncodingConstants(encoding2, e.bytes, e.p, e.end);
        }
    }

    private void defineEncodingConstants(RubyEncoding encoding2, byte[] name2, int p2, int end2) {
        ASCIIEncoding enc = ASCIIEncoding.INSTANCE;
        int s = p2;
        int code = name2[s] & 0xFF;
        if (enc.isDigit(code)) {
            return;
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        if (enc.isUpper(code)) {
            hasUpper = true;
            while (++s < end2 && (enc.isAlnum(name2[s] & 0xFF) || name2[s] == 95)) {
                if (!enc.isLower(name2[s] & 0xFF)) continue;
                hasLower = true;
            }
        }
        boolean isValid = false;
        if (s >= end2) {
            isValid = true;
            this.defineEncodingConstant(encoding2, name2, p2, end2);
        }
        if (!isValid || hasLower) {
            if (!hasLower || !hasUpper) {
                do {
                    if (enc.isLower(code = name2[s] & 0xFF)) {
                        hasLower = true;
                    }
                    if (!enc.isUpper(code)) continue;
                    hasUpper = true;
                } while (++s < end2 && (!hasLower || !hasUpper));
            }
            byte[] constName = new byte[end2 - p2];
            System.arraycopy(name2, p2, constName, 0, end2 - p2);
            s = 0;
            code = constName[s] & 0xFF;
            if (!isValid) {
                if (enc.isLower(code)) {
                    constName[s] = AsciiTables.ToUpperCaseTable[code];
                }
                while (s < constName.length) {
                    if (!enc.isAlnum(constName[s] & 0xFF)) {
                        constName[s] = 95;
                    }
                    ++s;
                }
                if (hasUpper) {
                    this.defineEncodingConstant(encoding2, constName, 0, constName.length);
                }
            }
            if (hasLower) {
                for (s = 0; s < constName.length; ++s) {
                    code = constName[s] & 0xFF;
                    if (!enc.isLower(code)) continue;
                    constName[s] = AsciiTables.ToUpperCaseTable[code];
                }
                this.defineEncodingConstant(encoding2, constName, 0, constName.length);
            }
        }
    }

    private void defineEncodingConstant(RubyEncoding encoding2, byte[] constName, int constP, int constEnd) {
        this.runtime.getEncoding().defineConstant(new String(constName, constP, constEnd), encoding2);
    }
}

