/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class LocalGlobalVariable
extends GlobalVariable {
    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        String pattern = "([a-z]|_)([a-zA-Z]|_|\\d)*";
        if (name2.matches(pattern)) {
            return new LocalGlobalVariable(runtime2, name2, javaObject);
        }
        return null;
    }

    private LocalGlobalVariable(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    LocalGlobalVariable(String name2, IRubyObject irubyObject) {
        super(name2, irubyObject);
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        GlobalVariables gvars = runtime2.getGlobalVariables();
        Set<String> names2 = gvars.getNames();
        for (String name2 : names2) {
            BiVariable var;
            if (LocalGlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = gvars.get(name2);
            String javaName = name2.substring(1);
            if (vars.containsKey(javaName)) {
                var = vars.getVariable(javaName);
                var.setRubyObject(value2);
                continue;
            }
            var = new LocalGlobalVariable(javaName, value2);
            vars.update(javaName, var);
        }
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
        runtime2.getGlobalVariables().set("$" + this.name, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        this.setJavaObject(runtime2, null);
        runtime2.getGlobalVariables().set("$" + this.name, this.irubyObject);
    }
}

