/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class GlobalVariable
extends AbstractVariable {
    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        String pattern = "\\$([a-zA-Z]|(_([a-zA-Z]|_|\\d)))([a-zA-Z]|_|\\d)*";
        if (name2.matches(pattern)) {
            return new GlobalVariable(runtime2, name2, javaObject);
        }
        return null;
    }

    protected GlobalVariable(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    GlobalVariable(String name2, IRubyObject irubyObject) {
        super(name2, irubyObject);
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        GlobalVariables gvars = runtime2.getGlobalVariables();
        Set<String> names2 = gvars.getNames();
        for (String name2 : names2) {
            BiVariable var;
            if (GlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = gvars.get(name2);
            if (vars.containsKey(name2)) {
                var = vars.getVariable(name2);
                var.setRubyObject(value2);
                continue;
            }
            var = new GlobalVariable(name2, value2);
            vars.update(name2, var);
        }
    }

    protected static boolean isPredefined(String name2) {
        String[] patterns;
        for (String pattern : patterns = new String[]{"\\$([\\u0021-\\u0040]|\\u005c|[\\u005e-\\u0060]|\\u007e)", "\\$-(\\d|[A-z])", "\\$(DEBUG|F|FILENAME|KCODE|LOAD_PATH|SAFE|VERBOSE|CLASSPATH|LOADED_FEATURES|PROGRAM_NAME)", "\\$(configure_args|deferr|defout|expect_verbose|stderr|stdin|stdout)"}) {
            if (!name2.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.GlobalVariable;
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
        runtime2.getGlobalVariables().set(this.name, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        this.setJavaObject(runtime2, null);
        runtime2.getGlobalVariables().set(this.name, this.irubyObject);
    }
}

