/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.representations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.BRANCH_Instr;
import org.jruby.compiler.ir.instructions.BREAK_Instr;
import org.jruby.compiler.ir.instructions.CASE_Instr;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.JUMP_Instr;
import org.jruby.compiler.ir.instructions.LABEL_Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.representations.BasicBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFG {
    IR_Scope _scope;
    BasicBlock _entryBB;
    BasicBlock _exitBB;
    DirectedGraph<BasicBlock, CFG_Edge> _cfg;
    int _nextBBId = 0;

    public CFG(IR_Scope s) {
        this._scope = s;
        this._entryBB = new BasicBlock(this, this.getNewLabel());
        this._exitBB = new BasicBlock(this, this.getNewLabel());
    }

    public DirectedGraph getGraph() {
        return this._cfg;
    }

    public int getNextBBId() {
        ++this._nextBBId;
        return this._nextBBId;
    }

    public int getMaxNodeID() {
        return this._nextBBId;
    }

    public Set<CFG_Edge> incomingEdgesOf(BasicBlock bb) {
        return this._cfg.incomingEdgesOf((Object)bb);
    }

    public Set<CFG_Edge> outgoingEdgesOf(BasicBlock bb) {
        return this._cfg.outgoingEdgesOf((Object)bb);
    }

    public Set<BasicBlock> getNodes() {
        return this._cfg.vertexSet();
    }

    private Label getNewLabel() {
        return this._scope.getNewLabel();
    }

    public void build(List<IR_Instr> instrs) {
        HashMap<Label, ArrayList<BasicBlock>> forwardRefs = new HashMap<Label, ArrayList<BasicBlock>>();
        HashMap<Label, BasicBlock> bbMap = new HashMap<Label, BasicBlock>();
        bbMap.put(this._entryBB._label, this._entryBB);
        bbMap.put(this._exitBB._label, this._exitBB);
        DefaultDirectedGraph g = new DefaultDirectedGraph((EdgeFactory)new EdgeFactory<BasicBlock, CFG_Edge>(){

            public CFG_Edge createEdge(BasicBlock s, BasicBlock d) {
                return new CFG_Edge(s, d);
            }
        });
        g.addVertex((Object)this._entryBB);
        g.addVertex((Object)this._exitBB);
        BasicBlock currBB = this._entryBB;
        BasicBlock newBB = null;
        boolean bbEnded = false;
        boolean bbEndedWithJump = false;
        for (IR_Instr i : instrs) {
            Operation iop = i._op;
            if (iop.startsBasicBlock()) {
                Label l = ((LABEL_Instr)i)._lbl;
                newBB = new BasicBlock(this, l);
                bbMap.put(l, newBB);
                g.addVertex((Object)newBB);
                if (!bbEndedWithJump) {
                    g.addEdge((Object)currBB, (Object)newBB);
                }
                currBB = newBB;
                List readers = (List)forwardRefs.get(l);
                if (readers != null) {
                    for (BasicBlock b : readers) {
                        g.addEdge((Object)b, (Object)newBB);
                    }
                }
                bbEnded = false;
                bbEndedWithJump = false;
                continue;
            }
            if (bbEnded) {
                newBB = new BasicBlock(this, this.getNewLabel());
                g.addVertex((Object)newBB);
                g.addEdge((Object)currBB, (Object)newBB);
                currBB = newBB;
                bbEnded = false;
                bbEndedWithJump = false;
                continue;
            }
            if (iop.endsBasicBlock()) {
                Label tgt;
                currBB.addInstr(i);
                if (i instanceof BRANCH_Instr) {
                    tgt = ((BRANCH_Instr)i).getJumpTarget();
                } else if (i instanceof JUMP_Instr) {
                    tgt = ((JUMP_Instr)i).getJumpTarget();
                    bbEndedWithJump = true;
                } else {
                    tgt = i instanceof CASE_Instr ? null : (i instanceof BREAK_Instr ? null : null);
                }
                if (tgt != null) {
                    BasicBlock tgtBB = (BasicBlock)bbMap.get(tgt);
                    if (tgtBB != null) {
                        g.addEdge((Object)currBB, (Object)tgtBB);
                    } else {
                        ArrayList<BasicBlock> frefs = (ArrayList<BasicBlock>)forwardRefs.get(tgt);
                        if (frefs == null) {
                            frefs = new ArrayList<BasicBlock>();
                            forwardRefs.put(tgt, frefs);
                        }
                        frefs.add(currBB);
                    }
                }
                bbEnded = true;
                continue;
            }
            currBB.addInstr(i);
        }
        this._cfg = g;
    }

    public String toStringInstrs() {
        StringBuffer buf = new StringBuffer();
        for (BasicBlock b : this.getNodes()) {
            buf.append(b.toStringInstrs());
        }
        return buf.toString();
    }

    public static class CFG_Edge {
        public final BasicBlock _src;
        public final BasicBlock _dst;

        public CFG_Edge(BasicBlock s, BasicBlock d) {
            this._src = s;
            this._dst = d;
        }

        public String toString() {
            return "<" + this._src.getID() + " --> " + this._dst.getID() + ">";
        }
    }
}

