/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Arrays;
import java.util.Map;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Method;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.MultiOperandInstr;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CALL_Instr
extends MultiOperandInstr {
    Operand _methAddr;
    Operand _closure;

    public CALL_Instr(Variable result, Operand methAddr, Operand[] args2, Operand closure) {
        super(Operation.CALL, result, args2);
        this._methAddr = methAddr;
        this._closure = closure;
    }

    public CALL_Instr(Operation op, Variable result, Operand methAddr, Operand[] args2, Operand closure) {
        super(op, result, args2);
        this._methAddr = methAddr;
        this._closure = closure;
    }

    public boolean isRubyInternalsCall() {
        return false;
    }

    public boolean isStaticCallTarget() {
        return this.getTargetMethod() != null;
    }

    public boolean canModifyCode() {
        IR_Method m = this.getTargetMethod();
        return m == null ? true : m.modifiesCode();
    }

    public Operand[] getCallArgs() {
        return this._args;
    }

    public Operand getMethodAddr() {
        return this._methAddr;
    }

    public Operand getClosureArg() {
        return this._closure;
    }

    public Operand getReceiver() {
        return this._args[0];
    }

    public IR_Method getTargetMethodWithReceiver(Operand receiver2) {
        if (!(this._methAddr instanceof MethAddr)) {
            return null;
        }
        if (receiver2 instanceof MetaObject) {
            IR_Module m = (IR_Module)((MetaObject)receiver2)._scope;
            return m.getClassMethod(((MethAddr)this._methAddr).getName());
        }
        IR_Class c = receiver2.getTargetClass();
        return c == null ? null : c.getInstanceMethod(((MethAddr)this._methAddr).getName());
    }

    public IR_Method getTargetMethod() {
        return this.getTargetMethodWithReceiver(this.getReceiver());
    }

    @Override
    public String toString() {
        return "\t" + (this._result == null ? "" : this._result + " = ") + (Object)((Object)this._op) + "(" + this._methAddr + ", " + Arrays.toString(this._args) + ")" + (this._closure == null ? "" : ", closure: " + this._closure);
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        super.simplifyOperands(valueMap);
        this._methAddr = this._methAddr.getSimplifiedOperand(valueMap);
        if (this._closure != null) {
            this._closure = this._closure.getSimplifiedOperand(valueMap);
        }
    }
}

