/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.List;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ir.CodeVersion;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.IR_ScopeImpl;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.RECV_ARG_Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;

public class IR_Method
extends IR_ScopeImpl {
    public final String _name;
    public final boolean _isInstanceMethod;
    public final Label _startLabel;
    public final Label _endLabel;
    private CodeVersion _token;
    private boolean _optimizable;
    private boolean _canModifyCode;
    private List<Operand> _callArgs;

    public IR_Method(IR_Scope parent, IR_Scope lexicalParent, String name2, String javaName, boolean isInstanceMethod) {
        this(parent, lexicalParent, name2, isInstanceMethod);
    }

    public IR_Method(IR_Scope parent, IR_Scope lexicalParent, String name2, boolean isInstanceMethod) {
        super(parent, lexicalParent);
        this._name = name2;
        this._isInstanceMethod = isInstanceMethod;
        this._startLabel = this.getNewLabel("_METH_START_");
        this._endLabel = this.getNewLabel("_METH_END_");
        this._callArgs = new ArrayList<Operand>();
        this._token = CodeVersion.getVersionToken();
        this._optimizable = true;
        this._canModifyCode = true;
    }

    public void addInstr(IR_Instr i) {
        if (i instanceof RECV_ARG_Instr) {
            this._callArgs.add(i._result);
        }
        super.addInstr(i);
    }

    public Operand[] getCallArgs() {
        return this._callArgs.toArray(new Operand[this._callArgs.size()]);
    }

    public void setConstantValue(String constRef, Operand val) {
        if (!this.isAClassRootMethod()) {
            throw new NotCompilableException("Unexpected: Encountered set constant value in a method!");
        }
        ((MetaObject)this._parent)._scope.setConstantValue(constRef, val);
    }

    public boolean isAClassRootMethod() {
        return IR_Class.isAClassRootMethod(this);
    }

    public void setOptimizatableFlag(boolean f) {
        this._optimizable = f;
    }

    public boolean isUnoptimizable() {
        return this._optimizable;
    }

    public void setCodeModificationFlag(boolean f) {
        this._canModifyCode = f;
    }

    public boolean modifiesCode() {
        return this._canModifyCode;
    }

    public String getFullyQualifiedName() {
        IR_Module m = this.getDefiningModule();
        return m == null ? null : m._name + ":" + this._name;
    }

    public IR_Module getDefiningModule() {
        return this._parent instanceof MetaObject ? (IR_Module)((MetaObject)this._parent)._scope : null;
    }

    public CodeVersion getCodeVersionToken() {
        return this._token;
    }

    public String toString() {
        return "Method: " + this._name + super.toString();
    }
}

