/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhileNode;

public class DAGBuilder {
    public static Pair pair(N head, N tail) {
        return new Pair(head, tail);
    }

    public static Pair pair(N ht) {
        return new Pair(ht);
    }

    public static Pair pair() {
        return new Pair();
    }

    public static N node(String name2, Object ... payload) {
        return new N(name2, payload);
    }

    public static Pair getExtents(Node node) {
        Pair pair;
        switch (node.getNodeType()) {
            case BLOCKNODE: {
                BlockNode blockNode = (BlockNode)node;
                pair = DAGBuilder.getExtents(blockNode.get(0));
                for (int i = 1; i < blockNode.size(); ++i) {
                    pair.append(DAGBuilder.getExtents(blockNode.get(i)));
                }
                break;
            }
            case CALLNODE: {
                CallNode callNode = (CallNode)node;
                pair = DAGBuilder.getExtents(callNode.getReceiverNode());
                for (Node n : callNode.getArgsNode().childNodes()) {
                    pair.append(DAGBuilder.getExtents(n));
                }
                N call2 = DAGBuilder.node("CALL", callNode.getName(), callNode.getArgsNode().childNodes().size() + 1);
                pair.append(call2);
                break;
            }
            case FCALLNODE: {
                FCallNode fcallNode = (FCallNode)node;
                pair = DAGBuilder.pair(DAGBuilder.node("SELF", new Object[0]));
                for (Node n : fcallNode.getArgsNode().childNodes()) {
                    pair.append(DAGBuilder.getExtents(n));
                }
                N fcall = DAGBuilder.node("CALL", fcallNode.getName(), fcallNode.getArgsNode().childNodes().size() + 1);
                pair.append(fcall);
                break;
            }
            case FIXNUMNODE: {
                FixnumNode fixnumNode = (FixnumNode)node;
                pair = DAGBuilder.pair(DAGBuilder.node("FIXNUM", fixnumNode.getValue()));
                break;
            }
            case IFNODE: {
                Pair els;
                Pair then;
                IfNode ifNode = (IfNode)node;
                pair = DAGBuilder.getExtents(ifNode.getCondition());
                N join2 = DAGBuilder.node("PHI", new Object[0]);
                if (ifNode.getThenBody() != null) {
                    then = DAGBuilder.getExtents(ifNode.getThenBody());
                    then.append(join2);
                } else {
                    then = DAGBuilder.pair(join2);
                }
                if (ifNode.getElseBody() != null) {
                    els = DAGBuilder.getExtents(ifNode.getElseBody());
                    els.append(join2);
                } else {
                    els = DAGBuilder.pair(join2);
                }
                pair.append(new B(then.head, els.head), join2);
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
                pair = DAGBuilder.getExtents(localAsgnNode.getValueNode());
                N lasgnTail = DAGBuilder.node("LSTORE", localAsgnNode.getIndex(), localAsgnNode.getDepth());
                pair.append(lasgnTail);
                break;
            }
            case LOCALVARNODE: {
                LocalVarNode localVarNode = (LocalVarNode)node;
                pair = DAGBuilder.pair(DAGBuilder.node("LLOAD", localVarNode.getIndex(), localVarNode.getDepth()));
                break;
            }
            case NEWLINENODE: {
                return DAGBuilder.getExtents(((NewlineNode)node).getNextNode());
            }
            case RETURNNODE: {
                ReturnNode returnNode = (ReturnNode)node;
                pair = DAGBuilder.getExtents(returnNode.getValueNode());
                pair.append(DAGBuilder.node("RETURN", new Object[0]));
                break;
            }
            case ROOTNODE: {
                return DAGBuilder.getExtents(((RootNode)node).getBodyNode());
            }
            case VCALLNODE: {
                VCallNode vcallNode = (VCallNode)node;
                pair = DAGBuilder.pair(DAGBuilder.node("SELF", new Object[0]));
                pair.append(DAGBuilder.node("CALL", vcallNode.getName(), 1));
                break;
            }
            case WHILENODE: {
                WhileNode whileNode = (WhileNode)node;
                if (whileNode.evaluateAtStart()) {
                    Pair bodyPair;
                    pair = DAGBuilder.getExtents(whileNode.getConditionNode());
                    N join2 = DAGBuilder.node("PHI", new Object[0]);
                    if (whileNode.getBodyNode() != null) {
                        bodyPair = DAGBuilder.getExtents(whileNode.getBodyNode());
                        bodyPair.append(pair);
                    } else {
                        bodyPair = pair;
                    }
                    Pair escape = DAGBuilder.pair(join2);
                    pair.append(new B(bodyPair.head, escape.head), join2);
                    break;
                }
            }
            default: {
                throw new RuntimeException("unknown node: " + node);
            }
        }
        return pair;
    }

    public static class Pair {
        public N head;
        public N tail;

        public Pair() {
        }

        public Pair(N ht) {
            this.head = ht;
            this.tail = ht;
        }

        public Pair(N h, N t) {
            this.head = h;
            this.tail = t;
        }

        public void append(N t) {
            this.tail.tail = t;
            this.tail = t;
        }

        public void append(N h, N t) {
            this.tail.tail = h;
            this.tail = t;
        }

        public void append(Pair other) {
            this.tail.tail = other.head;
            this.tail = other.tail;
        }

        public void copy(Pair other) {
            this.head = other.head;
            this.tail = other.tail;
        }
    }

    public static class B
    extends N {
        public N alt;

        public B(N tail, N alt) {
            super("BRANCH", new Object[0]);
            this.tail = tail;
            this.alt = alt;
        }
    }

    public static class N {
        public String name;
        public Object[] payload;
        public N tail;

        public N(String name2, Object ... payload) {
            this.name = name2;
            this.payload = payload;
        }

        public void append(N newTail) {
            this.tail.tail = newTail;
            this.tail = newTail;
        }

        public String getName() {
            return this.name;
        }

        public Object[] getPayload() {
            return this.payload;
        }

        public N getTail() {
            return this.tail;
        }
    }
}

