/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BracePlacementProperty
extends PropertySupport.ReadWrite<CodeStyle.BracePlacement> {
    private final CodeStyle.Language language;
    private final String optionID;
    private PreviewPreferences preferences;
    private CodeStyle.BracePlacement state;
    private PropertyEditor editor;

    public BracePlacementProperty(CodeStyle.Language language, PreviewPreferences previewPreferences, String string) {
        super(string, CodeStyle.BracePlacement.class, BracePlacementProperty.getString("LBL_" + string), BracePlacementProperty.getString("HINT_" + string));
        this.language = language;
        this.optionID = string;
        this.preferences = previewPreferences;
        this.init();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(BracePlacementProperty.class, (String)string);
    }

    private void init() {
        this.state = CodeStyle.BracePlacement.valueOf(this.getPreferences().get(this.optionID, this.getDefault().name()));
    }

    private CodeStyle.BracePlacement getDefault() {
        return CodeStyle.BracePlacement.valueOf((String)EditorOptions.getDefault(this.getPreferences().getLanguage(), this.getPreferences().getStyleId(), this.optionID));
    }

    private PreviewPreferences getPreferences() {
        return this.preferences;
    }

    public String getHtmlDisplayName() {
        if (!this.isDefaultValue()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public CodeStyle.BracePlacement getValue() {
        return this.state;
    }

    public void setValue(CodeStyle.BracePlacement bracePlacement) {
        this.state = bracePlacement;
        this.getPreferences().put(this.optionID, this.state.name());
    }

    public void restoreDefaultValue() {
        this.setValue(this.getDefault());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.getDefault().equals((Object)this.getValue());
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new BracePlacementEditor();
        }
        return this.editor;
    }

    private static class BracePlacementEditor
    extends PropertyEditorSupport {
        private BracePlacementEditor() {
        }

        public String[] getTags() {
            try {
                CodeStyle.BracePlacement[] bracePlacementArray = CodeStyle.BracePlacement.values();
                String[] stringArray = new String[bracePlacementArray.length];
                for (int i = 0; i < bracePlacementArray.length; ++i) {
                    stringArray[i] = bracePlacementArray[i].toString();
                }
                return stringArray;
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }

        public String getAsText() {
            Object object = this.getValue();
            return object != null ? object.toString() : "";
        }

        public void setAsText(String string) {
            if (string.length() > 0) {
                CodeStyle.BracePlacement[] bracePlacementArray = CodeStyle.BracePlacement.values();
                for (int i = 0; i < bracePlacementArray.length; ++i) {
                    if (!bracePlacementArray[i].toString().equals(string)) continue;
                    this.setValue((Object)bracePlacementArray[i]);
                    return;
                }
            }
            this.setValue(null);
        }

        public String getJavaInitializationString() {
            CodeStyle.BracePlacement bracePlacement = (CodeStyle.BracePlacement)((Object)this.getValue());
            return bracePlacement != null ? CodeStyle.BracePlacement.class.getName().replace('$', '.') + '.' + bracePlacement.name() : "null";
        }
    }
}

