/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.fortran.FortranBracketCompletion;
import org.netbeans.modules.cnd.editor.fortran.indent.FortranHotCharIndent;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FKit
extends NbEditorKit {
    private InputAttributes lexerAttrs = null;
    private static ArrayList<Class> actionClasses = null;

    public String getContentType() {
        return "text/x-fortran";
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
    }

    public Document createDefaultDocument() {
        NbEditorDocument nbEditorDocument = new NbEditorDocument("text/x-fortran");
        nbEditorDocument.putProperty((Object)"write-line-separator", (Object)"\n");
        return nbEditorDocument;
    }

    protected void initDocument(BaseDocument baseDocument) {
        super.initDocument(baseDocument);
        baseDocument.putProperty(InputAttributes.class, (Object)this.getLexerAttributes(baseDocument));
        baseDocument.putProperty(Language.class, this.getLanguage());
    }

    protected Language<FortranTokenId> getLanguage() {
        return FortranTokenId.languageFortran();
    }

    protected final synchronized InputAttributes getLexerAttributes(BaseDocument baseDocument) {
        if (this.lexerAttrs == null) {
            this.lexerAttrs = new InputAttributes();
            this.lexerAttrs.setValue(this.getLanguage(), (Object)"lexer-filter", this.getFilter(), true);
            this.lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-maximum-text-width", (Object)132, true);
        }
        this.lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-free-format", (Object)FortranCodeStyle.get((Document)baseDocument).isFreeFormatFortran(), true);
        return this.lexerAttrs;
    }

    protected Filter<FortranTokenId> getFilter() {
        return CndLexerUtilities.getFortranFilter();
    }

    protected Action[] createActions() {
        int n = 5;
        int n2 = 0;
        if (actionClasses != null) {
            n2 = actionClasses.size();
            n += n2;
        }
        Action[] actionArray = new Action[n];
        int n3 = 0;
        if (actionClasses != null) {
            for (int i = 0; i < n2; ++i) {
                Class clazz = actionClasses.get(i);
                try {
                    actionArray[n3] = (Action)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                ++n3;
            }
        }
        actionArray[n3++] = new FFormatAction();
        actionArray[n3++] = new CCDefaultKeyTypedAction();
        actionArray[n3++] = new ExtKit.CommentAction("!");
        actionArray[n3++] = new ExtKit.UncommentAction("!");
        actionArray[n3++] = new ExtKit.ToggleCommentAction("!");
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public static void addActionClass(Class clazz) {
        if (actionClasses == null) {
            actionClasses = new ArrayList(2);
        }
        actionClasses.add(clazz);
    }

    protected void updateActions() {
        super.updateActions();
        this.addSystemActionMapping("format", FFormatAction.class);
    }

    private static class CCDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private CCDefaultKeyTypedAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkIndentHotChars(JTextComponent jTextComponent, String string) {
            int n;
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            if (FortranHotCharIndent.INSTANCE.getKeywordBasedReformatBlock(baseDocument, n = jTextComponent.getCaretPosition(), string)) {
                Indent indent = Indent.get((Document)baseDocument);
                indent.lock();
                try {
                    baseDocument.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.TRUE);
                    indent.reindent(n);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                finally {
                    baseDocument.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.FALSE);
                    indent.unlock();
                }
            }
        }

        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            super.insertString(baseDocument, n, caret, string, bl);
            FortranBracketCompletion.charInserted(baseDocument, n, caret, string.charAt(0));
        }
    }

    public static class FFormatAction
    extends BaseAction {
        public FFormatAction() {
            super("format", 10);
            this.putValue("helpID", FFormatAction.class.getName());
        }

        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                Cursor cursor = jTextComponent.getCursor();
                jTextComponent.setCursor(Cursor.getPredefinedCursor(3));
                baseDocument.runAtomic(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Position position;
                            int n;
                            Caret caret = jTextComponent.getCaret();
                            int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)caret.getDot());
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                n = jTextComponent.getSelectionStart();
                                position = baseDocument.createPosition(jTextComponent.getSelectionEnd());
                            } else {
                                n = 0;
                                position = baseDocument.createPosition(baseDocument.getLength());
                            }
                            int n3 = n;
                            Reformat reformat = Reformat.get((Document)baseDocument);
                            reformat.lock();
                            try {
                                reformat.reformat(n3, position.getOffset());
                            }
                            finally {
                                reformat.unlock();
                            }
                            n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n2);
                            if (n3 >= 0) {
                                caret.setDot(n3);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                jTextComponent.setCursor(cursor);
            }
        }
    }
}

