/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;

public abstract class BaseCallGraphBuilder
implements ProfilingResultListener,
CCTProvider {
    protected static final Logger LOGGER = Logger.getLogger(BaseCallGraphBuilder.class.getName());
    protected List afterBatchCommands = new ArrayList();
    protected ProfilingSessionStatus status;
    protected Set cctListeners = new HashSet();
    protected WeakReference clientRef;
    protected boolean batchNotEmpty = false;

    public void addListener(CCTProvider.Listener listener) {
        this.cctListeners.add(listener);
    }

    public void onBatchStart() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Starting batch");
        }
        this.afterBatchCommands.clear();
        this.batchNotEmpty = false;
        this.doBatchStart();
    }

    public void onBatchStop() {
        this.doBatchStop();
        if (!this.afterBatchCommands.isEmpty()) {
            Iterator iterator = this.afterBatchCommands.iterator();
            while (iterator.hasNext()) {
                ((Runnable)iterator.next()).run();
            }
            this.afterBatchCommands.clear();
        }
        if (this.batchNotEmpty) {
            this.fireCCTEstablished(false);
        } else {
            this.fireCCTEstablished(true);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Finishing batch");
        }
    }

    public void profilingPoint(final int n, final int n2, final long l) {
        ProfilerClient profilerClient = this.getClient();
        if (profilerClient == null) {
            return;
        }
        final ProfilingPointsProcessor profilingPointsProcessor = TargetAppRunner.getDefault().getProfilingPointsProcessor();
        this.afterBatchCommands.add(new Runnable(){

            public void run() {
                profilingPointsProcessor.profilingPointHit(new RuntimeProfilingPoint.HitEvent(n2, l, n));
            }
        });
    }

    public void removeAllListeners() {
        this.cctListeners.clear();
    }

    public void removeListener(CCTProvider.Listener listener) {
        this.cctListeners.remove(listener);
    }

    public void reset() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Resetting CallGraphBuilder");
        }
        try {
            this.doReset();
            this.fireCCTReset();
        }
        catch (Exception exception) {
            LOGGER.severe(exception.getMessage());
        }
    }

    public void shutdown() {
        this.status = null;
        this.afterBatchCommands.clear();
        this.doShutdown();
    }

    public void startup(ProfilerClient profilerClient) {
        this.status = profilerClient.getStatus();
        this.clientRef = new WeakReference<ProfilerClient>(profilerClient);
        this.doStartup(profilerClient);
    }

    protected abstract RuntimeCCTNode getAppRootNode();

    protected abstract void doBatchStart();

    protected abstract void doBatchStop();

    protected abstract void doReset();

    protected abstract void doShutdown();

    protected abstract void doStartup(ProfilerClient var1);

    protected ProfilerClient getClient() {
        if (this.clientRef == null) {
            return null;
        }
        return (ProfilerClient)this.clientRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCCTEstablished(boolean bl) {
        RuntimeCCTNode runtimeCCTNode = this.getAppRootNode();
        if (runtimeCCTNode == null) {
            return;
        }
        HashSet hashSet = null;
        Object object = this.cctListeners;
        synchronized (object) {
            if (this.cctListeners.isEmpty()) {
                return;
            }
            hashSet = new HashSet(this.cctListeners);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((CCTProvider.Listener)object.next()).cctEstablished(runtimeCCTNode, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCCTReset() {
        HashSet hashSet = null;
        Object object = this.cctListeners;
        synchronized (object) {
            if (this.cctListeners.isEmpty()) {
                return;
            }
            hashSet = new HashSet(this.cctListeners);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((CCTProvider.Listener)object.next()).cctReset();
        }
    }
}

