/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.jruby.util.ByteList;
import org.jvyamlb.PositioningComposerImpl;
import org.jvyamlb.PositioningParser;
import org.jvyamlb.PositioningParserImpl;
import org.jvyamlb.PositioningScanner;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.exceptions.PositionedParserException;
import org.jvyamlb.exceptions.PositionedScannerException;
import org.jvyamlb.nodes.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.util.NbBundle;

public class YamlParser
extends Parser {
    private static final Logger LOGGER = Logger.getLogger(YamlParser.class.getName());
    private static final int MAX_LENGTH = 524288;
    private YamlParserResult lastResult;

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void cancel() {
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    private boolean isTooLarge(String string) {
        return string.length() > 524288;
    }

    private YamlParserResult resultForTooLargeFile(Snapshot snapshot) {
        YamlParserResult yamlParserResult = new YamlParserResult(Collections.<Node>emptyList(), this, snapshot, false, null, null);
        DefaultError defaultError = new DefaultError(null, NbBundle.getMessage(YamlParser.class, (String)"TooLarge"), null, snapshot.getSource().getFileObject(), 0, 0, Severity.WARNING);
        yamlParserResult.addError((Error)defaultError);
        return yamlParserResult;
    }

    YamlParserResult parse(String string, Snapshot snapshot) {
        Object object;
        int n = string.indexOf("<?");
        while (n > -1) {
            int n2 = string.indexOf("?>", n);
            if (n2 > -1) {
                ++n2;
                object = "";
                for (int i = 0; i < string.length(); ++i) {
                    object = n <= i && i <= n2 ? (String)object + ' ' : (String)object + string.charAt(i);
                }
                string = object;
                n = string.indexOf("<?", n2);
                continue;
            }
            n = -1;
        }
        try {
            Node node;
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream;
            if (this.isTooLarge(string)) {
                return this.resultForTooLargeFile(snapshot);
            }
            ByteList byteList = null;
            object = null;
            int[] nArray = null;
            byte[] byArray = string.getBytes("UTF-8");
            if (byArray.length == string.length()) {
                byteList = new ByteList(byArray);
            } else {
                Object object3;
                byteArrayOutputStream = new ByteArrayOutputStream(2 * string.length());
                object2 = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                nArray = new int[string.length()];
                int n3 = 0;
                int n4 = string.length();
                for (object3 = 0; object3 < n4; ++object3) {
                    ((OutputStreamWriter)object2).write(string.charAt((int)object3));
                    ((OutputStreamWriter)object2).flush();
                    nArray[object3] = n3;
                    n3 = byteArrayOutputStream.size();
                }
                if (n3 > 0) {
                    object = new int[n3];
                    n4 = nArray.length;
                    for (object3 = 0; object3 < n4; ++object3) {
                        object[nArray[object3]] = object3;
                    }
                    object3 = 0;
                    int n5 = ((Object)object).length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        Object object4 = object[n4];
                        if (object4 == false) {
                            object[n4] = object3;
                            continue;
                        }
                        object3 = object4;
                    }
                } else {
                    object = new int[0];
                }
                byteList = new ByteList(byteArrayOutputStream.toByteArray());
            }
            byteArrayOutputStream = new PositioningComposerImpl((PositioningParser)new PositioningParserImpl((PositioningScanner)new PositioningScannerImpl(byteList)), (Resolver)new ResolverImpl());
            object2 = new ArrayList();
            Iterator iterator = byteArrayOutputStream.eachNode();
            while (iterator.hasNext() && (node = (Node)iterator.next()) != null) {
                object2.add(node);
            }
            return new YamlParserResult((List<Node>)object2, this, snapshot, true, (int[])object, nArray);
        }
        catch (Exception exception) {
            Object object5;
            int n6 = 0;
            if (exception instanceof PositionedParserException) {
                PositionedParserException positionedParserException = (PositionedParserException)exception;
                n6 = positionedParserException.getPosition().offset;
            } else if (exception instanceof PositionedScannerException) {
                TokenSequence tokenSequence;
                PositionedScannerException positionedScannerException = (PositionedScannerException)exception;
                n6 = positionedScannerException.getPosition().offset;
                object5 = snapshot.getTokenHierarchy();
                if (object5 != null && (tokenSequence = object5.tokenSequence()) != null) {
                    tokenSequence.move(n6);
                    tokenSequence.moveNext();
                    Token token = tokenSequence.token();
                    if (token != null && ((Object)token.text()).toString().indexOf(123) == -1 && tokenSequence.movePrevious()) {
                        n6 = tokenSequence.offset();
                    }
                }
            }
            YamlParserResult yamlParserResult = new YamlParserResult(Collections.<Node>emptyList(), this, snapshot, false, null, null);
            object5 = exception.getMessage();
            if (object5 != null && ((String)object5).length() > 0) {
                if (((String)object5).startsWith("ScannerException null ")) {
                    object5 = ((String)object5).substring(22);
                } else if (((String)object5).startsWith("ParserException ")) {
                    object5 = ((String)object5).substring(16);
                }
                char c = ((String)object5).charAt(0);
                char c2 = Character.toUpperCase(c);
                if (c != c2) {
                    object5 = c2 + ((String)object5).substring(1);
                }
                DefaultError defaultError = new DefaultError(null, (String)object5, null, snapshot.getSource().getFileObject(), n6, n6, Severity.ERROR);
                yamlParserResult.addError((Error)defaultError);
            }
            return yamlParserResult;
        }
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        String string = YamlParser.asString(snapshot.getText());
        if (this.isTooLarge(string)) {
            LOGGER.log(Level.FINE, "Skipping {0}, too large to parse (length: {1})", new Object[]{snapshot.getSource().getFileObject(), string.length()});
            this.lastResult = this.resultForTooLargeFile(snapshot);
            return;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, YamlTokenId.language());
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            int n = 0;
            tokenSequence.move(n);
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId == YamlTokenId.RUBY_EXPR) {
                    String string2 = "__";
                    stringBuilder.append(string2);
                    int n2 = token.length() - string2.length();
                    for (int i = 0; i < n2; ++i) {
                        stringBuilder.append(' ');
                    }
                    continue;
                }
                if (tokenId == YamlTokenId.RUBY || tokenId == YamlTokenId.RUBYCOMMENT || tokenId == YamlTokenId.DELIMITER) {
                    for (int i = 0; i < token.length(); ++i) {
                        stringBuilder.append(' ');
                    }
                    continue;
                }
                stringBuilder.append(((Object)token.text()).toString());
            }
            string = stringBuilder.toString();
            this.lastResult = this.parse(string, snapshot);
        }
        catch (Exception exception) {
            this.lastResult = new YamlParserResult(Collections.<Node>emptyList(), this, snapshot, false, null, null);
        }
    }
}

