/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.java.hints.introduce.ErrorLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceFieldPanel
extends JPanel {
    public static final int INIT_METHOD = 1;
    public static final int INIT_FIELD = 2;
    public static final int INIT_CONSTRUCTORS = 4;
    private static final int ACCESS_PUBLIC = 1;
    private static final int ACCESS_PROTECTED = 2;
    private static final int ACCESS_DEFAULT = 3;
    private static final int ACCESS_PRIVATE = 4;
    private int[] allowInitMethods;
    private boolean allowFinalInCurrentMethod;
    private JButton btnOk;
    private JRadioButton accessDefault;
    private ButtonGroup accessGroup;
    private JRadioButton accessPrivate;
    private JRadioButton accessProtected;
    private JRadioButton accessPublic;
    private JCheckBox declareFinal;
    private JLabel errLabel;
    private JRadioButton initConstructors;
    private JRadioButton initField;
    private JRadioButton initMethod;
    private ButtonGroup initilizeIn;
    private JLabel lblAccess;
    private JLabel lblInitializeIn;
    private JLabel lblName;
    private JTextField name;
    private JCheckBox replaceAll;
    private String fieldNameTest;
    private Integer initializeInTest;
    private Boolean replaceAllTest;
    private Set<Modifier> accessTest;
    private Boolean declareFinalTest;

    public IntroduceFieldPanel(String string, int[] nArray, int n, boolean bl, JButton jButton) {
        this.btnOk = jButton;
        this.initComponents();
        this.name.setText(string);
        if (string != null && string.trim().length() > 0) {
            this.name.setCaretPosition(string.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(string.length());
        }
        this.allowInitMethods = nArray;
        this.replaceAll.setEnabled(n > 1);
        this.allowFinalInCurrentMethod = bl;
        Preferences preferences = this.getPreferences();
        if (n == 1) {
            this.replaceAll.setEnabled(false);
            this.replaceAll.setSelected(false);
        } else {
            this.replaceAll.setEnabled(true);
            this.replaceAll.setText(this.replaceAll.getText() + " (" + n + ")");
            this.replaceAll.setSelected(preferences.getBoolean("replaceAll", true));
        }
        this.declareFinal.setSelected(preferences.getBoolean("declareFinal", true));
        int n2 = preferences.getInt("accessModifier", 4);
        switch (n2) {
            case 1: {
                this.accessPublic.setSelected(true);
                break;
            }
            case 2: {
                this.accessProtected.setSelected(true);
                break;
            }
            case 3: {
                this.accessDefault.setSelected(true);
                break;
            }
            case 4: {
                this.accessPrivate.setSelected(true);
            }
        }
        int n3 = preferences.getInt("initMethod", 1);
        switch (n3) {
            case 2: {
                this.initField.setSelected(true);
                break;
            }
            case 4: {
                this.initConstructors.setSelected(true);
                break;
            }
            case 1: {
                this.initMethod.setSelected(true);
            }
        }
        this.adjustInitializeIn();
        this.adjustFinal();
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(IntroduceFieldPanel.class).node("introduceField");
    }

    private void adjustInitializeIn() {
        int n = this.allowInitMethods[this.replaceAll.isSelected() ? 1 : 0];
        this.initMethod.setEnabled((n & 1) != 0);
        this.initField.setEnabled((n & 2) != 0);
        this.initConstructors.setEnabled((n & 4) != 0);
        if (!this.initMethod.isEnabled() && this.initMethod.isSelected()) {
            if (this.initField.isEnabled()) {
                this.initField.setSelected(true);
            } else {
                this.initConstructors.setSelected(true);
            }
        } else if (!this.initField.isEnabled() && this.initField.isSelected()) {
            if (this.initMethod.isEnabled()) {
                this.initMethod.setSelected(true);
            } else {
                this.initConstructors.setSelected(true);
            }
        } else if (!this.initConstructors.isEnabled() && this.initConstructors.isSelected()) {
            if (this.initMethod.isEnabled()) {
                this.initMethod.setSelected(true);
            } else {
                this.initField.setSelected(true);
            }
        }
    }

    private void adjustFinal() {
        this.declareFinal.setEnabled(!this.initMethod.isSelected() || this.allowFinalInCurrentMethod);
        if (this.initMethod.isSelected() && !this.allowFinalInCurrentMethod) {
            this.declareFinal.setSelected(false);
        }
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            public String validate(String string) {
                if (null == string || string.length() == 0) {
                    return "";
                }
                if (!Utilities.isJavaIdentifier((String)string)) {
                    return IntroduceFieldPanel.this.getDefaultErrorMessage(string);
                }
                return null;
            }
        };
        final ErrorLabel errorLabel = new ErrorLabel(this.name.getDocument(), validator);
        errorLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntroduceFieldPanel.this.btnOk.setEnabled(errorLabel.isInputTextValid());
            }
        });
        return errorLabel;
    }

    String getDefaultErrorMessage(String string) {
        return "'" + string + "' is not a valid identifier";
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.replaceAll = new JCheckBox();
        this.declareFinal = new JCheckBox();
        this.lblInitializeIn = new JLabel();
        this.initMethod = new JRadioButton();
        this.initField = new JRadioButton();
        this.initConstructors = new JRadioButton();
        this.lblAccess = new JLabel();
        this.accessPublic = new JRadioButton();
        this.accessProtected = new JRadioButton();
        this.accessDefault = new JRadioButton();
        this.accessPrivate = new JRadioButton();
        this.errLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAll, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_ReplaceAll"));
        this.replaceAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.replaceAll.setMargin(new Insets(0, 0, 0, 0));
        this.replaceAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroduceFieldPanel.this.replaceAllActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.declareFinal, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_DeclareFinal"));
        this.declareFinal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.declareFinal.setMargin(new Insets(0, 0, 0, 0));
        this.declareFinal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroduceFieldPanel.this.declareFinalActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblInitializeIn, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"IntroduceFieldPanel.lblInitializeIn.text"));
        this.initilizeIn.add(this.initMethod);
        this.initMethod.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.initMethod, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_CurrentMethod"));
        this.initMethod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initMethod.setMargin(new Insets(0, 0, 0, 0));
        this.initMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroduceFieldPanel.this.initMethodActionPerformed(actionEvent);
            }
        });
        this.initilizeIn.add(this.initField);
        Mnemonics.setLocalizedText((AbstractButton)this.initField, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Field"));
        this.initField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initField.setMargin(new Insets(0, 0, 0, 0));
        this.initField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroduceFieldPanel.this.initFieldActionPerformed(actionEvent);
            }
        });
        this.initilizeIn.add(this.initConstructors);
        Mnemonics.setLocalizedText((AbstractButton)this.initConstructors, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Constructors"));
        this.initConstructors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initConstructors.setMargin(new Insets(0, 0, 0, 0));
        this.initConstructors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroduceFieldPanel.this.initConstructorsActionPerformed(actionEvent);
            }
        });
        this.lblAccess.setLabelFor(this.accessPublic);
        Mnemonics.setLocalizedText((JLabel)this.lblAccess, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_Access"));
        this.accessGroup.add(this.accessPublic);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPublic, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_public"));
        this.accessPublic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPublic.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessProtected);
        Mnemonics.setLocalizedText((AbstractButton)this.accessProtected, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_protected"));
        this.accessProtected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessProtected.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessDefault);
        Mnemonics.setLocalizedText((AbstractButton)this.accessDefault, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_Default"));
        this.accessDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessDefault.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessPrivate);
        this.accessPrivate.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPrivate, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_private"));
        this.accessPrivate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPrivate.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.errLabel, (String)"jLabel1");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errLabel, -1, 483, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblAccess).add((Component)this.lblName)).add(21, 21, 21).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.name, -1, 418, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.accessPublic).addPreferredGap(0).add((Component)this.accessProtected).addPreferredGap(0).add((Component)this.accessDefault).addPreferredGap(0).add((Component)this.accessPrivate)))).add((Component)this.declareFinal).add((Component)this.replaceAll).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblInitializeIn).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.initConstructors).add((Component)this.initField).add((Component)this.initMethod)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.name, -2, -1, -2).add((Component)this.lblName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblAccess).add((Component)this.accessPublic).add((Component)this.accessProtected).add((Component)this.accessDefault).add((Component)this.accessPrivate)).addPreferredGap(0).add((Component)this.declareFinal).addPreferredGap(0).add((Component)this.replaceAll).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblInitializeIn).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.initMethod).addPreferredGap(0).add((Component)this.initField).add(7, 7, 7).add((Component)this.initConstructors))).addPreferredGap(0, 18, Short.MAX_VALUE).add((Component)this.errLabel).addContainerGap()));
        this.lblName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Name"));
        this.replaceAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_ReplaceAllOccurences"));
        this.declareFinal.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_DeclareFinal"));
        this.initMethod.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_CurrentMethod"));
        this.initField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Field"));
        this.initConstructors.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Constructors"));
        this.accessPublic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Public"));
        this.accessProtected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Protected"));
        this.accessDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Default"));
        this.accessPrivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Private"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Dialog"));
    }

    private void declareFinalActionPerformed(ActionEvent actionEvent) {
    }

    private void initConstructorsActionPerformed(ActionEvent actionEvent) {
        this.adjustFinal();
    }

    private void initFieldActionPerformed(ActionEvent actionEvent) {
        this.adjustFinal();
    }

    private void initMethodActionPerformed(ActionEvent actionEvent) {
        this.adjustFinal();
    }

    private void replaceAllActionPerformed(ActionEvent actionEvent) {
        this.adjustInitializeIn();
    }

    public String getFieldName() {
        if (this.fieldNameTest != null) {
            return this.fieldNameTest;
        }
        return this.name.getText();
    }

    public int getInitializeIn() {
        int n;
        if (this.initializeInTest != null) {
            return this.initializeInTest;
        }
        if (this.initMethod.isSelected()) {
            n = 1;
        } else if (this.initField.isSelected()) {
            n = 2;
        } else if (this.initConstructors.isSelected()) {
            n = 4;
        } else {
            throw new IllegalStateException();
        }
        this.getPreferences().putInt("initMethod", n);
        return n;
    }

    public boolean isReplaceAll() {
        if (this.replaceAllTest != null) {
            return this.replaceAllTest;
        }
        boolean bl = this.replaceAll.isSelected();
        this.getPreferences().putBoolean("replaceAll", bl);
        return bl;
    }

    public Set<Modifier> getAccess() {
        Set<Modifier> set;
        int n;
        if (this.accessTest != null) {
            return this.accessTest;
        }
        if (this.accessPublic.isSelected()) {
            n = 1;
            set = EnumSet.of(Modifier.PUBLIC);
        } else if (this.accessProtected.isSelected()) {
            n = 2;
            set = EnumSet.of(Modifier.PROTECTED);
        } else if (this.accessDefault.isSelected()) {
            n = 3;
            set = Collections.emptySet();
        } else {
            n = 4;
            set = EnumSet.of(Modifier.PRIVATE);
        }
        this.getPreferences().putInt("accessModifier", n);
        return set;
    }

    public boolean isDeclareFinal() {
        if (this.declareFinalTest != null) {
            return this.declareFinalTest;
        }
        boolean bl = this.declareFinal.isSelected();
        this.getPreferences().putBoolean("declareFinal", bl);
        return bl;
    }

    void setAccess(Set<Modifier> set) {
        this.accessTest = set;
    }

    void setDeclareFinal(Boolean bl) {
        this.declareFinalTest = bl;
    }

    void setFieldName(String string) {
        this.fieldNameTest = string;
    }

    void setInitializeIn(Integer n) {
        this.initializeInTest = n;
    }

    void setReplaceAll(Boolean bl) {
        this.replaceAllTest = bl;
    }
}

