/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.MagicSurroundWithTryCatchFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrigSurroundWithTryCatchFix
implements Fix {
    private JavaSource javaSource;
    private List<TypeMirrorHandle> thandles;
    private TreePathHandle path;
    private List<String> fqns;

    public OrigSurroundWithTryCatchFix(JavaSource javaSource, List<TypeMirrorHandle> list, TreePathHandle treePathHandle, List<String> list2) {
        this.javaSource = javaSource;
        this.thandles = list;
        this.path = treePathHandle;
        this.fqns = list2;
    }

    public String getText() {
        return NbBundle.getMessage(MagicSurroundWithTryCatchFix.class, (String)"LBL_SurroundStatementWithTryCatch");
    }

    public ChangeInfo implement() throws Exception {
        this.javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                Object object;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreePath treePath = OrigSurroundWithTryCatchFix.this.path.resolve((CompilationInfo)workingCopy);
                if (treePath == null) {
                    return;
                }
                if ((treePath = OrigSurroundWithTryCatchFix.this.findStatement(treePath)) == null) {
                    return;
                }
                StatementTree statementTree = (StatementTree)treePath.getLeaf();
                GeneratorUtilities.get((WorkingCopy)workingCopy).importComments(treePath.getParentPath().getLeaf(), workingCopy.getCompilationUnit());
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                if (statementTree.getKind() == Tree.Kind.VARIABLE) {
                    TreePath treePath2;
                    object = workingCopy.getTrees().getElement(treePath);
                    VariableTree variableTree = (VariableTree)statementTree;
                    if (object != null && object.getKind() == ElementKind.LOCAL_VARIABLE && (treePath2 = OrigSurroundWithTryCatchFix.this.findBlockOrCase(treePath)) != null) {
                        boolean bl;
                        boolean bl2 = bl = new FindUsages(statementTree, (CompilationInfo)workingCopy).scan(treePath2, (VariableElement)object) == Boolean.TRUE;
                        if (bl) {
                            StatementTree statementTree2 = treeMaker.ExpressionStatement((ExpressionTree)treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)variableTree.getName()), variableTree.getInitializer()));
                            StatementTree statementTree3 = treeMaker.Variable(variableTree.getModifiers(), (CharSequence)variableTree.getName(), variableTree.getType(), null);
                            statementTree3 = Utilities.copyComments(workingCopy, variableTree, statementTree3, true);
                            statementTree2 = Utilities.copyComments(workingCopy, variableTree, statementTree2, false);
                            TryTree tryTree = treeMaker.Try(treeMaker.Block(Collections.singletonList(statementTree2), false), MagicSurroundWithTryCatchFix.createCatches((CompilationInfo)workingCopy, treeMaker, OrigSurroundWithTryCatchFix.this.thandles, treePath), null);
                            LinkedList<StatementTree> linkedList = new LinkedList<StatementTree>();
                            if (treePath2.getLeaf().getKind() == Tree.Kind.BLOCK) {
                                BlockTree blockTree = (BlockTree)treePath2.getLeaf();
                                int n = blockTree.getStatements().indexOf(statementTree);
                                assert (n != -1);
                                linkedList.addAll(blockTree.getStatements().subList(0, n));
                                linkedList.add(statementTree3);
                                linkedList.add(tryTree);
                                linkedList.addAll(blockTree.getStatements().subList(n + 1, blockTree.getStatements().size()));
                                workingCopy.rewrite((Tree)blockTree, (Tree)treeMaker.Block(linkedList, false));
                            } else {
                                CaseTree caseTree = (CaseTree)treePath2.getLeaf();
                                int n = caseTree.getStatements().indexOf(statementTree);
                                assert (n != -1);
                                linkedList.addAll(caseTree.getStatements().subList(0, n));
                                linkedList.add(statementTree3);
                                linkedList.add(tryTree);
                                linkedList.addAll(caseTree.getStatements().subList(n + 1, caseTree.getStatements().size()));
                                workingCopy.rewrite((Tree)caseTree, (Tree)treeMaker.Case(caseTree.getExpression(), linkedList));
                            }
                            return;
                        }
                    }
                }
                object = treeMaker.Try(treeMaker.Block(Collections.singletonList(statementTree), false), MagicSurroundWithTryCatchFix.createCatches((CompilationInfo)workingCopy, treeMaker, OrigSurroundWithTryCatchFix.this.thandles, treePath), null);
                workingCopy.rewrite((Tree)statementTree, (Tree)object);
            }
        }).commit();
        return null;
    }

    private TreePath findStatement(TreePath treePath) {
        while (treePath != null && !StatementTree.class.isAssignableFrom(treePath.getLeaf().getKind().asInterface())) {
            treePath = treePath.getParentPath();
        }
        return treePath;
    }

    private TreePath findBlockOrCase(TreePath treePath) {
        while (treePath != null && treePath.getLeaf().getKind() != Tree.Kind.BLOCK && treePath.getLeaf().getKind() != Tree.Kind.CASE) {
            treePath = treePath.getParentPath();
        }
        return treePath;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OrigSurroundWithTryCatchFix origSurroundWithTryCatchFix = (OrigSurroundWithTryCatchFix)object;
        if (!(this.javaSource == origSurroundWithTryCatchFix.javaSource || this.javaSource != null && this.javaSource.equals(origSurroundWithTryCatchFix.javaSource))) {
            return false;
        }
        if (!this.path.equals((Object)origSurroundWithTryCatchFix.path)) {
            return false;
        }
        return ((Object)this.fqns).equals(origSurroundWithTryCatchFix.fqns);
    }

    public int hashCode() {
        int n = 5;
        n = 23 * n + (this.javaSource != null ? this.javaSource.hashCode() : 0);
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FindUsages
    extends TreePathScanner<Boolean, VariableElement> {
        private Tree ignore;
        private CompilationInfo info;

        public FindUsages(Tree tree, CompilationInfo compilationInfo) {
            this.ignore = tree;
            this.info = compilationInfo;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree identifierTree, VariableElement variableElement) {
            return variableElement.equals(this.info.getTrees().getElement(this.getCurrentPath()));
        }

        @Override
        public Boolean scan(Tree tree, VariableElement variableElement) {
            if (tree == this.ignore) {
                return false;
            }
            return (Boolean)super.scan(tree, variableElement);
        }

        @Override
        public Boolean reduce(Boolean bl, Boolean bl2) {
            return bl == Boolean.TRUE || bl2 == Boolean.TRUE;
        }
    }
}

