/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignResultToVariable
extends AbstractHint {
    private static final Set<TypeKind> NOT_ACCEPTABLE_TYPE_KINDS = EnumSet.of(TypeKind.ERROR, new TypeKind[]{TypeKind.EXECUTABLE, TypeKind.NONE, TypeKind.NULL, TypeKind.OTHER, TypeKind.PACKAGE, TypeKind.WILDCARD, TypeKind.VOID});

    public AssignResultToVariable() {
        super(true, false, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        try {
            if (treePath.getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                return null;
            }
            Tree tree = treePath.getLeaf();
            Tree tree2 = null;
            Tree.Kind kind = tree.getKind();
            if (kind == Tree.Kind.METHOD_INVOCATION) {
                tree2 = ((MethodInvocationTree)tree).getMethodSelect();
            } else if (kind == Tree.Kind.NEW_CLASS) {
                tree2 = tree;
            }
            long l = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree2);
            long l2 = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree2);
            int n = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject());
            if (l == -1L || l2 == -1L || (long)n < l || (long)n > l2) {
                return null;
            }
            Element element = compilationInfo.getTrees().getElement(treePath);
            if (element == null || element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR) {
                return null;
            }
            TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath);
            if (typeMirror == null || NOT_ACCEPTABLE_TYPE_KINDS.contains((Object)typeMirror.getKind())) {
                return null;
            }
            List<FixImpl> list = Collections.singletonList(new FixImpl(compilationInfo.getFileObject(), compilationInfo.getDocument(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo)));
            String string = NbBundle.getMessage(AssignResultToVariable.class, (String)"HINT_AssignResultToVariable");
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string, list, (FileObject)compilationInfo.getFileObject(), (int)((int)l), (int)((int)l2)));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return AssignResultToVariable.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AssignResultToVariable.class, (String)"DN_AssignResultToVariable");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AssignResultToVariable.class, (String)"DESC_AssignResultToVariable");
    }

    static final class FixImpl
    implements Fix {
        private FileObject file;
        private Document doc;
        private TreePathHandle tph;

        public FixImpl(FileObject fileObject, Document document, TreePathHandle treePathHandle) {
            this.file = fileObject;
            this.doc = document;
            this.tph = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(AssignResultToVariable.class, (String)"FIX_AssignResultToVariable");
        }

        public ChangeInfo implement() {
            try {
                final String[] stringArray = new String[1];
                ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws Exception {
                        NewClassTree newClassTree;
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        TreePath treePath = FixImpl.this.tph.resolve((CompilationInfo)workingCopy);
                        if (treePath == null) {
                            Logger.getLogger(AssignResultToVariable.class.getName()).info("tp=null");
                            return;
                        }
                        TypeMirror typeMirror = workingCopy.getTrees().getTypeMirror(treePath);
                        Element element = workingCopy.getTrees().getElement(treePath);
                        if (typeMirror == null || NOT_ACCEPTABLE_TYPE_KINDS.contains((Object)typeMirror.getKind())) {
                            return;
                        }
                        Tree tree = treePath.getLeaf();
                        boolean bl = false;
                        ExpressionTree expressionTree = null;
                        if (tree instanceof NewClassTree) {
                            newClassTree = (NewClassTree)tree;
                            bl = newClassTree.getClassBody() != null || element.getKind().isInterface() || element.getModifiers().contains((Object)Modifier.ABSTRACT);
                            expressionTree = newClassTree.getIdentifier();
                        }
                        typeMirror = Utilities.resolveCapturedType((CompilationInfo)workingCopy, typeMirror);
                        newClassTree = workingCopy.getTreeMaker();
                        stringArray[0] = Utilities.guessName((CompilationInfo)workingCopy, treePath);
                        VariableTree variableTree = newClassTree.Variable(newClassTree.Modifiers(EnumSet.noneOf(Modifier.class)), stringArray[0], bl ? expressionTree : newClassTree.Type(typeMirror), (ExpressionTree)treePath.getLeaf());
                        variableTree = Utilities.copyComments(workingCopy, treePath.getLeaf(), variableTree);
                        workingCopy.rewrite(treePath.getParentPath().getLeaf(), (Tree)variableTree);
                    }
                });
                List list = modificationResult.getDifferences(this.file);
                if (list == null) {
                    Logger.getLogger(AssignResultToVariable.class.getName()).log(Level.INFO, "No differences.");
                    return null;
                }
                ModificationResult.Difference difference = null;
                for (ModificationResult.Difference difference2 : list) {
                    if (difference2.getNewText() == null || !difference2.getNewText().contains(stringArray[0])) continue;
                    if (difference == null) {
                        difference = difference2;
                        continue;
                    }
                    difference = null;
                    break;
                }
                if (difference == null) {
                    Logger.getLogger(AssignResultToVariable.class.getName()).log(Level.INFO, "Cannot find the difference: {0}", list);
                    modificationResult.commit();
                    return null;
                }
                final Position position = NbDocument.createPosition((Document)this.doc, (int)difference.getStartPosition().getOffset(), (Position.Bias)Position.Bias.Backward);
                final int n = difference.getNewText().length();
                modificationResult.commit();
                final ChangeInfo[] changeInfoArray = new ChangeInfo[1];
                this.doc.render(new Runnable(){

                    public void run() {
                        try {
                            String string = FixImpl.this.doc.getText(position.getOffset(), n);
                            Logger.getLogger(AssignResultToVariable.class.getName()).log(Level.FINE, "text after commit: {0}", string);
                            int n3 = string.lastIndexOf(stringArray[0]);
                            Logger.getLogger(AssignResultToVariable.class.getName()).log(Level.FINE, "relPos: {0}", n3);
                            if (n3 != -1) {
                                int n2 = position.getOffset() + n3;
                                changeInfoArray[0] = new ChangeInfo(FixImpl.this.doc.createPosition(n2), FixImpl.this.doc.createPosition(n2 + stringArray[0].length()));
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
                return changeInfoArray[0];
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return null;
        }
    }
}

