/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.util.Collections;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public final class PaletteItem
implements Node.Cookie {
    public static final String TYPE_CHOOSE_BEAN = "chooseBean";
    private PaletteItemDataObject itemDataObject;
    ClassSource componentClassSource;
    String componentType_explicit;
    Image icon;
    private FileObject cpRepresentative;
    private Class componentClass;
    private Throwable lastError;
    private int componentType = -1;
    private static final int LAYOUT = 1;
    private static final int BORDER = 2;
    private static final int VISUAL = 4;
    private static final int MENU = 8;
    private static final int TYPE_MASK = 15;

    PaletteItem(PaletteItemDataObject paletteItemDataObject) {
        this.itemDataObject = paletteItemDataObject;
    }

    public PaletteItem(ClassSource classSource, Class clazz) {
        this.componentClassSource = classSource;
        this.componentClass = clazz;
    }

    public void setComponentClassSource(ClassSource classSource) {
        this.componentClass = null;
        this.lastError = null;
        this.componentType = -1;
        this.componentClassSource = classSource;
    }

    void setComponentExplicitType(String string) {
        this.componentType_explicit = string;
    }

    public void setClassFromCurrentProject(String string, FileObject fileObject) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf(60)) != -1) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        this.setComponentClassSource(new ClassSource(string == null ? null : string.trim(), Collections.EMPTY_LIST, string2));
        this.cpRepresentative = fileObject;
    }

    public Node getNode() {
        return this.itemDataObject == null || !this.itemDataObject.isValid() ? null : this.itemDataObject.getNodeDelegate();
    }

    public String getId() {
        return this.getComponentClassName();
    }

    public String getComponentClassName() {
        return this.componentClassSource.getClassName();
    }

    public ClassSource getComponentClassSource() {
        return this.componentClassSource;
    }

    public Class getComponentClass() {
        if (this.componentClass == null && this.lastError == null) {
            this.componentClass = this.loadComponentClass();
        }
        return this.componentClass;
    }

    public Throwable getError() {
        return this.lastError;
    }

    public String getExplicitComponentType() {
        return this.componentType_explicit;
    }

    public boolean isVisual() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 4) != 0;
    }

    public boolean isMenu() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 8) != 0;
    }

    public boolean isLayout() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 0xF) == 1;
    }

    public boolean isBorder() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 0xF) == 2;
    }

    public String toString() {
        return PaletteUtils.getItemComponentDescription(this);
    }

    String getDisplayName() {
        BeanDescriptor beanDescriptor = this.getBeanDescriptor();
        return beanDescriptor != null ? beanDescriptor.getDisplayName() : null;
    }

    String getTooltip() {
        BeanDescriptor beanDescriptor = this.getBeanDescriptor();
        return beanDescriptor != null ? beanDescriptor.getShortDescription() : null;
    }

    public Image getIcon(int n) {
        if (this.icon != null) {
            return this.icon;
        }
        BeanInfo beanInfo = this.getBeanInfo();
        return beanInfo != null ? beanInfo.getIcon(n) : null;
    }

    public void setIcon(Image image) {
        this.icon = image;
    }

    void reset() {
        this.componentClass = null;
        this.lastError = null;
        this.componentType = -1;
        this.itemDataObject.displayName = null;
        this.itemDataObject.tooltip = null;
        this.itemDataObject.icon16 = null;
        this.itemDataObject.icon32 = null;
    }

    private Class loadComponentClass() {
        try {
            if (this.cpRepresentative != null) {
                return ClassPathUtils.loadClass(this.getComponentClassSource().getClassName(), this.cpRepresentative);
            }
            return ClassPathUtils.loadClass(this.getComponentClassSource());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            this.lastError = exception;
        }
        catch (LinkageError linkageError) {
            ErrorManager.getDefault().notify(1, (Throwable)linkageError);
            this.lastError = linkageError;
        }
        return null;
    }

    private BeanInfo getBeanInfo() {
        Class clazz = this.getComponentClass();
        if (clazz != null) {
            try {
                return FormUtils.getBeanInfo(clazz);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanDescriptor getBeanDescriptor() {
        Class clazz = this.getComponentClass();
        if (clazz != null) {
            try {
                return FormUtils.getBeanInfo(clazz).getBeanDescriptor();
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return null;
    }

    private void resolveComponentType() {
        if (this.componentType_explicit == null) {
            this.componentType = 0;
            Class clazz = this.getComponentClass();
            if (clazz == null) {
                return;
            }
            if (LayoutManager.class.isAssignableFrom(clazz)) {
                this.componentType = 1;
                return;
            }
            if (Border.class.isAssignableFrom(clazz)) {
                this.componentType = 2;
                return;
            }
            if (Component.class.isAssignableFrom(clazz)) {
                this.componentType |= 4;
            }
            if (MenuComponent.class.isAssignableFrom(clazz) || JMenuItem.class.isAssignableFrom(clazz) || JMenuBar.class.isAssignableFrom(clazz) || JPopupMenu.class.isAssignableFrom(clazz)) {
                this.componentType |= 8;
            }
        } else {
            this.componentType = "visual".equalsIgnoreCase(this.componentType_explicit) ? 4 : ("layout".equalsIgnoreCase(this.componentType_explicit) ? 1 : ("border".equalsIgnoreCase(this.componentType_explicit) ? 2 : ("menu".equalsIgnoreCase(this.componentType_explicit) ? 12 : 0)));
        }
    }
}

