/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.form.editors.ClassPathFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class ImportImageWizard
extends WizardDescriptor {
    private WizardDescriptor.Iterator wizardIterator;
    private File[] selectedFiles;
    private FileObject targetFolder;
    private FileObject fileInProject;
    static String lastDirectoryUsed;

    ImportImageWizard(File[] fileArray, FileObject fileObject, FileObject fileObject2) {
        this((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(new WizardDescriptor.Panel[]{new SourceWizardPanel(), new TargetWizardPanel()}));
        if (fileObject != null) assert (FileOwnerQuery.getOwner((FileObject)fileObject) == FileOwnerQuery.getOwner((FileObject)fileObject2));
        this.selectedFiles = fileArray;
        this.targetFolder = fileObject;
        this.fileInProject = fileObject2;
    }

    private ImportImageWizard(WizardDescriptor.Iterator iterator) {
        super(iterator);
        this.wizardIterator = iterator;
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Title"));
        this.setTitleFormat(new MessageFormat("{0}"));
        this.putProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step1"), NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step2")});
    }

    FileObject[] show() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        dialog.setVisible(true);
        dialog.dispose();
        return this.getValue() == FINISH_OPTION ? this.copyFiles() : null;
    }

    void stepToNext() {
        if (this.wizardIterator.hasNext()) {
            this.wizardIterator.nextPanel();
            this.updateState();
        }
    }

    private FileObject[] copyFiles() {
        if (this.selectedFiles == null || this.selectedFiles.length == 0 || this.targetFolder == null) {
            return null;
        }
        final FileObject[] fileObjectArray = new FileObject[this.selectedFiles.length];
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    for (int i = 0; i < ImportImageWizard.this.selectedFiles.length; ++i) {
                        File file = ImportImageWizard.this.selectedFiles[i];
                        String string = file.getName();
                        FileObject fileObject = ImportImageWizard.this.targetFolder.getFileObject(string);
                        if (fileObject != null && fileObject.isFolder()) {
                            fileObject = null;
                        }
                        if (fileObject == null || ImportImageWizard.this.canRewriteTarget(file, fileObject)) {
                            if (fileObject != null) {
                                fileObject.delete();
                            }
                            FileInputStream fileInputStream = new FileInputStream(file);
                            fileObject = ImportImageWizard.this.targetFolder.createData(string);
                            FileLock fileLock = fileObject.lock();
                            OutputStream outputStream = fileObject.getOutputStream(fileLock);
                            byte[] byArray = new byte[4096];
                            try {
                                int n;
                                while ((n = fileInputStream.read(byArray)) != -1) {
                                    outputStream.write(byArray, 0, n);
                                }
                            }
                            finally {
                                outputStream.close();
                                fileLock.releaseLock();
                            }
                        }
                        fileObjectArray[i] = fileObject;
                    }
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return fileObjectArray;
    }

    private boolean canRewriteTarget(File file, FileObject fileObject) {
        FileObject fileObject2 = FileUtil.toFileObject((File)file);
        if (fileObject2 != null && fileObject2.equals(fileObject)) {
            return false;
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getMessage(ImportImageWizard.class, (String)"FMT_ReplaceExistingFileQuestion"), file.getName()), NbBundle.getMessage(ImportImageWizard.class, (String)"TITLE_FileAlreadyExists"), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION;
    }

    static /* synthetic */ File[] access$202(ImportImageWizard importImageWizard, File[] fileArray) {
        importImageWizard.selectedFiles = fileArray;
        return fileArray;
    }

    private static class TargetWizardPanel
    implements WizardDescriptor.Panel {
        private ImportImageWizard wizard;
        private ClassPathFileChooser cpfChooser;
        private EventListenerList listenerList;
        private boolean setTargetFolder;

        private TargetWizardPanel() {
        }

        public Component getComponent() {
            if (this.cpfChooser == null) {
                this.cpfChooser = new ClassPathFileChooser(this.wizard.fileInProject, new ClassPathFileChooser.Filter(){

                    public boolean accept(FileObject fileObject) {
                        return fileObject.isFolder();
                    }
                }, true, false);
                this.cpfChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (!TargetWizardPanel.this.setTargetFolder && "selectedFile".equals(propertyChangeEvent.getPropertyName())) {
                            TargetWizardPanel.this.fireStateChanged();
                        }
                    }
                });
                this.cpfChooser.setPreferredSize(new Dimension(200, 200));
                this.cpfChooser.setName(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step2"));
                this.cpfChooser.putClientProperty("WizardPanel_contentSelectedIndex", 1);
            }
            if (this.setTargetFolder) {
                this.cpfChooser.setSelectedFile(this.wizard.targetFolder);
                this.setTargetFolder = false;
            }
            return this.cpfChooser;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object object) {
            this.wizard = (ImportImageWizard)((Object)object);
            this.setTargetFolder = true;
        }

        public void storeSettings(Object object) {
            if (this.cpfChooser != null) {
                this.wizard.targetFolder = this.cpfChooser.getSelectedFile();
            }
        }

        public boolean isValid() {
            if (this.cpfChooser != null) {
                FileObject fileObject = this.cpfChooser.getSelectedFile();
                return fileObject != null && fileObject.isFolder();
            }
            if (this.wizard != null) {
                return this.wizard.targetFolder != null;
            }
            return false;
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            if (this.listenerList != null) {
                this.listenerList.remove(ChangeListener.class, changeListener);
            }
        }

        void fireStateChanged() {
            if (this.listenerList == null) {
                return;
            }
            ChangeEvent changeEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
            }
        }
    }

    private static class SourceWizardPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishablePanel {
        private ImportImageWizard wizard;
        private JFileChooser fileChooser;
        private EventListenerList listenerList;
        private boolean setSelectedFiles;

        private SourceWizardPanel() {
        }

        public Component getComponent() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(lastDirectoryUsed);
                this.fileChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.setAcceptAllFileFilterUsed(true);
                this.fileChooser.setControlButtonsAreShown(false);
                this.fileChooser.setMultiSelectionEnabled(true);
                this.fileChooser.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                            SourceWizardPanel.this.wizard.stepToNext();
                        } else if ("CancelSelection".equals(actionEvent.getActionCommand())) {
                            SourceWizardPanel.this.fileChooser.getTopLevelAncestor().setVisible(false);
                        }
                    }
                });
                this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (!SourceWizardPanel.this.setSelectedFiles && "SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                            SourceWizardPanel.this.fireStateChanged();
                        }
                    }
                });
                this.fileChooser.setName(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step1"));
                this.fileChooser.putClientProperty("WizardPanel_contentSelectedIndex", 0);
            }
            if (this.setSelectedFiles) {
                this.fileChooser.setSelectedFiles(this.wizard.selectedFiles);
                this.setSelectedFiles = false;
            }
            return this.fileChooser;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object object) {
            this.wizard = (ImportImageWizard)((Object)object);
            this.setSelectedFiles = true;
        }

        public void storeSettings(Object object) {
            if (this.fileChooser != null) {
                File[] fileArray = this.fileChooser.getSelectedFiles();
                ImportImageWizard.access$202((ImportImageWizard)((Object)object), fileArray);
                if (fileArray != null && fileArray.length > 0) {
                    lastDirectoryUsed = fileArray[0].getParent();
                }
            }
        }

        public boolean isValid() {
            return this.fileChooser != null && this.fileChooser.getSelectedFiles().length > 0;
        }

        public boolean isFinishPanel() {
            return this.wizard != null && this.wizard.targetFolder != null;
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            if (this.listenerList != null) {
                this.listenerList.remove(ChangeListener.class, changeListener);
            }
        }

        void fireStateChanged() {
            if (this.listenerList == null) {
                return;
            }
            ChangeEvent changeEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
            }
        }
    }
}

