/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;

public interface FormPropertyContext {
    public boolean useMultipleEditors();

    public void initPropertyEditor(PropertyEditor var1, FormProperty var2);

    public FormModel getFormModel();

    public Object getOwner();

    public static class EmptyImpl
    implements FormPropertyContext {
        private static EmptyImpl theInstance = null;

        public boolean useMultipleEditors() {
            return false;
        }

        public void initPropertyEditor(PropertyEditor propertyEditor, FormProperty formProperty) {
            if (propertyEditor instanceof FormAwareEditor) {
                ((FormAwareEditor)((Object)propertyEditor)).setContext(this.getFormModel(), formProperty);
            }
        }

        public FormModel getFormModel() {
            return null;
        }

        public Object getOwner() {
            return null;
        }

        public static EmptyImpl getInstance() {
            if (theInstance == null) {
                theInstance = new EmptyImpl();
            }
            return theInstance;
        }
    }

    public static class SubProperty
    implements FormPropertyContext {
        private FormProperty parentProperty;

        public SubProperty(FormProperty formProperty) {
            this.parentProperty = formProperty;
        }

        public boolean useMultipleEditors() {
            return this.parentProperty.getPropertyContext().useMultipleEditors();
        }

        public void initPropertyEditor(PropertyEditor propertyEditor, FormProperty formProperty) {
            this.parentProperty.getPropertyContext().initPropertyEditor(propertyEditor, formProperty);
        }

        public FormModel getFormModel() {
            return this.parentProperty.getPropertyContext().getFormModel();
        }

        public Object getOwner() {
            return this.parentProperty;
        }
    }

    public static class Component
    implements FormPropertyContext {
        private RADComponent component;

        public Component(RADComponent rADComponent) {
            this.component = rADComponent;
        }

        public boolean useMultipleEditors() {
            return true;
        }

        public void initPropertyEditor(PropertyEditor propertyEditor, FormProperty formProperty) {
            if (propertyEditor instanceof FormAwareEditor) {
                ((FormAwareEditor)((Object)propertyEditor)).setContext(this.getFormModel(), formProperty);
            }
        }

        public FormModel getFormModel() {
            return this.component.getFormModel();
        }

        public RADComponent getOwner() {
            return this.component;
        }
    }
}

