/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.fakepeer.FakePeerContainer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

class ComponentLayer
extends JPanel {
    private static final int HORIZONTAL_MARGIN = 12;
    private static final int VERTICAL_MARGIN = 12;
    private Container componentContainer = new FakePeerContainer();
    private DesignerPanel designerPanel;

    ComponentLayer(FormModel formModel) {
        this.componentContainer.setLayout(new BorderLayout());
        this.componentContainer.setBackground(Color.white);
        this.componentContainer.setFont(FakePeerSupport.getDefaultAWTFont());
        this.designerPanel = new DesignerPanel(formModel);
        this.designerPanel.setLayout(new BorderLayout());
        this.designerPanel.add((Component)this.componentContainer, "Center");
        this.setLayout(new FlowLayout(0, 12, 12));
        this.add(this.designerPanel);
        this.updateBackground();
    }

    Container getComponentContainer() {
        return this.componentContainer;
    }

    Rectangle getDesignerInnerBounds() {
        Rectangle rectangle = new Rectangle(this.designerPanel.getDesignerSize());
        Insets insets = this.designerPanel.getInsets();
        rectangle.x = 12 + insets.left;
        rectangle.y = 12 + insets.top;
        return rectangle;
    }

    Rectangle getDesignerOuterBounds() {
        return this.designerPanel.getBounds();
    }

    Insets getDesignerOutsets() {
        return this.designerPanel.getInsets();
    }

    Dimension getDesignerSize() {
        return this.designerPanel.getDesignerSize();
    }

    Dimension setDesignerSize(Dimension dimension) {
        if (dimension == null) {
            dimension = this.componentContainer.getComponent(0).getPreferredSize();
        }
        if (!dimension.equals(this.designerPanel.getDesignerSize())) {
            this.designerPanel.setDesignerSize(dimension);
        }
        return dimension;
    }

    void setTopDesignComponent(Component component) {
        if (this.componentContainer.getComponentCount() > 0) {
            this.componentContainer.removeAll();
        }
        this.componentContainer.add(component, "Center");
    }

    void updateVisualSettings() {
        this.updateBackground();
        this.designerPanel.updateBorder();
    }

    private void updateBackground() {
        this.setBackground(FormLoaderSettings.getInstance().getFormDesignerBackgroundColor());
    }

    private static class DesignerPanel
    extends JPanel {
        private static int BORDER_THICKNESS = 4;
        private Dimension designerSize = new Dimension(400, 300);
        private FormModel formModel;

        DesignerPanel(FormModel formModel) {
            this.formModel = formModel;
            this.updateBorder();
        }

        void updateBorder() {
            this.setBorder(new LineBorder(FormLoaderSettings.getInstance().getFormDesignerBorderColor(), BORDER_THICKNESS));
        }

        Dimension getDesignerSize() {
            return this.designerSize;
        }

        void setDesignerSize(Dimension dimension) {
            this.designerSize = dimension;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(this.designerSize);
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            try {
                FormLAF.setUseDesignerDefaults(this.formModel);
                super.paint(graphics);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                String string = NbBundle.getMessage(ComponentLayer.class, (String)"MSG_Paiting_Exception");
                string = "<html><b>" + string + "</b><br><br>";
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                string = string + stringWriter.toString().replaceAll("\n", "<br>");
                Insets insets = this.getInsets();
                JLabel jLabel = new JLabel(string);
                jLabel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
                jLabel.setOpaque(true);
                jLabel.setVerticalAlignment(1);
                jLabel.setSize(this.getWidth() - (insets.left + insets.top), this.getHeight() - (insets.top + insets.bottom));
                Shape shape = graphics.getClip();
                Rectangle rectangle = new Rectangle(insets.left, insets.top, jLabel.getWidth(), jLabel.getHeight());
                Rectangle rectangle2 = graphics.getClipBounds();
                if (rectangle2 != null) {
                    rectangle = rectangle.intersection(rectangle2);
                }
                graphics.setClip(rectangle);
                graphics.translate(insets.left, insets.top);
                jLabel.paint(graphics);
                graphics.translate(-insets.left, -insets.top);
                graphics.setClip(shape);
            }
            finally {
                FormLAF.setUseDesignerDefaults(null);
            }
        }
    }
}

