/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.assistance;

import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.asm.core.assistance.CodeAnnotationSidebar;
import org.netbeans.modules.cnd.asm.core.assistance.LiveRangesAccessor;
import org.netbeans.modules.cnd.asm.core.assistance.LiveRangesAction;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterChooser;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterChooserListener;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.model.AsmModelAccessor;
import org.netbeans.modules.cnd.asm.model.AsmState;
import org.netbeans.modules.cnd.asm.model.lang.AsmOffsetable;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveRangesAssistance
implements AsmModelAccessor.ParseListener,
CaretListener,
RegisterChooserListener {
    private final CodeAnnotationSidebar sideBar;
    private final LiveRangesAction action;
    private LiveRangesAccessor accessor;
    private RegisterChooser lastChooser;
    private AsmOffsetable lastRangeStart;
    private AsmOffsetable lastRangeEnd;
    private final BaseDocument doc;
    private final JEditorPane pane;
    private final EditorCookie cookie;

    public LiveRangesAssistance(BaseDocument baseDocument) {
        this.doc = baseDocument;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
        this.cookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        this.pane = this.cookie.getOpenedPanes()[0];
        this.pane.addCaretListener(this);
        this.action = new LiveRangesAction();
        this.sideBar = (CodeAnnotationSidebar)this.pane.getClientProperty("LIVE_RANGE_SIDEBAR");
        AsmModelAccessor asmModelAccessor = AsmObjectUtilities.getAccessor((Document)baseDocument);
        if (asmModelAccessor == null) {
            return;
        }
        asmModelAccessor.addParseListener(this);
    }

    @Override
    public void notifyParsed() {
        AsmState asmState = AsmObjectUtilities.getAccessor((Document)this.doc).getState();
        this.accessor = this.action.calculateRanges(asmState);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LiveRangesAssistance.this.calcLiveRanges(LiveRangesAssistance.this.getCaretPosition());
            }
        });
    }

    @Override
    public void update(RegisterChooser registerChooser) {
        this.lastChooser = registerChooser;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LiveRangesAssistance.this.calcLiveRanges(LiveRangesAssistance.this.getCaretPosition());
            }
        });
    }

    private int getCaretPosition() {
        return this.pane.getCaretPosition();
    }

    private void addAnnotation(AsmOffsetable asmOffsetable, AsmOffsetable asmOffsetable2, List<CodeAnnotationSidebar.AnnotationEntry> list) {
        try {
            int n = Utilities.getLineOffset((BaseDocument)this.doc, (int)(asmOffsetable.getStartOffset() + 1));
            int n2 = Utilities.getLineOffset((BaseDocument)this.doc, (int)(asmOffsetable2.getStartOffset() + 1));
            list.add(new CodeAnnotationSidebar.AnnotationEntry(Color.GREEN, n + 1, n2 + 1));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void calcLiveRanges(int n) {
        if (this.lastChooser == null) {
            return;
        }
        LinkedList<CodeAnnotationSidebar.AnnotationEntry> linkedList = new LinkedList<CodeAnnotationSidebar.AnnotationEntry>();
        AsmState asmState = AsmObjectUtilities.getAccessor((Document)this.doc).getState();
        if (this.accessor == null) {
            this.accessor = this.action.calculateRanges(asmState);
        }
        for (Register register : this.lastChooser.getRegisters()) {
            this.lastRangeEnd = null;
            this.lastRangeStart = null;
            List<Integer> list = this.accessor.getRangesForRegister(register);
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                AsmOffsetable asmOffsetable = asmState.getElements().getCompounds().get(iterator.next());
                AsmOffsetable asmOffsetable2 = asmState.getElements().getCompounds().get(iterator.next());
                this.addAnnotation(asmOffsetable, asmOffsetable2, linkedList);
            }
        }
        this.sideBar.setAnnotations(linkedList);
    }

    private boolean isInRange(AsmOffsetable asmOffsetable, AsmOffsetable asmOffsetable2, int n) {
        return this.isInRange(asmOffsetable.getStartOffset(), asmOffsetable2.getStartOffset(), n);
    }

    private boolean isInRange(int n, int n2, int n3) {
        return n <= n3 && n3 < n2;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = LiveRangesAssistance.this.getCaretPosition();
                if (LiveRangesAssistance.this.lastRangeStart != null && LiveRangesAssistance.this.lastRangeEnd != null && LiveRangesAssistance.this.isInRange(LiveRangesAssistance.this.lastRangeStart, LiveRangesAssistance.this.lastRangeEnd, n)) {
                    return;
                }
                LiveRangesAssistance.this.calcLiveRanges(n);
            }
        });
    }
}

