/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.assistance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeAnnotationSidebar
extends JComponent
implements ComponentListener {
    private List<AnnotationEntry> curAnnotations;
    private static final int SIDEBAR_WIDTH = 9;
    private static final Color colorBorder = new Color(102, 102, 102);
    private EditorUI editorUI;
    private JTextComponent target;
    private boolean enabled;

    public CodeAnnotationSidebar(JTextComponent jTextComponent) {
        this.target = jTextComponent;
        this.editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        this.enabled = true;
        jTextComponent.addComponentListener(this);
        this.updatePreferredSize();
    }

    public void setAnnotations(List<AnnotationEntry> list) {
        this.curAnnotations = list;
        this.repaint();
    }

    private boolean enableSideBarComponent(boolean bl) {
        if (bl == this.enabled) {
            return false;
        }
        this.enabled = bl;
        this.updatePreferredSize();
        return true;
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(9, this.target.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        JTextComponent jTextComponent;
        super.paintComponent(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.y >= 16) {
            rectangle.y -= 16;
            rectangle.height += 16;
        }
        if ((jTextComponent = this.editorUI.getComponent()) == null) {
            return;
        }
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        View view = Utilities.getDocumentView((JTextComponent)jTextComponent);
        if (view == null) {
            return;
        }
        graphics.setColor(this.target.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            int n = baseTextUI.getPosFromY(rectangle.y);
            int n2 = view.getViewIndex(n, Position.Bias.Forward);
            int n3 = view.getViewCount();
            if (n2 >= 0 && n2 < n3) {
                Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, view.getView(n2).getStartOffset());
                int n4 = rectangle2 == null ? 0 : rectangle2.y;
                int n5 = rectangle.y + rectangle.height;
                Element element = baseTextUI.getRootView(jTextComponent).getElement();
                if (this.curAnnotations == null) {
                    return;
                }
                for (int i = n2; i < n3; ++i) {
                    View view2 = view.getView(i);
                    int n6 = element.getElementIndex(view2.getStartOffset()) + 1;
                    AnnotationEntry annotationEntry = this.getAnnotationAtLine(n6);
                    if (annotationEntry != null) {
                        graphics.setColor(annotationEntry.getColor());
                        graphics.fillRect(3, n4, 6, this.editorUI.getLineHeight());
                        graphics.setColor(colorBorder);
                        int n7 = n4 + this.editorUI.getLineHeight();
                        if (n6 == annotationEntry.getStartAnn()) {
                            graphics.drawLine(2, n4, 8, n4);
                        }
                        graphics.drawLine(2, n4, 2, n7);
                        if (n6 == annotationEntry.getEndAnn()) {
                            graphics.drawLine(2, n7, 8, n7);
                        }
                    }
                    if ((n4 += this.editorUI.getLineHeight()) >= n5) break;
                }
            }
            this.revalidate();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private AnnotationEntry getAnnotationAtLine(int n) {
        for (AnnotationEntry annotationEntry : this.curAnnotations) {
            if (annotationEntry.getStartAnn() > n) {
                return null;
            }
            if (annotationEntry.getEndAnn() < n) continue;
            return annotationEntry;
        }
        return null;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public static class AnnotationEntry {
        private final Color color;
        private final int startAnn;
        private final int endAnn;

        public AnnotationEntry(Color color, int n, int n2) {
            this.color = color;
            this.startAnn = n;
            this.endAnn = n2;
        }

        public Color getColor() {
            return this.color;
        }

        public int getStartAnn() {
            return this.startAnn;
        }

        public int getEndAnn() {
            return this.endAnn;
        }
    }
}

