/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LevelOfDetailsWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.DependencyGraphScene;
import org.netbeans.modules.maven.graph.EdgeWidget;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArtifactWidget
extends Widget
implements ActionListener,
SelectProvider {
    static final Color ROOT = new Color(178, 228, 255);
    static final Color DIRECTS = new Color(178, 228, 255);
    static final Color DIRECTS_CONFLICT = new Color(235, 88, 194);
    static final Color DISABLE_HIGHTLIGHT = new Color(255, 255, 194);
    static final Color HIGHTLIGHT = new Color(255, 255, 129);
    static final Color DISABLE_CONFLICT = new Color(219, 155, 153);
    static final Color CONFLICT = new Color(219, 11, 5);
    static final Color MANAGED = new Color(30, 255, 150);
    static final Color WARNING = new Color(255, 150, 20);
    static final Color DISABLE_WARNING = EdgeWidget.deriveColor(WARNING, 0.7f);
    static final Color PROVIDED = new Color(191, 255, 255);
    static final Color COMPILE = new Color(191, 191, 255);
    static final Color RUNTIME = new Color(191, 255, 191);
    static final Color TEST = new Color(202, 151, 151);
    private static final int LEFT_TOP = 1;
    private static final int LEFT_BOTTOM = 2;
    private static final int RIGHT_TOP = 3;
    private static final int RIGHT_BOTTOM = 4;
    private static final Image lockImg = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/graph/lock.png");
    private static final Image brokenLockImg = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/graph/lock-broken.png");
    private static final Image bulbImg = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/graph/bulb.gif");
    private static final Image bulbHighlightImg = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/graph/bulb-highlight.gif");
    private ArtifactGraphNode node;
    private String currentSearchTerm;
    private List<String> scopes;
    private boolean readable = false;
    private boolean enlargedFromHover = false;
    private Timer hoverTimer;
    private Color hoverBorderC;
    private LabelWidget artifactW;
    private LabelWidget versionW;
    private Widget contentW;
    private ImageWidget lockW;
    private ImageWidget fixHintW;
    private int paintState = 2;
    private Font origFont;
    private Color origForeground;
    private String tooltipText;

    ArtifactWidget(DependencyGraphScene dependencyGraphScene, ArtifactGraphNode artifactGraphNode) {
        super((Scene)dependencyGraphScene);
        this.node = artifactGraphNode;
        Artifact artifact = artifactGraphNode.getArtifact().getArtifact();
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.updateTooltip();
        this.initContent(dependencyGraphScene, artifact);
        this.hoverTimer = new Timer(500, this);
        this.hoverTimer.setRepeats(false);
        this.hoverBorderC = UIManager.getColor("TextPane.selectionBackground");
        if (this.hoverBorderC == null) {
            this.hoverBorderC = Color.GRAY;
        }
    }

    void hightlightText(String string) {
        this.currentSearchTerm = string;
        this.doHightlightText(string);
    }

    private void updateTooltip() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        DependencyNode dependencyNode = null;
        int n2 = this.node.getConflictType();
        if (n2 != 0) {
            for (DependencyNode dependencyNode2 : this.node.getDuplicatesOrConflicts()) {
                if (dependencyNode2.getState() != 2) continue;
                ++n;
                if (dependencyNode != null) continue;
                dependencyNode = dependencyNode2;
            }
        }
        if (n == 1) {
            stringBuilder.append(NbBundle.getMessage(ArtifactWidget.class, (String)(n2 == 2 ? "TIP_SingleConflict" : "TIP_SingleWarning"), (Object)dependencyNode.getArtifact().getVersion(), (Object)dependencyNode.getParent().getArtifact().getArtifactId()));
        } else if (n > 1) {
            stringBuilder.append(NbBundle.getMessage(ArtifactWidget.class, (String)(n2 == 2 ? "TIP_MultipleConflict" : "TIP_MultipleWarning")));
            for (DependencyNode dependencyNode2 : this.node.getDuplicatesOrConflicts()) {
                if (dependencyNode2.getState() != 2) continue;
                stringBuilder.append("<tr><td>");
                stringBuilder.append(dependencyNode2.getArtifact().getVersion());
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
                stringBuilder.append(dependencyNode2.getParent().getArtifact().getArtifactId());
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</tbody></table>");
        }
        Artifact artifact = this.node.getArtifact().getArtifact();
        this.tooltipText = NbBundle.getMessage(DependencyGraphScene.class, (String)"TIP_Artifact", (Object[])new Object[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getType(), stringBuilder.toString()});
        this.setToolTipText(this.tooltipText);
    }

    private void doHightlightText(String string) {
        if (string != null && this.node.getArtifact().getArtifact().getArtifactId().contains(string)) {
            this.artifactW.setBackground((Paint)HIGHTLIGHT);
            this.artifactW.setOpaque(true);
            this.setPaintState(2);
            this.setReadable(true);
        } else {
            this.artifactW.setBackground((Paint)Color.WHITE);
            this.artifactW.setOpaque(false);
            this.setPaintState(1);
            this.setReadable(false);
        }
    }

    void hightlightScopes(List<String> list) {
        this.scopes = list;
    }

    private Color colorForScope(String string) {
        if (Artifact.SCOPE_COMPILE.equals(string)) {
            return COMPILE;
        }
        if (Artifact.SCOPE_PROVIDED.equals(string)) {
            return PROVIDED;
        }
        if (Artifact.SCOPE_RUNTIME.equals(string)) {
            return RUNTIME;
        }
        if (Artifact.SCOPE_TEST.equals(string)) {
            return TEST;
        }
        return Color.BLACK;
    }

    void setPaintState(int n) {
        if (this.paintState == n) {
            return;
        }
        this.paintState = n;
        this.updatePaintContent();
    }

    int getPaintState() {
        return this.paintState;
    }

    private void updatePaintContent() {
        if (this.origForeground == null) {
            this.origForeground = this.getForeground();
        }
        boolean bl = this.paintState == 0;
        Color color = this.origForeground;
        if (this.paintState == 1 || bl) {
            color = UIManager.getColor("textInactiveText");
            if (color == null) {
                color = Color.LIGHT_GRAY;
            }
            if (bl) {
                color = new Color((int)((float)color.getAlpha() / 1.3f), color.getRed(), color.getGreen(), color.getBlue());
            }
        }
        this.contentW.setBorder(BorderFactory.createLineBorder((int)10, (Color)color));
        this.artifactW.setForeground(color);
        this.versionW.setForeground(color);
        if (this.lockW != null) {
            this.lockW.setPaintAsDisabled(this.paintState == 1);
            this.lockW.setVisible(!bl);
        }
        this.setToolTipText(this.paintState != 0 ? this.tooltipText : null);
        this.contentW.repaint();
    }

    private void initContent(DependencyGraphScene dependencyGraphScene, Artifact artifact) {
        Font font;
        this.contentW = new LevelOfDetailsWidget((Scene)dependencyGraphScene, 0.05, 0.1, Double.MAX_VALUE, Double.MAX_VALUE);
        this.contentW.setBorder(BorderFactory.createLineBorder((int)10));
        this.contentW.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)1));
        this.artifactW = new LabelWidget((Scene)dependencyGraphScene);
        this.artifactW.setLabel(artifact.getArtifactId() + "  ");
        if (this.node.isRoot()) {
            font = dependencyGraphScene.getDefaultFont();
            this.artifactW.setFont(font.deriveFont(1, (float)font.getSize() + 3.0f));
        }
        this.contentW.addChild((Widget)this.artifactW);
        font = new LevelOfDetailsWidget((Scene)dependencyGraphScene, 0.5, 0.7, Double.MAX_VALUE, Double.MAX_VALUE);
        font.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)2));
        this.contentW.addChild((Widget)font);
        this.versionW = new LabelWidget((Scene)dependencyGraphScene);
        this.versionW.setLabel(artifact.getVersion());
        int n = this.node.getManagedState();
        if (n != 0) {
            this.lockW = new ImageWidget((Scene)dependencyGraphScene, n == 1 ? lockImg : brokenLockImg);
        }
        font.addChild((Widget)this.versionW);
        if (this.lockW != null) {
            font.addChild((Widget)this.lockW);
        }
        if (dependencyGraphScene.isEditable() && DependencyGraphScene.isFixCandidate(this.node)) {
            Widget widget = new Widget((Scene)dependencyGraphScene);
            widget.setLayout(LayoutFactory.createOverlayLayout());
            this.fixHintW = new ImageWidget((Scene)dependencyGraphScene, bulbImg);
            this.fixHintW.setVisible(false);
            this.fixHintW.setToolTipText(NbBundle.getMessage(ArtifactWidget.class, (String)"ACT_FixVersionConflict"));
            this.fixHintW.getActions().addAction(dependencyGraphScene.hoverAction);
            this.fixHintW.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this));
            Widget widget2 = new Widget((Scene)dependencyGraphScene);
            widget2.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)0));
            widget2.setBorder(BorderFactory.createEmptyBorder((int)0, (int)3));
            widget2.addChild((Widget)this.fixHintW);
            widget.addChild(widget2);
            widget.addChild(this.contentW);
            this.addChild(widget);
        } else {
            this.addChild(this.contentW);
        }
    }

    void modelChanged() {
        this.versionW.setLabel(this.node.getArtifact().getArtifact().getVersion());
        if (!DependencyGraphScene.isFixCandidate(this.node) && this.fixHintW != null) {
            this.fixHintW.setVisible(false);
            this.fixHintW = null;
        }
        this.updateTooltip();
        this.repaint();
    }

    protected void paintBackground() {
        super.paintBackground();
        if (this.paintState == 0) {
            return;
        }
        Graphics2D graphics2D = this.getScene().getGraphics();
        Rectangle rectangle = this.getClientArea();
        if (this.node.isRoot()) {
            ArtifactWidget.paintBottom(graphics2D, rectangle, ROOT, Color.WHITE, rectangle.height / 2);
        } else {
            if (this.scopes != null && this.scopes.size() > 0 && this.scopes.contains(this.node.getArtifact().getArtifact().getScope())) {
                Color color = this.colorForScope(this.node.getArtifact().getArtifact().getScope());
                ArtifactWidget.paintCorner(4, graphics2D, rectangle, color, Color.WHITE, rectangle.width / 2, rectangle.height / 2);
            }
            int n = this.node.getConflictType();
            Color color = null;
            if (n != 0) {
                color = n == 2 ? (this.paintState == 1 ? DISABLE_CONFLICT : CONFLICT) : (this.paintState == 1 ? DISABLE_WARNING : WARNING);
            } else {
                int n2 = this.node.getManagedState();
                if (2 == n2) {
                    color = WARNING;
                }
            }
            if (color != null) {
                ArtifactWidget.paintCorner(1, graphics2D, rectangle, color, Color.WHITE, rectangle.width, rectangle.height / 2);
            }
            if (this.node.getPrimaryLevel() == 1) {
                ArtifactWidget.paintBottom(graphics2D, rectangle, DIRECTS, Color.WHITE, rectangle.height / 6);
            }
        }
        if (this.getState().isHovered() || this.getState().isSelected()) {
            ArtifactWidget.paintHover(graphics2D, rectangle, this.hoverBorderC, this.getState().isSelected());
        }
    }

    private static void paintCorner(int n, Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2, int n2, int n3) {
        double d = n3 * n3 + n2 * n2;
        int n4 = (int)((double)(n3 * n3 * n2) / d);
        int n5 = (int)((double)(n3 * n2 * n2) / d);
        Point point = new Point();
        Point point2 = new Point();
        switch (n) {
            case 1: {
                point.x = rectangle.x;
                point.y = rectangle.y;
                point2.x = 1;
                point2.y = 1;
                break;
            }
            case 2: {
                point.x = rectangle.x;
                point.y = rectangle.y + rectangle.height;
                point2.x = 1;
                point2.y = -1;
                break;
            }
            case 3: {
                point.x = rectangle.x + rectangle.width;
                point.y = rectangle.y;
                point2.x = -1;
                point2.y = 1;
                break;
            }
            case 4: {
                point.x = rectangle.x + rectangle.width;
                point.y = rectangle.y + rectangle.height;
                point2.x = -1;
                point2.y = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Corner id not valid");
            }
        }
        graphics2D.setPaint(new GradientPaint(point.x, point.y, color, point.x + point2.x * n4, point.y + point2.y * n5, color2));
        graphics2D.fillRect(Math.min(point.x, point.x + point2.x * n2), Math.min(point.y, point.y + point2.y * n3), n2, n3);
    }

    private static void paintBottom(Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2, int n) {
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y + rectangle.height, color, rectangle.x, rectangle.y + rectangle.height - n, color2));
        graphics2D.fillRect(rectangle.x, rectangle.y + rectangle.height - n, rectangle.width, n);
    }

    private static void paintHover(Graphics2D graphics2D, Rectangle rectangle, Color color, boolean bl) {
        graphics2D.setColor(color);
        graphics2D.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        if (!bl) {
            graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 150));
        }
        graphics2D.drawRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        if (bl) {
            graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 150));
        } else {
            graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 75));
        }
        graphics2D.drawRect(rectangle.x + 3, rectangle.y + 3, rectangle.width - 6, rectangle.height - 6);
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        super.notifyStateChanged(objectState, objectState2);
        boolean bl = false;
        boolean bl2 = false;
        if (this.paintState != 0) {
            if (!objectState.isHovered() && objectState2.isHovered()) {
                this.hoverTimer.restart();
                bl = true;
            }
            if (objectState.isHovered() && !objectState2.isHovered()) {
                this.hoverTimer.stop();
                bl = true;
                bl2 = this.enlargedFromHover;
                this.enlargedFromHover = false;
            }
        }
        if (objectState.isSelected() != objectState2.isSelected()) {
            bl2 = true;
        }
        if (bl2) {
            this.updateContent();
        } else if (bl) {
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.enlargedFromHover = true;
        this.updateContent();
    }

    public void setReadable(boolean bl) {
        if (this.readable == bl) {
            return;
        }
        this.readable = bl;
        this.updateContent();
    }

    public boolean isReadable() {
        return this.readable;
    }

    public ArtifactGraphNode getNode() {
        return this.node;
    }

    private void updateContent() {
        Font font;
        boolean bl = ((DependencyGraphScene)this.getScene()).isAnimated();
        if (bl) {
            this.artifactW.setPreferredBounds(this.artifactW.getPreferredBounds());
        }
        boolean bl2 = this.getState().isSelected() || this.enlargedFromHover || this.readable;
        Font font2 = font = this.getOrigFont();
        if (bl2) {
            this.bringToFront();
            font2 = ArtifactWidget.getReadable(this.getScene(), font);
        }
        this.artifactW.setFont(font2);
        this.versionW.setFont(font2);
        if (bl) {
            this.getScene().getSceneAnimator().animatePreferredBounds((Widget)this.artifactW, null);
        }
        if (this.fixHintW != null) {
            this.fixHintW.setVisible(bl2);
        }
    }

    private Font getOrigFont() {
        if (this.origFont == null) {
            this.origFont = this.artifactW.getFont();
            if (this.origFont == null) {
                this.origFont = this.getScene().getDefaultFont();
            }
        }
        return this.origFont;
    }

    public static Font getReadable(Scene scene, Font font) {
        float f = (float)scene.getDefaultFont().getSize() / (float)font.getSize();
        float f2 = (float)Math.max(1.0, (double)f / Math.max((double)1.0E-4f, scene.getZoomFactor()));
        if (f2 != 1.0f) {
            return font.deriveFont((float)font.getSize() * f2);
        }
        return font;
    }

    public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
        return false;
    }

    public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
        return true;
    }

    public void select(Widget widget, Point point, boolean bl) {
        ((DependencyGraphScene)this.getScene()).invokeFixConflict(this.node);
    }

    void bulbHovered() {
        if (this.fixHintW != null) {
            this.fixHintW.setImage(bulbHighlightImg);
        }
    }

    void bulbUnhovered() {
        if (this.fixHintW != null) {
            this.fixHintW.setImage(bulbImg);
        }
    }
}

