/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.core.ui;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.websvc.customization.multiview.WSCustomizationTopComponent;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JaxWsRefreshCookie;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationWSEditor
implements WSEditor {
    private WSCustomizationTopComponent wsTopComponent;
    private boolean wsdlIsDirty;
    private boolean jaxwsDirty;
    private Definitions primaryDefinitions;
    private UndoManager undoManager;
    private JaxWsModel jaxWsModel;
    private Map<WSDLModel, Boolean> wsdlModels = new HashMap<WSDLModel, Boolean>();

    public CustomizationWSEditor(JaxWsModel jaxWsModel) {
        this.jaxWsModel = jaxWsModel;
    }

    public CustomizationWSEditor() {
    }

    private void saveAndRefresh(final Node node, JaxWsModel jaxWsModel) {
        if (this.wsTopComponent == null) {
            return;
        }
        Collection<SaveableSectionInnerPanel> collection = this.wsTopComponent.getPanels();
        for (SaveableSectionInnerPanel object2 : collection) {
            object2.save();
            if (!this.wsdlIsDirty) {
                this.wsdlIsDirty = object2.wsdlIsDirty();
            }
            if (this.jaxwsDirty) continue;
            this.jaxwsDirty = object2.jaxwsIsDirty();
        }
        try {
            Object object;
            if (this.wsdlIsDirty) {
                object = this.wsdlModels.keySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    WSDLModel wSDLModel = (WSDLModel)iterator.next();
                    ModelSource modelSource = wSDLModel.getModelSource();
                    FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie == null) continue;
                    saveCookie.save();
                }
            }
            if (this.jaxwsDirty) {
                jaxWsModel.write();
            }
            object = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CustomizationWSEditor.class, (String)"TXT_Refreshing"));
            object.start(100);
            object.switchToIndeterminate();
            Runnable runnable = new Runnable((ProgressHandle)object){
                final /* synthetic */ ProgressHandle val$handle;
                {
                    this.val$handle = progressHandle;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        JaxWsRefreshCookie jaxWsRefreshCookie;
                        if ((CustomizationWSEditor.this.wsdlIsDirty || CustomizationWSEditor.this.jaxwsDirty) && (jaxWsRefreshCookie = (JaxWsRefreshCookie)node.getCookie(JaxWsRefreshCookie.class)) != null) {
                            jaxWsRefreshCookie.refreshService(false);
                        }
                    }
                    finally {
                        this.val$handle.finish();
                    }
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public void save(Node node) {
        this.saveAndRefresh(node, this.jaxWsModel);
        this.removeListeners();
    }

    public JComponent createWSEditorComponent(Node node) {
        try {
            this.initializeModels(node);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return null;
        }
        this.wsTopComponent = new WSCustomizationTopComponent(node, this.getWSDLModels(), this.primaryDefinitions, false);
        this.wsTopComponent.setName(this.getTitle());
        return this.wsTopComponent;
    }

    public String getTitle() {
        return NbBundle.getMessage(CustomizationWSEditor.class, (String)"TITLE_WSDL_CUSTOMIZATION");
    }

    public Set<WSDLModel> getWSDLModels() {
        return this.wsdlModels.keySet();
    }

    private void initializeModels(Node node) throws Exception {
        if (this.wsdlModels.isEmpty()) {
            this.undoManager = new UndoManager();
            WSDLModel wSDLModel = this.getPrimaryModel(node);
            this.populateAllModels(wSDLModel);
            Set<WSDLModel> set = this.wsdlModels.keySet();
            for (WSDLModel wSDLModel2 : set) {
                wSDLModel2.addUndoableEditListener((UndoableEditListener)this.undoManager);
            }
        }
    }

    private void removeListeners() {
        Set<WSDLModel> set = this.wsdlModels.keySet();
        for (WSDLModel wSDLModel : set) {
            wSDLModel.removeUndoableEditListener((UndoableEditListener)this.undoManager);
        }
    }

    private DataObject getDataObjectOfModel(WSDLModel wSDLModel) {
        ModelSource modelSource = wSDLModel.getModelSource();
        return (DataObject)modelSource.getLookup().lookup(DataObject.class);
    }

    private boolean modelExists(WSDLModel wSDLModel) {
        if (this.wsdlModels.size() == 0) {
            return false;
        }
        DataObject dataObject = this.getDataObjectOfModel(wSDLModel);
        if (!dataObject.isValid()) {
            return true;
        }
        Set<WSDLModel> set = this.wsdlModels.keySet();
        for (WSDLModel wSDLModel2 : set) {
            DataObject dataObject2 = this.getDataObjectOfModel(wSDLModel2);
            if (!dataObject2.isValid() || !dataObject.equals(dataObject2)) continue;
            return true;
        }
        return false;
    }

    private void populateAllModels(WSDLModel wSDLModel) throws Exception {
        if (this.modelExists(wSDLModel)) {
            return;
        }
        DataObject dataObject = this.getDataObjectOfModel(wSDLModel);
        if (!dataObject.isValid()) {
            return;
        }
        Definitions definitions = wSDLModel.getDefinitions();
        if (definitions == null) {
            return;
        }
        if (definitions.getImports().size() == 0) {
            this.wsdlModels.put(wSDLModel, dataObject.isModified());
            return;
        }
        this.wsdlModels.put(wSDLModel, dataObject.isModified());
        Set<WSDLModel> set = this.getImportedModels(definitions);
        for (WSDLModel wSDLModel2 : set) {
            this.populateAllModels(wSDLModel2);
        }
    }

    private Set<WSDLModel> getImportedModels(Definitions definitions) throws CatalogModelException {
        HashSet<WSDLModel> hashSet = new HashSet<WSDLModel>();
        Collection collection = definitions.getImports();
        for (Import import_ : collection) {
            WSDLModel wSDLModel = import_.getImportedWSDLModel();
            hashSet.add(wSDLModel);
        }
        return hashSet;
    }

    private WSDLModel getPrimaryModel(Node node) throws MalformedURLException, Exception {
        JAXWSClientSupport jAXWSClientSupport;
        WSDLModel wSDLModel = null;
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        assert (fileObject != null);
        FileObject fileObject2 = null;
        if (client != null) {
            jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject);
            fileObject2 = jAXWSClientSupport.getLocalWsdlFolderForClient(client.getName(), false).getFileObject(client.getLocalWsdlFile());
        } else if (service != null && service.getWsdlUrl() != null) {
            jAXWSClientSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
            fileObject2 = jAXWSClientSupport.getLocalWsdlFolderForService(service.getName(), false).getFileObject(service.getLocalWsdlFile());
        } else {
            throw new Exception("Unable to identify node type");
        }
        if (fileObject2 == null) {
            throw new Exception("WSDL file not found");
        }
        jAXWSClientSupport = Utilities.getModelSource((FileObject)fileObject2, (boolean)true);
        wSDLModel = WSDLModelFactory.getDefault().getModel((ModelSource)jAXWSClientSupport);
        this.primaryDefinitions = wSDLModel.getDefinitions();
        return wSDLModel;
    }

    public void cancel(Node node) {
        if (this.undoManager != null) {
            while (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
        try {
            Set<WSDLModel> set = this.wsdlModels.keySet();
            for (WSDLModel wSDLModel : set) {
                ModelSource modelSource = wSDLModel.getModelSource();
                FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                dataObject.setModified(this.wsdlModels.get(wSDLModel).booleanValue());
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        this.removeListeners();
    }

    public String getDescription() {
        return NbBundle.getMessage(CustomizationWSEditor.class, (String)"WSDL_CUSTOMIZE_DESC");
    }
}

