/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.hostinfo.HostInfoProvider;
import org.netbeans.modules.nativeexecution.support.hostinfo.impl.HostInfoFactory;
import org.openide.util.Utilities;

public class WindowsHostInfoProvider
implements HostInfoProvider {
    private static final java.util.logging.Logger log = Logger.getInstance();

    public HostInfo getHostInfo(ExecutionEnvironment executionEnvironment) throws IOException {
        if (!executionEnvironment.isLocal() || !Utilities.isWindows()) {
            return null;
        }
        return new HostInfoImpl();
    }

    private static class HostInfoImpl
    implements HostInfo {
        private final HostInfo.OS os;
        private final HostInfo.Bitness osBitness;
        private final HostInfo.OSFamily osFamily;
        private final String osVersion;
        private final String osName;
        private final HostInfo.CpuFamily cpuFamily;
        private final int cpuNum;
        private final String hostname;
        private final String shell;
        private final File tmpDirFile;
        private final String tmpDir;
        private final String path;

        public HostInfoImpl() {
            Map<String, String> map = WindowsSupport.getInstance().getEnv();
            this.osBitness = "x86".equals(System.getProperty("os.arch")) ? HostInfo.Bitness._32 : HostInfo.Bitness._64;
            this.osFamily = HostInfo.OSFamily.WINDOWS;
            this.osVersion = System.getProperty("os.version");
            this.osName = System.getProperty("os.name");
            this.cpuFamily = HostInfo.CpuFamily.X86;
            int n = 1;
            try {
                n = Integer.parseInt(map.get("NUMBER_OF_PROCESSORS"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cpuNum = n;
            this.hostname = map.get("COMPUTERNAME");
            this.shell = WindowsSupport.getInstance().getShell();
            File file = null;
            String string = null;
            String string2 = "";
            String string3 = System.getProperty("java.io.tmpdir");
            file = new File(string3, "dlight_" + map.get("USERNAME"));
            file = new File(file, HostInfoFactory.getNBKey());
            file.mkdirs();
            string = file.getAbsolutePath();
            try {
                file = file.getCanonicalFile();
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.shell != null) {
                string = WindowsSupport.getInstance().convertToShellPath(string);
                string2 = map.get("PATH") + ';' + new File(this.shell).getParent();
            }
            this.tmpDirFile = file;
            this.tmpDir = string;
            this.path = string2;
            this.os = new HostInfo.OS(){

                public HostInfo.OSFamily getFamily() {
                    return HostInfoImpl.this.osFamily;
                }

                public String getName() {
                    return HostInfoImpl.this.osName;
                }

                public String getVersion() {
                    return HostInfoImpl.this.osVersion;
                }

                public HostInfo.Bitness getBitness() {
                    return HostInfoImpl.this.osBitness;
                }
            };
        }

        public HostInfo.OS getOS() {
            return this.os;
        }

        public HostInfo.CpuFamily getCpuFamily() {
            return this.cpuFamily;
        }

        public int getCpuNum() {
            return this.cpuNum;
        }

        public HostInfo.OSFamily getOSFamily() {
            return this.osFamily;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getShell() {
            return this.shell;
        }

        public String getTempDir() {
            return this.tmpDir;
        }

        public File getTempDirFile() {
            return this.tmpDirFile;
        }

        public long getClockSkew() {
            return 0L;
        }

        public String getPath() {
            return this.path;
        }
    }
}

