/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import javax.swing.JOptionPane;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.support.ui.PasswordDlg;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

final class RemoteUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private static final PasswordManager pm = PasswordManager.getInstance();
    private final ExecutionEnvironment env;

    public RemoteUserInfo(ExecutionEnvironment executionEnvironment) {
        this.env = executionEnvironment;
    }

    public String getPassphrase() {
        return null;
    }

    public String getPassword() {
        char[] cArray = pm.get(this.env);
        return cArray == null ? "" : String.valueOf(cArray);
    }

    public boolean promptPassword(String string) {
        return true;
    }

    public boolean promptPassphrase(String string) {
        return true;
    }

    public boolean promptYesNo(String string) {
        return true;
    }

    public void showMessage(String string) {
    }

    public String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
        if (stringArray.length == 1 && !blArray[0]) {
            return new String[]{new String(pm.get(this.env))};
        }
        return null;
    }

    static final class Interractive
    implements UserInfo,
    UIKeyboardInteractive {
        private static final Object lock = Interractive.class.getName() + "Lock";
        private static final PasswordManager pm = PasswordManager.getInstance();
        private final Component parent;
        private final ExecutionEnvironment env;
        private volatile Component parentWindow = null;

        public Interractive(ExecutionEnvironment executionEnvironment) {
            this.env = executionEnvironment;
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    Interractive.this.parentWindow = WindowManager.getDefault().getMainWindow();
                }
            });
            this.parent = this.parentWindow;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            char[] cArray = pm.get(this.env);
            return cArray == null ? "" : String.valueOf(cArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean promptPassword(String string) {
            Object object = lock;
            synchronized (object) {
                boolean bl;
                PasswordDlg passwordDlg = new PasswordDlg();
                Object object2 = lock;
                synchronized (object2) {
                    bl = passwordDlg.askPassword(this.env);
                }
                if (bl) {
                    object2 = passwordDlg.getPassword();
                    pm.put(this.env, (char[])object2, passwordDlg.isRememberPassword());
                    Arrays.fill((char[])object2, '\u0000');
                    passwordDlg.clearPassword();
                    return true;
                }
                pm.clearPassword(this.env);
                throw new CancellationException(Interractive.loc("USER_AUTH_CANCELED", new String[0]));
            }
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean promptYesNo(String string) {
            int n;
            Object[] objectArray = new Object[]{"yes", "no"};
            Object object = lock;
            synchronized (object) {
                n = JOptionPane.showOptionDialog(this.parent, string, Interractive.loc("TITLE_YN_Warning", new String[0]), -1, 2, null, objectArray, objectArray[0]);
            }
            return n == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showMessage(String string) {
            Object object = lock;
            synchronized (object) {
                JOptionPane.showMessageDialog(this.parent, string);
            }
        }

        public String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            if (stringArray.length == 1 && !blArray[0]) {
                if (!this.promptPassword(Interractive.loc("MSG_PasswordInteractive", string, stringArray[0]))) {
                    return null;
                }
                return new String[]{this.getPassword()};
            }
            return null;
        }

        private static String loc(String string, String ... stringArray) {
            return NbBundle.getMessage(RemoteUserInfo.class, (String)string, (Object[])stringArray);
        }
    }
}

