/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.lang.ref.WeakReference;
import java.security.acl.NotOwnerException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.sps.impl.SPSCommonImpl;
import org.netbeans.modules.nativeexecution.support.Computable;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.ui.GrantPrivilegesDialog;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestPrivilegesTask
implements Computable<RequestPrivilegesTaskParams, Boolean> {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private WeakReference<GrantPrivilegesDialog> dialogRef = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean compute(RequestPrivilegesTaskParams requestPrivilegesTaskParams) throws InterruptedException {
        Boolean bl;
        RequestPrivilegesTaskPerformer requestPrivilegesTaskPerformer = new RequestPrivilegesTaskPerformer(requestPrivilegesTaskParams);
        final Future<Boolean> future = NativeTaskExecutorService.submit(requestPrivilegesTaskPerformer, "RequestPrivilegesTask");
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)RequestPrivilegesTask.loc("TaskPrivilegesSupport_Progress_RequestPrivileges", new String[0]), (Cancellable)new Cancellable(){

            public boolean cancel() {
                return future.cancel(true);
            }
        });
        progressHandle.start();
        try {
            try {
                bl = future.get();
                Object var7_8 = null;
            }
            catch (ExecutionException executionException) {
                log.fine("ExecutionException in RequestPrivilegesTask : " + executionException.toString());
                Object var7_9 = null;
                progressHandle.finish();
                return Boolean.FALSE;
            }
            catch (CancellationException cancellationException) {
                Object var7_10 = null;
                progressHandle.finish();
                return Boolean.FALSE;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            progressHandle.finish();
            throw throwable;
        }
        progressHandle.finish();
        return bl;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(SPSCommonImpl.class, (String)string, (Object[])stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestPrivilegesTaskPerformer
    implements Callable<Boolean> {
        private final RequestPrivilegesTaskParams args;

        public RequestPrivilegesTaskPerformer(RequestPrivilegesTaskParams requestPrivilegesTaskParams) {
            this.args = requestPrivilegesTaskParams;
        }

        @Override
        public Boolean call() throws Exception {
            NativeProcess nativeProcess = null;
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder(this.args.support.getExecEnv());
            nativeProcessBuilder.setExecutable("/bin/pfexec").setArguments("/bin/ppriv", "-s", "I+" + this.args.privilegesString, this.args.support.getPID());
            nativeProcess = nativeProcessBuilder.call();
            int n = nativeProcess.waitFor();
            if (n == 0) {
                return Boolean.TRUE;
            }
            if (!this.args.askForPassword) {
                return Boolean.FALSE;
            }
            if (RequestPrivilegesTask.this.dialogRef == null || RequestPrivilegesTask.this.dialogRef.get() == null) {
                RequestPrivilegesTask.this.dialogRef = new WeakReference<GrantPrivilegesDialog>(new GrantPrivilegesDialog());
            }
            GrantPrivilegesDialog grantPrivilegesDialog = (GrantPrivilegesDialog)RequestPrivilegesTask.this.dialogRef.get();
            while (grantPrivilegesDialog.askPassword()) {
                try {
                    char[] cArray = grantPrivilegesDialog.getPassword();
                    this.args.support.requestPrivileges(this.args.requestedPrivileges, grantPrivilegesDialog.getUser(), cArray);
                    Arrays.fill(cArray, '\u0000');
                    grantPrivilegesDialog.clearPassword();
                    return Boolean.TRUE;
                }
                catch (NotOwnerException notOwnerException) {
                }
            }
            throw new CancellationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestPrivilegesTaskParams {
        final Collection<String> requestedPrivileges;
        final boolean askForPassword;
        private final String privilegesString;
        final SPSCommonImpl support;

        public RequestPrivilegesTaskParams(SPSCommonImpl sPSCommonImpl, Collection<String> collection, boolean bl) {
            this.support = sPSCommonImpl;
            this.requestedPrivileges = collection;
            this.askForPassword = bl;
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : collection) {
                stringBuffer.append(string).append(",");
            }
            this.privilegesString = stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RequestPrivilegesTaskParams)) {
                throw new IllegalArgumentException();
            }
            RequestPrivilegesTaskParams requestPrivilegesTaskParams = (RequestPrivilegesTaskParams)object;
            return requestPrivilegesTaskParams.askForPassword == this.askForPassword && requestPrivilegesTaskParams.support == this.support && requestPrivilegesTaskParams.requestedPrivileges.containsAll(this.requestedPrivileges) && this.requestedPrivileges.containsAll(requestPrivilegesTaskParams.requestedPrivileges);
        }

        public int hashCode() {
            int n = 3;
            n = 79 * n + (this.askForPassword ? 1 : 0);
            n = 79 * n + (this.support != null ? this.support.hashCode() : 0);
            return n;
        }
    }
}

