/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class UnbufferSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final boolean UNBUFFER_DISABLED = Boolean.getBoolean("execution.no_unbuffer");
    private static final HashMap<ExecutionEnvironment, String> cache = new HashMap();

    private UnbufferSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initUnbuffer(ExecutionEnvironment executionEnvironment, MacroMap macroMap) throws IOException {
        if (UNBUFFER_DISABLED) {
            return;
        }
        MacroExpanderFactory.MacroExpander macroExpander = MacroExpanderFactory.getExpander(executionEnvironment);
        HostInfo hostInfo = HostInfoUtils.getHostInfo(executionEnvironment);
        boolean bl = hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS;
        boolean bl2 = hostInfo.getOSFamily() == HostInfo.OSFamily.MACOSX;
        String string = null;
        String string2 = null;
        try {
            string = macroExpander.expandPredefinedMacros("bin/nativeexecution/$osname-$platform");
            string2 = macroExpander.expandPredefinedMacros("unbuffer.$soext");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (string2 != null && string != null) {
            InstalledFileLocator installedFileLocator = InstalledFileLocatorProvider.getDefault();
            File file = installedFileLocator.locate(string + "/" + string2, null, false);
            log.fine("Look for unbuffer library here: " + string + "/" + string2);
            if (file != null && file.exists()) {
                String string3;
                Object object;
                Object object2;
                String string4;
                if (executionEnvironment.isRemote()) {
                    string4 = null;
                    object2 = cache;
                    synchronized (object2) {
                        string4 = cache.get(executionEnvironment);
                        if (string4 == null) {
                            string4 = hostInfo.getTempDir() + "/" + string;
                            object = NativeProcessBuilder.newProcessBuilder(executionEnvironment);
                            ((NativeProcessBuilder)object).setExecutable("/bin/mkdir").setArguments("-p", string4, string4 + "_64");
                            try {
                                ((NativeProcessBuilder)object).call().waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                            try {
                                string3 = string4 + "/" + string2;
                                String string5 = string4 + "_64/" + string2;
                                if (!HostInfoUtils.fileExists(executionEnvironment, string3)) {
                                    String string6 = file.getParentFile().getAbsolutePath();
                                    Future<Integer> future = CommonTasksSupport.uploadFile(string6 + "/" + string2, executionEnvironment, string3, 493, null);
                                    future.get();
                                    future = CommonTasksSupport.uploadFile(string6 + "_64/" + string2, executionEnvironment, string5, 493, null);
                                    future.get();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Exceptions.printStackTrace((Throwable)interruptedException);
                            }
                            catch (ExecutionException executionException) {
                                Exceptions.printStackTrace((Throwable)executionException);
                            }
                            cache.put(executionEnvironment, string4);
                        }
                    }
                    string = string4;
                } else {
                    string = new File(file.getParent()).getAbsolutePath();
                }
                if (bl) {
                    object2 = "PATH";
                    string4 = "LD_PRELOAD";
                } else if (bl2) {
                    object2 = "DYLD_LIBRARY_PATH";
                    string4 = "DYLD_INSERT_LIBRARIES";
                } else {
                    object2 = "LD_LIBRARY_PATH";
                    string4 = "LD_PRELOAD";
                }
                object = macroMap.get(string4);
                if (bl) {
                    object = (object == null ? "" : (String)object + ";") + new File(string, string2).getAbsolutePath();
                    object = WindowsSupport.getInstance().convertToAllShellPaths((String)object);
                    if (object == null) {
                        return;
                    }
                } else {
                    object = bl2 ? (object == null ? "" : (String)object + ":") + string + "/" + string2 : (object == null ? "" : (String)object + ":") + string2;
                }
                macroMap.put(string4, (String)object);
                if (bl2) {
                    macroMap.put("DYLD_FORCE_FLAT_NAMESPACE", "yes");
                } else if (!bl) {
                    string3 = macroMap.get((String)object2);
                    string3 = (string3 == null ? "" : string3 + ":") + string + ":" + string + "_64";
                    macroMap.put((String)object2, string3);
                }
            }
        }
    }
}

