/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.security.SignatureException;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupport;
import org.netbeans.modules.nativeexecution.sps.impl.SPSLocalImpl;
import org.netbeans.modules.nativeexecution.sps.impl.SPSRemoteImpl;
import org.netbeans.modules.nativeexecution.support.Logger;

public final class SolarisPrivilegesSupportProvider {
    private static final ConcurrentHashMap<ExecutionEnvironment, SolarisPrivilegesSupport> instances = new ConcurrentHashMap();

    private SolarisPrivilegesSupportProvider() {
    }

    public static SolarisPrivilegesSupport getSupportFor(ExecutionEnvironment executionEnvironment) {
        SolarisPrivilegesSupport solarisPrivilegesSupport = instances.get(executionEnvironment);
        if (solarisPrivilegesSupport == null) {
            SolarisPrivilegesSupport solarisPrivilegesSupport2;
            if (executionEnvironment.isLocal()) {
                try {
                    solarisPrivilegesSupport = SPSLocalImpl.getNewInstance(executionEnvironment);
                }
                catch (SignatureException signatureException) {
                    Logger.getInstance().severe("Resource signature is wrong: " + signatureException.getMessage());
                }
                catch (MissingResourceException missingResourceException) {
                    Logger.getInstance().severe("Resource not found: " + missingResourceException.getMessage());
                }
            } else {
                solarisPrivilegesSupport = SPSRemoteImpl.getNewInstance(executionEnvironment);
            }
            if (solarisPrivilegesSupport != null && (solarisPrivilegesSupport2 = instances.putIfAbsent(executionEnvironment, solarisPrivilegesSupport)) != null) {
                solarisPrivilegesSupport = solarisPrivilegesSupport2;
            }
        }
        return solarisPrivilegesSupport;
    }
}

