/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Button
extends FormControl {
    public static final HTMLElementPredicate WITH_ID = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object button, Object id) {
            return ((Button)button).getID().equals(id);
        }
    };
    public static final HTMLElementPredicate WITH_LABEL = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object button, Object label) {
            return ((Button)button).getValue().equals(label);
        }
    };
    private String _onClickEvent = "";
    private WebResponse _baseResponse;

    public String getType() {
        return "button";
    }

    Button(WebForm form) {
        super(form);
    }

    Button(WebForm form, Node node) {
        super(form, node);
        this._onClickEvent = NodeUtils.getNodeAttribute(node, "onclick");
    }

    Button(WebResponse response, Node node) {
        super(null, node);
        this._onClickEvent = NodeUtils.getNodeAttribute(node, "onclick");
        this._baseResponse = response;
    }

    public String getValue() {
        return this.getValueAttribute();
    }

    public void click() throws IOException, SAXException {
        this.verifyButtonEnabled();
        if (this.doOnClickEvent()) {
            this.doButtonAction();
        }
    }

    protected void verifyButtonEnabled() {
        if (this.isDisabled()) {
            throw new IllegalStateException("Button" + (this.getName().length() == 0 ? "" : " '" + this.getName() + "'") + " is disabled and may not be clicked.");
        }
    }

    public boolean isDisabled() {
        return super.isDisabled();
    }

    protected final boolean doOnClickEvent() {
        return this._onClickEvent.length() == 0 || this.getScriptableDelegate().doEvent(this._onClickEvent);
    }

    protected void doButtonAction() throws IOException, SAXException {
    }

    String[] getValues() {
        return new String[0];
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
    }

    protected ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    protected ScriptableDelegate getParentDelegate() {
        if (this.getForm() != null) {
            return super.getParentDelegate();
        }
        return this._baseResponse.getScriptableObject().getDocument();
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
            super(Button.this);
        }

        public void click() throws IOException, SAXException {
            Button.this.doButtonAction();
        }
    }
}

