/*
 * Decompiled with CFR 0.152.
 */
package plugins.script;

import freemind.controller.actions.generated.instance.ScriptEditorWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.MindMapHookAdapter;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import plugins.script.ScriptEditorPanel;
import plugins.script.ScriptingEngine;
import plugins.script.ScriptingRegistration;

public class ScriptEditor
extends MindMapHookAdapter {
    public void startupMapHook() {
        super.startupMapHook();
        MindMapNode node = this.getMindMapController().getSelected();
        Vector<AttributeHolder> scripts = new Vector<AttributeHolder>();
        for (int position = 0; position < node.getAttributeTableLength(); ++position) {
            Attribute attribute = node.getAttribute(position);
            if (!attribute.getName().startsWith("script")) continue;
            scripts.add(new AttributeHolder(attribute, position));
        }
        NodeScriptModel nodeScriptModel = new NodeScriptModel(scripts, node, this.getMindMapController());
        ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel(nodeScriptModel, this.getController().getFrame(), true);
        scriptEditorPanel.setVisible(true);
    }

    private final class NodeScriptModel
    implements ScriptEditorPanel.ScriptModel {
        private final Vector mScripts;
        private final MindMapNode mNode;
        private final MindMapController mMindMapController;
        private boolean isDirty = false;

        private NodeScriptModel(Vector pScripts, MindMapNode node, MindMapController pMindMapController) {
            this.mScripts = pScripts;
            this.mNode = node;
            this.mMindMapController = pMindMapController;
        }

        public ScriptEditorWindowConfigurationStorage decorateDialog(ScriptEditorPanel pPanel, String pWindow_preference_storage_property) {
            return (ScriptEditorWindowConfigurationStorage)ScriptEditor.this.getMindMapController().decorateDialog((JDialog)pPanel, pWindow_preference_storage_property);
        }

        public boolean executeScript(int pIndex, PrintStream pOutStream, ScriptingEngine.ErrorHandler pErrorHandler) {
            String script = this.getScript(pIndex).getScript();
            ScriptingRegistration reg = (ScriptingRegistration)ScriptEditor.this.getPluginBaseClass();
            return ScriptingEngine.executeScript(this.mMindMapController.getSelected(), new Tools.BooleanHolder(true), script, this.mMindMapController, pErrorHandler, pOutStream, reg.getScriptCookies());
        }

        public int getAmountOfScripts() {
            return this.mScripts.size();
        }

        public ScriptEditorPanel.ScriptHolder getScript(int pIndex) {
            Attribute attribute = ((AttributeHolder)this.mScripts.get((int)pIndex)).mAttribute;
            return new ScriptEditorPanel.ScriptHolder(attribute.getName(), attribute.getValue());
        }

        public void setScript(int pIndex, ScriptEditorPanel.ScriptHolder pScript) {
            AttributeHolder oldHolder = (AttributeHolder)this.mScripts.get(pIndex);
            if (!pScript.mScriptName.equals(oldHolder.mAttribute.getName())) {
                this.isDirty = true;
            }
            if (!pScript.mScript.equals(oldHolder.mAttribute.getValue())) {
                this.isDirty = true;
            }
            oldHolder.mAttribute.setName(pScript.mScriptName);
            oldHolder.mAttribute.setValue(pScript.mScript);
        }

        public void storeDialogPositions(ScriptEditorPanel pPanel, ScriptEditorWindowConfigurationStorage pStorage, String pWindow_preference_storage_property) {
            ScriptEditor.this.getMindMapController().storeDialogPositions((JDialog)pPanel, (WindowConfigurationStorage)pStorage, pWindow_preference_storage_property);
        }

        public void endDialog(boolean pIsCanceled) {
            if (!pIsCanceled) {
                int attributeTableLength = this.mNode.getAttributeTableLength();
                Iterator iter = this.mScripts.iterator();
                while (iter.hasNext()) {
                    AttributeHolder holder = (AttributeHolder)iter.next();
                    Attribute attribute = holder.mAttribute;
                    int position = holder.mPosition;
                    if (attributeTableLength <= position) {
                        this.mMindMapController.addAttribute(this.mNode, attribute);
                        continue;
                    }
                    if (this.mNode.getAttribute(position).getValue() == attribute.getValue()) continue;
                    this.mMindMapController.setAttribute(this.mNode, position, attribute);
                }
            }
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public int addNewScript() {
            boolean found;
            int index = this.mScripts.size();
            int attributeIndex = this.mNode.getAttributeTableLength();
            String scriptName = "script";
            int scriptNameSuffix = 1;
            block0: do {
                found = false;
                Iterator iterator = this.mScripts.iterator();
                while (iterator.hasNext()) {
                    AttributeHolder holder = (AttributeHolder)iterator.next();
                    if (!(scriptName + scriptNameSuffix).equals(holder.mAttribute.getName())) continue;
                    found = true;
                    ++scriptNameSuffix;
                    continue block0;
                }
            } while (found);
            this.mScripts.add(new AttributeHolder(new Attribute(scriptName + scriptNameSuffix, ""), attributeIndex));
            this.isDirty = true;
            return index;
        }
    }

    private final class AttributeHolder {
        Attribute mAttribute;
        int mPosition;

        public AttributeHolder(Attribute pAttribute, int pPosition) {
            this.mAttribute = pAttribute;
            this.mPosition = pPosition;
        }
    }
}

