/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.Util;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;

class CombinedAttribute {
    public static final int ATTR_TOP = 0;
    public static final int ATTR_RIGHT = 1;
    public static final int ATTR_BOTTOM = 2;
    public static final int ATTR_LEFT = 3;
    private String[] values = new String[4];
    private Object attributeKey;
    private boolean[] present = new boolean[4];
    private Vector aNames = new Vector();
    private boolean includeParents;

    public CombinedAttribute(Object key, AttributeSet a, boolean includeParents) {
        this.attributeKey = key;
        this.includeParents = includeParents;
        Enumeration<?> names = a.getAttributeNames();
        while (names.hasMoreElements()) {
            this.aNames.addElement(names.nextElement());
        }
        Object attr = a.getAttribute(key);
        if (attr != null) {
            this.copyValues(Util.tokenize(attr.toString(), " "));
        } else {
            this.copyValues(key, a);
        }
    }

    private void copyValues(Object key, AttributeSet a) {
        if (key.equals(CSS.Attribute.BORDER_WIDTH)) {
            this.setValue(0, CSS.Attribute.BORDER_TOP_WIDTH, a);
            this.setValue(1, CSS.Attribute.BORDER_RIGHT_WIDTH, a);
            this.setValue(2, CSS.Attribute.BORDER_BOTTOM_WIDTH, a);
            this.setValue(3, CSS.Attribute.BORDER_LEFT_WIDTH, a);
        } else if (key.equals(CSS.Attribute.PADDING)) {
            this.setValue(0, CSS.Attribute.PADDING_TOP, a);
            this.setValue(1, CSS.Attribute.PADDING_RIGHT, a);
            this.setValue(2, CSS.Attribute.PADDING_BOTTOM, a);
            this.setValue(3, CSS.Attribute.PADDING_LEFT, a);
        } else if (key.equals(CSS.Attribute.MARGIN)) {
            this.setValue(0, CSS.Attribute.MARGIN_TOP, a);
            this.setValue(1, CSS.Attribute.MARGIN_RIGHT, a);
            this.setValue(2, CSS.Attribute.MARGIN_BOTTOM, a);
            this.setValue(3, CSS.Attribute.MARGIN_LEFT, a);
        }
    }

    private void setValue(int side, Object key, AttributeSet a) {
        if (this.includeParents || !this.includeParents && this.aNames.contains(key)) {
            Object attr = a.getAttribute(key);
            if (attr != null) {
                this.values[side] = attr.toString();
                this.present[side] = true;
            } else {
                this.values[side] = this.defaultValue(this.attributeKey);
                this.present[side] = true;
            }
        } else {
            this.values[side] = this.defaultValue(this.attributeKey);
            this.present[side] = false;
        }
    }

    public boolean isEmpty() {
        boolean notEmpty = false;
        for (int i = 0; !notEmpty && i < this.present.length; ++i) {
            notEmpty = this.present[i];
        }
        return !notEmpty;
    }

    private String defaultValue(Object key) {
        String value = "0";
        if (key.equals(CSS.Attribute.BORDER_COLOR)) {
            value = "#000000";
        }
        return value;
    }

    public int getOppositeSide(int side) {
        int oppositeSide = -1;
        switch (side) {
            case 0: {
                oppositeSide = 2;
                break;
            }
            case 1: {
                oppositeSide = 3;
                break;
            }
            case 2: {
                oppositeSide = 0;
                break;
            }
            case 3: {
                oppositeSide = 1;
            }
        }
        return oppositeSide;
    }

    private void copyValues(String[] v) {
        switch (v.length) {
            case 1: {
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = v[0];
                }
                break;
            }
            case 2: {
                this.values[0] = v[0];
                this.values[1] = v[1];
                this.values[2] = v[0];
                this.values[3] = v[1];
                break;
            }
            case 3: {
                this.values[0] = v[0];
                this.values[1] = v[1];
                this.values[2] = v[2];
                this.values[3] = v[1];
                break;
            }
            case 4: {
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = v[i];
                }
                break;
            }
        }
    }

    public void setAttribute(int side, String value) {
        this.values[side] = value;
    }

    public String getAttribute(int side) {
        return this.values[side];
    }

    public Object getAttributeKey() {
        return this.attributeKey;
    }

    public String getAttribute() {
        String result = null;
        StringBuffer buf = new StringBuffer();
        if (this.values[0] != null) {
            buf.append(this.values[0]);
            int additionalValueCount = 3;
            if (this.values[1].equalsIgnoreCase(this.values[3])) {
                --additionalValueCount;
                if (this.values[0].equalsIgnoreCase(this.values[2])) {
                    --additionalValueCount;
                    if (this.values[0].equalsIgnoreCase(this.values[1])) {
                        --additionalValueCount;
                    }
                }
            }
            this.appendValues(buf, additionalValueCount);
            result = buf.toString();
        }
        return result;
    }

    private void appendValues(StringBuffer buf, int count) {
        for (int i = 1; i < count + 1; ++i) {
            buf.append(' ');
            buf.append(this.values[i]);
        }
    }
}

