/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.dialogs;

import freemind.modes.ModeController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

public class PersistentEditableComboBox
extends JComboBox {
    private ActionListener actionListener = null;
    private boolean sendExternalEvents = true;
    private final ModeController mModeController;
    private final String pStorageKey;

    public PersistentEditableComboBox(ModeController modeController, String storageKey) {
        this.mModeController = modeController;
        this.pStorageKey = storageKey;
        this.setEditable(true);
        this.addUrl("", false);
        String storedUrls = this.mModeController.getFrame().getProperty(this.pStorageKey);
        if (storedUrls != null) {
            String[] array = storedUrls.split("\t");
            for (int i = 0; i < array.length; ++i) {
                String string = array[i];
                this.addUrl(string, false);
            }
        }
        this.setSelectedIndex(0);
        super.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PersistentEditableComboBox.this.addUrl(PersistentEditableComboBox.this.getText(), false);
                if (PersistentEditableComboBox.this.sendExternalEvents && PersistentEditableComboBox.this.actionListener != null) {
                    PersistentEditableComboBox.this.actionListener.actionPerformed(arg0);
                }
            }
        });
    }

    public void addActionListener(ActionListener arg0) {
        this.actionListener = arg0;
    }

    private boolean addUrl(String selectedItem, boolean calledFromSetText) {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            String element = (String)this.getModel().getElementAt(i);
            if (!element.equals(selectedItem)) continue;
            if (calledFromSetText) {
                this.setSelectedIndex(i);
            }
            return false;
        }
        this.addItem(selectedItem);
        this.setSelectedIndex(this.getModel().getSize() - 1);
        if (calledFromSetText) {
            StringBuffer resultBuffer = new StringBuffer();
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                String element = (String)this.getModel().getElementAt(i);
                resultBuffer.append(element);
                resultBuffer.append("\t");
            }
            this.mModeController.getFrame().setProperty(this.pStorageKey, resultBuffer.toString());
        }
        return true;
    }

    public String getText() {
        return this.getSelectedItem().toString();
    }

    public void setText(String text) {
        this.sendExternalEvents = false;
        this.addUrl(text, true);
        this.sendExternalEvents = true;
    }
}

