/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.tray;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JWindow;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.ListenerSupport;
import org.limewire.ui.swing.animate.AnimatorEvent;
import org.limewire.ui.swing.animate.FadeInOutAnimator;
import org.limewire.ui.swing.animate.MoveAnimator;
import org.limewire.ui.swing.tray.Notification;
import org.limewire.ui.swing.tray.WindowDisposedEvent;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.SystemUtils;

class NotificationWindow
extends JWindow
implements ListenerSupport<WindowDisposedEvent> {
    private final Notification notification;
    private final EventListenerList<WindowDisposedEvent> eventListenerList = new EventListenerList();
    @Resource
    private Icon trayNotifyClose;
    @Resource
    private Icon trayNotifyCloseRollover;
    @Resource
    private Font titleFont;
    @Resource
    private Color titleFontColor;
    @Resource
    private Font bodyFont;
    @Resource
    private Color bodyFontColor;
    @Resource
    private Font linkFont;
    @Resource
    private Color linkFontColor;
    @Resource
    private Color backgroundColor;
    @Resource
    private Color borderColour;
    private MoveAnimator currentMoveAnimator;

    public NotificationWindow(Icon icon, Notification notification) {
        GuiUtils.assignResources(this);
        this.notification = notification;
        this.setAlwaysOnTop(true);
        SystemUtils.setWindowTopMost(this);
        FadeInOutAnimator fadeInOutAnimator = new FadeInOutAnimator(this, 500, 2500, 500);
        fadeInOutAnimator.addListener(new EventListener<AnimatorEvent<JWindow>>(){

            @Override
            public void handleEvent(AnimatorEvent event) {
                if (event.getType() == AnimatorEvent.Type.STOPPED) {
                    NotificationWindow.this.eventListenerList.broadcast(new WindowDisposedEvent(NotificationWindow.this));
                }
            }
        });
        JXPanel panel = new JXPanel(new MigLayout("fill, gap 0px 0px, insets 0 5 5 0"));
        this.add(panel);
        panel.setBackground(this.backgroundColor);
        panel.setBorder(BorderFactory.createLineBorder(this.borderColour, 2));
        PerformNotificationActionsMouseListener performNotificationActionsMouseListener = new PerformNotificationActionsMouseListener();
        panel.addMouseListener(performNotificationActionsMouseListener);
        JRadioButton closeButton = new JRadioButton(this.trayNotifyClose);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationWindow.this.eventListenerList.broadcast(new WindowDisposedEvent(NotificationWindow.this));
            }
        });
        closeButton.addMouseListener(new HoverButtonMouseListener(closeButton, this.trayNotifyClose, this.trayNotifyCloseRollover));
        String titleLine1 = " ";
        String titleLine2 = "";
        if (notification.getTitle() != null) {
            StringTokenizer title = new StringTokenizer(notification.getTitle(), " \t\n\r");
            StringBuffer titleBuffer1 = new StringBuffer();
            StringBuffer remainingMessage = this.buildLine(titleBuffer1, title, this.titleFont, 150);
            titleLine1 = titleBuffer1.toString().trim();
            titleLine2 = FontUtils.getTruncatedMessage(remainingMessage.toString().trim(), this.titleFont, 180);
        }
        JLabel titleLabel1 = new JLabel(titleLine1);
        titleLabel1.setIcon(icon);
        titleLabel1.setIconTextGap(3);
        titleLabel1.setFont(this.titleFont);
        titleLabel1.setForeground(this.titleFontColor);
        JLabel titleLabel2 = new JLabel(titleLine2);
        titleLabel2.setFont(this.titleFont);
        titleLabel2.setForeground(this.titleFontColor);
        titleLabel1.addMouseListener(performNotificationActionsMouseListener);
        titleLabel2.addMouseMotionListener(performNotificationActionsMouseListener);
        StringTokenizer message = new StringTokenizer(notification.getMessage(), " \t\n\r");
        StringBuffer messageBuffer1 = new StringBuffer();
        StringBuffer remainingMessage = this.buildLine(messageBuffer1, message, this.bodyFont, 180);
        String messageLine1 = messageBuffer1.toString().trim();
        String messageLine2 = FontUtils.getTruncatedMessage(remainingMessage.toString().trim(), this.bodyFont, 180);
        JLabel messageLabel1 = new JLabel(messageLine1);
        messageLabel1.setFont(this.bodyFont);
        messageLabel1.setForeground(this.bodyFontColor);
        JLabel messageLabel2 = new JLabel(messageLine2);
        messageLabel2.setFont(this.bodyFont);
        messageLabel2.setForeground(this.bodyFontColor);
        messageLabel1.addMouseListener(performNotificationActionsMouseListener);
        messageLabel2.addMouseListener(performNotificationActionsMouseListener);
        panel.add((Component)titleLabel1, "aligny top, gaptop 5");
        panel.add((Component)closeButton, "alignx right, aligny top, wrap");
        if (!StringUtils.isEmpty(titleLine2)) {
            panel.add((Component)titleLabel2, "spanx 2, wrap");
        }
        panel.add((Component)messageLabel1, "spanx 2, wrap, gaptop 6");
        if (!StringUtils.isEmpty(messageLine2)) {
            panel.add((Component)messageLabel2, "spanx 2, wrap");
        }
        if (notification.getActions() != null && notification.getActions().length > 0) {
            String launchLinkHtml = "<html><u>" + notification.getActionName() + "</u></html>";
            JLabel launchLink = new JLabel(launchLinkHtml);
            launchLink.setCursor(Cursor.getPredefinedCursor(12));
            launchLink.setFont(this.linkFont);
            launchLink.setForeground(this.linkFontColor);
            launchLink.addMouseListener(performNotificationActionsMouseListener);
            panel.add((Component)launchLink, "spanx 2, alignx right, aligny bottom, gaptop 6,  gapright 5");
        }
        this.setPreferredSize(new Dimension(204, 97));
        this.pack();
        fadeInOutAnimator.start();
    }

    private void performActions() {
        if (this.notification.getActions() != null) {
            for (Action action : this.notification.getActions()) {
                action.actionPerformed(new ActionEvent(this, 1001, "Message Clicked"));
            }
        }
    }

    public Notification getNotification() {
        return this.notification;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SystemUtils.setWindowTopMost(this);
    }

    @Override
    public void addListener(EventListener<WindowDisposedEvent> listener) {
        this.eventListenerList.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<WindowDisposedEvent> listener) {
        return this.eventListenerList.removeListener(listener);
    }

    private StringBuffer buildLine(StringBuffer line, StringTokenizer message, Font font, int pixelWidth) {
        String currentToken;
        StringBuffer remaining = new StringBuffer();
        while (message.hasMoreTokens()) {
            currentToken = message.nextToken();
            int pixels = FontUtils.getPixelWidth(line + currentToken, font);
            if (pixels < pixelWidth) {
                line.append(currentToken);
                if (!message.hasMoreTokens()) continue;
                line.append(" ");
                continue;
            }
            remaining.append(currentToken);
            if (!message.hasMoreTokens()) break;
            remaining.append(" ");
            break;
        }
        while (message.hasMoreTokens()) {
            currentToken = message.nextToken();
            remaining.append(currentToken);
            if (!message.hasMoreTokens()) continue;
            remaining.append(" ");
        }
        return remaining;
    }

    public synchronized void moveTo(Point newLocation) {
        if (this.currentMoveAnimator != null) {
            this.currentMoveAnimator.stop();
        }
        MoveAnimator moveAnimator = new MoveAnimator(this, 250, newLocation);
        moveAnimator.start();
        this.currentMoveAnimator = moveAnimator;
    }

    private static final class HoverButtonMouseListener
    extends MouseAdapter {
        private final JRadioButton closeButton;
        private final Icon trayNotifyClose;
        private final Icon trayNotifyCloseRollover;

        private HoverButtonMouseListener(JRadioButton closeButton, Icon trayNotifyClose, Icon trayNotifyCloseRollover) {
            this.closeButton = closeButton;
            this.trayNotifyClose = trayNotifyClose;
            this.trayNotifyCloseRollover = trayNotifyCloseRollover;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.closeButton.setIcon(this.trayNotifyCloseRollover);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.closeButton.setIcon(this.trayNotifyClose);
        }
    }

    private class PerformNotificationActionsMouseListener
    extends MouseAdapter {
        private PerformNotificationActionsMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            NotificationWindow.this.performActions();
        }
    }
}

