/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.statusbar;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.connection.ConnectionStrength;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class ConnectionStatusPanel
extends JXPanel {
    private final String connectingText = I18n.tr("Connecting");
    private final GnutellaConnectionManager gnutellaConnectionManager;
    private ConnectionStrength currentStrength;
    private Timer animateTimer = null;
    private JButton tryAgainButton = null;
    private final JLabel connectionStrengthLabel;
    private final JLabel connectionStatusLabel;
    @Resource
    private Icon noInternet;
    @Resource
    private Icon disconnected;
    @Resource
    private Icon connecting;
    @Resource
    private Icon weak;
    @Resource
    private Icon weakPlus;
    @Resource
    private Icon medium;
    @Resource
    private Icon mediumPlus;
    @Resource
    private Icon full;
    @Resource
    private Icon turbo;
    @Resource
    private Font font;

    @Inject
    ConnectionStatusPanel(GnutellaConnectionManager gnutellaConnectionManager) {
        this.gnutellaConnectionManager = gnutellaConnectionManager;
        GuiUtils.assignResources(this);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.connectionStrengthLabel = new JLabel();
        this.connectionStrengthLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 4));
        this.connectionStatusLabel = new JLabel();
        this.connectionStatusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.connectionStatusLabel.setFont(this.font);
        this.connectionStatusLabel.setForeground(this.getForeground());
        this.add((Component)this.connectionStrengthLabel, "West");
        this.add((Component)this.connectionStatusLabel, "Center");
        gnutellaConnectionManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("strength")) {
                    ConnectionStatusPanel.this.setConnectionStrength((ConnectionStrength)((Object)evt.getNewValue()));
                }
            }
        });
        this.setConnectionStrength(ConnectionStrength.CONNECTING);
    }

    private void setConnectionStrength(ConnectionStrength strength) {
        this.currentStrength = strength;
        String statusMessage = "";
        String tooltipText = "";
        boolean shouldHideStatusLater = false;
        boolean showTryAgain = false;
        Icon strengthIcon = null;
        switch (strength) {
            case NO_INTERNET: {
                statusMessage = I18n.tr("No internet connection");
                tooltipText = I18n.tr("You have no internet connection");
                strengthIcon = this.noInternet;
                break;
            }
            case DISCONNECTED: {
                tooltipText = I18n.tr("Couldn't connect");
                statusMessage = I18n.tr("You couldn't connect to LimeWire");
                strengthIcon = this.disconnected;
                showTryAgain = true;
                break;
            }
            case CONNECTING: {
                statusMessage = this.connectingText;
                tooltipText = I18n.tr("Connecting...");
                this.animateConnecting();
                strengthIcon = this.connecting;
                break;
            }
            case WEAK: {
                statusMessage = I18n.tr("Weak connection");
                tooltipText = I18n.tr("You have a weak connection");
                strengthIcon = this.weak;
                break;
            }
            case WEAK_PLUS: {
                statusMessage = I18n.tr("Weak connection");
                tooltipText = I18n.tr("You have a weak connection");
                strengthIcon = this.weakPlus;
                break;
            }
            case MEDIUM: {
                statusMessage = I18n.tr("Medium connection");
                tooltipText = I18n.tr("You have a medium connection");
                strengthIcon = this.medium;
                break;
            }
            case MEDIUM_PLUS: {
                statusMessage = I18n.tr("Medium connection");
                tooltipText = I18n.tr("You have a medium connection");
                strengthIcon = this.mediumPlus;
                break;
            }
            case FULL: {
                shouldHideStatusLater = true;
                statusMessage = I18n.tr("Full connection");
                tooltipText = I18n.tr("You are fully connected");
                strengthIcon = this.full;
                break;
            }
            case TURBO: {
                shouldHideStatusLater = true;
                statusMessage = I18n.tr("Turbo-charged connection");
                tooltipText = I18n.tr("You have a turbo-charged connection");
                strengthIcon = this.turbo;
            }
        }
        if (shouldHideStatusLater) {
            this.hideStatusLater();
        }
        this.connectionStatusLabel.setVisible(true);
        this.connectionStatusLabel.setText(statusMessage);
        this.connectionStrengthLabel.setIcon(strengthIcon);
        if (this.tryAgainButton == null) {
            if (showTryAgain) {
                this.tryAgainButton = new HyperlinkButton(I18n.tr("Try Again"));
                this.tryAgainButton.setFont(this.font);
                this.tryAgainButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ConnectionStatusPanel.this.gnutellaConnectionManager.restart();
                    }
                });
                this.add((Component)this.tryAgainButton, "East");
            }
        } else {
            this.tryAgainButton.setVisible(showTryAgain);
        }
        this.setToolTipText(tooltipText);
    }

    @Override
    public void setToolTipText(String totalText) {
        super.setToolTipText(totalText);
        this.connectionStatusLabel.setToolTipText(totalText);
        this.connectionStrengthLabel.setToolTipText(totalText);
    }

    private void hideStatusLater() {
        final ConnectionStrength initialStength = this.currentStrength;
        Timer hideSheduler = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (initialStength == ConnectionStatusPanel.this.currentStrength) {
                    ConnectionStatusPanel.this.connectionStatusLabel.setVisible(false);
                }
            }
        });
        hideSheduler.setRepeats(false);
        hideSheduler.start();
    }

    private void animateConnecting() {
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animateTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ConnectionStatusPanel.this.currentStrength != ConnectionStrength.CONNECTING) {
                    ConnectionStatusPanel.this.animateTimer.stop();
                    ConnectionStatusPanel.this.animateTimer = null;
                    return;
                }
                int numDots = (ConnectionStatusPanel.this.connectionStatusLabel.getText().trim().length() - ConnectionStatusPanel.this.connectingText.length() + 1) % 4;
                StringBuffer message = new StringBuffer(ConnectionStatusPanel.this.connectingText);
                for (int i = 0; i < 4; ++i) {
                    if (i < numDots) {
                        message.append('.');
                        continue;
                    }
                    message.append(' ');
                }
                ConnectionStatusPanel.this.connectionStatusLabel.setText(message.toString());
            }
        });
        this.animateTimer.start();
    }
}

