/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.shell;

import org.limewire.ui.swing.shell.ShellAssociation;
import org.limewire.ui.swing.util.MacOSXUtils;

class OSXFileTypeAssociation
implements ShellAssociation {
    private final String extension;

    protected OSXFileTypeAssociation(String extension) {
        this.extension = extension;
    }

    public static boolean isNativeLibraryLoadedCorrectly() {
        return MacOSXUtils.isNativeLibraryLoadedCorrectly();
    }

    @Override
    public boolean isAvailable() {
        return !MacOSXUtils.isFileTypeHandled(this.extension);
    }

    @Override
    public boolean isRegistered() {
        return MacOSXUtils.isLimewireDefaultFileTypeHandler(this.extension);
    }

    @Override
    public void register() {
        MacOSXUtils.setLimewireAsDefaultFileTypeHandler(this.extension);
    }

    @Override
    public boolean canUnregister() {
        return MacOSXUtils.canChangeDefaultFileTypeHandler(this.extension);
    }

    @Override
    public void unregister() {
        MacOSXUtils.tryChangingDefaultFileTypeHandler(this.extension);
    }
}

