/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.LibrarySelected;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class RemoveFromListAction
extends AbstractAction {
    private final Provider<LocalFileList> selectedLocalFileList;
    private final Provider<List<LocalFileItem>> selectedLocalFileItems;

    @Inject
    public RemoveFromListAction(@LibrarySelected Provider<LocalFileList> selectedLocalFileList, @LibrarySelected Provider<List<LocalFileItem>> selectedLocalFileItems) {
        super(I18n.tr("Remove from List"));
        this.selectedLocalFileList = selectedLocalFileList;
        this.selectedLocalFileItems = selectedLocalFileItems;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ArrayList items = new ArrayList(this.selectedLocalFileItems.get());
        final LocalFileList localFileList = this.selectedLocalFileList.get();
        BackgroundExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                for (LocalFileItem item : items) {
                    localFileList.removeFile(item.getFile());
                }
            }
        });
    }
}

