/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.io.Address;
import org.limewire.io.NetworkUtils;
import org.limewire.io.SimpleNetworkInstanceUtils;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ConnectivityChangeEvent;
import org.limewire.net.EmptyProxySettings;
import org.limewire.net.EmptySocketBindingSettings;
import org.limewire.net.ProxyManagerImpl;
import org.limewire.net.SimpleSocketController;
import org.limewire.net.SocketController;
import org.limewire.net.SocketsManager;
import org.limewire.net.address.AddressConnector;
import org.limewire.net.address.AddressResolutionObserver;
import org.limewire.net.address.AddressResolver;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NBSocketFactory;
import org.limewire.nio.observer.ConnectObserver;

@Singleton
public class SocketsManagerImpl
implements SocketsManager,
EventBroadcaster<ConnectivityChangeEvent>,
ListenerSupport<ConnectivityChangeEvent> {
    private static final Log LOG = LogFactory.getLog(SocketsManagerImpl.class, "address-connecting");
    private final SocketController socketController;
    private final List<AddressResolver> addressResolvers = new CopyOnWriteArrayList<AddressResolver>();
    private final List<AddressConnector> addressConnectors = new CopyOnWriteArrayList<AddressConnector>();
    private final EventMulticaster<ConnectivityChangeEvent> connectivityEventMulticaster = new EventMulticasterImpl<ConnectivityChangeEvent>();

    public SocketsManagerImpl() {
        this(new SimpleSocketController(new ProxyManagerImpl(new EmptyProxySettings(), new SimpleNetworkInstanceUtils()), new EmptySocketBindingSettings()));
    }

    @Inject
    public SocketsManagerImpl(SocketController socketController) {
        this.socketController = socketController;
    }

    @Override
    public Socket create(SocketsManager.ConnectType type) throws IOException {
        return type.getFactory().createSocket();
    }

    @Override
    public Socket connect(NBSocket socket, InetSocketAddress localAddr, InetSocketAddress addr, int timeout, SocketsManager.ConnectType type) throws IOException {
        return this.connect(socket, localAddr, addr, timeout, null, type);
    }

    @Override
    public Socket connect(InetSocketAddress addr, int timeout) throws IOException {
        return this.connect(addr, timeout, SocketsManager.ConnectType.PLAIN);
    }

    @Override
    public Socket connect(InetSocketAddress addr, int timeout, SocketsManager.ConnectType type) throws IOException {
        return this.connect(addr, timeout, null, type);
    }

    @Override
    public Socket connect(InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        return this.connect(addr, timeout, observer, SocketsManager.ConnectType.PLAIN);
    }

    @Override
    public Socket connect(InetSocketAddress addr, int timeout, ConnectObserver observer, SocketsManager.ConnectType type) throws IOException {
        return this.connect(null, null, addr, timeout, observer, type);
    }

    @Override
    public Socket connect(final NBSocket socket, InetSocketAddress localAddr, InetSocketAddress addr, int timeout, ConnectObserver observer, SocketsManager.ConnectType type) throws IOException {
        if (!NetworkUtils.isValidPort(addr.getPort())) {
            throw new IllegalArgumentException("port out of range: " + addr.getPort());
        }
        if (addr.isUnresolved()) {
            throw new IOException("address must be resolved!");
        }
        if (socket == null) {
            return this.socketController.connect(type.getFactory(), addr, null, timeout, observer);
        }
        NBSocketFactory factory = new NBSocketFactory(){

            @Override
            public NBSocket createSocket() throws IOException {
                return socket;
            }

            @Override
            public NBSocket createSocket(String host, int port) throws IOException, UnknownHostException {
                throw new UnsupportedOperationException();
            }

            @Override
            public NBSocket createSocket(InetAddress host, int port) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public NBSocket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                throw new UnsupportedOperationException();
            }

            @Override
            public NBSocket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
        return this.socketController.connect(factory, addr, localAddr, timeout, observer);
    }

    @Override
    public boolean removeConnectObserver(ConnectObserver observer) {
        return this.socketController.removeConnectObserver(observer);
    }

    @Override
    public int getNumAllowedSockets() {
        return this.socketController.getNumAllowedSockets();
    }

    @Override
    public int getNumWaitingSockets() {
        return this.socketController.getNumWaitingSockets();
    }

    private AddressResolver getResolver(Address address) {
        for (AddressResolver resolver : this.addressResolvers) {
            if (!resolver.canResolve(address)) continue;
            LOG.debugf("found resolver: {0} for: {1}", (Object)resolver, (Object)address);
            return resolver;
        }
        return null;
    }

    private AddressConnector getConnector(Address address) {
        for (AddressConnector connector : this.addressConnectors) {
            if (!connector.canConnect(address)) continue;
            LOG.debugf("found connector: {0} for: {1}", (Object)connector, (Object)address);
            return connector;
        }
        return null;
    }

    @Override
    public boolean canConnect(Address address) {
        return this.getConnector(address) != null;
    }

    @Override
    public boolean canResolve(Address address) {
        return this.getResolver(address) != null;
    }

    @Override
    public <T extends ConnectObserver> T connect(Address address, final T observer) {
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
        if (this.canResolve(address)) {
            LOG.debugf("trying to resolve for connect: {0}", (Object)address);
            this.resolve(address, new AddressResolutionObserver(){

                @Override
                public void resolved(Address address) {
                    SocketsManagerImpl.this.connectUnresolved(address, observer);
                }

                @Override
                public void handleIOException(IOException iox) {
                    observer.handleIOException(iox);
                }

                @Override
                public void shutdown() {
                }
            });
        } else {
            LOG.debugf("trying to connect unresolved: {0}", (Object)address);
            this.connectUnresolved(address, observer);
        }
        return observer;
    }

    private void connectUnresolved(Address address, ConnectObserver observer) {
        AddressConnector connector = this.getConnector(address);
        if (connector != null) {
            connector.connect(address, observer);
        } else {
            observer.handleIOException(new ConnectException("no connector ready to connect to: " + address));
            observer.shutdown();
        }
    }

    @Override
    public <T extends AddressResolutionObserver> T resolve(final Address address, final T observer) {
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
        AddressResolver resolver = this.getResolver(address);
        if (resolver != null) {
            resolver.resolve(address, new AddressResolutionObserver(){

                @Override
                public void resolved(Address resolvedAddress) {
                    LOG.debugf("resolved {0} to {1}", (Object)address, (Object)resolvedAddress);
                    if (SocketsManagerImpl.this.canResolve(resolvedAddress)) {
                        SocketsManagerImpl.this.resolve(resolvedAddress, this);
                    } else {
                        observer.resolved(resolvedAddress);
                    }
                }

                @Override
                public void handleIOException(IOException iox) {
                    observer.handleIOException(iox);
                }

                @Override
                public void shutdown() {
                    observer.shutdown();
                }
            });
        } else {
            LOG.debugf("not resolver found for: {0}", (Object)address);
            observer.handleIOException(new IOException(address + " cannot be resolved"));
        }
        return observer;
    }

    @Override
    public void registerConnector(AddressConnector connector) {
        this.addressConnectors.add(connector);
    }

    @Override
    public void registerResolver(AddressResolver resolver) {
        this.addressResolvers.add(resolver);
    }

    @Override
    public void addListener(EventListener<ConnectivityChangeEvent> listener) {
        this.connectivityEventMulticaster.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<ConnectivityChangeEvent> listener) {
        return this.connectivityEventMulticaster.removeListener(listener);
    }

    @Override
    public void broadcast(ConnectivityChangeEvent event) {
        this.connectivityEventMulticaster.broadcast(event);
    }
}

