/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.statistics;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.limewire.mojito.KUID;
import org.limewire.mojito.statistics.SimpleStatistic;
import org.limewire.mojito.statistics.SingleLookupStatisticContainer;
import org.limewire.mojito.statistics.StatisticContainer;
import org.limewire.statistic.Statistic;

public class GlobalLookupStatisticContainer
extends StatisticContainer {
    private static final int MAX_LOOKUPS = 20;
    private List<StatisticContainer> singleLookups = new ArrayList<StatisticContainer>();
    public Statistic GLOBAL_LOOKUPS = new SimpleStatistic();
    public Statistic GLOBAL_LOOKUP_REQUESTS = new SimpleStatistic();
    public Statistic GLOBAL_LOOKUP_REPLIES = new SimpleStatistic();
    public Statistic GLOBAL_LOOKUP_TIMEOUTS = new SimpleStatistic();
    public Statistic GLOBAL_LOOKUP_HOPS = new SimpleStatistic();
    public Statistic GLOBAL_LOOKUP_TIME = new SimpleStatistic();
    public Statistic GLOBAL_FIND_VALUE_LOOKUP_TIME = new SimpleStatistic();
    public Statistic GLOBAL_FIND_VALUE_LOOKUP_HOPS = new SimpleStatistic();

    public GlobalLookupStatisticContainer(KUID nodeId) {
        super(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingleLookupStatistic(SingleLookupStatisticContainer lookupStat) {
        List<StatisticContainer> list = this.singleLookups;
        synchronized (list) {
            this.GLOBAL_LOOKUPS.incrementStat();
            this.singleLookups.add(lookupStat);
            if (this.singleLookups.size() > 20) {
                this.singleLookups.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStats(Writer writer) throws IOException {
        writer.write("Global lookups: \n");
        super.writeStats(writer);
        List<StatisticContainer> list = this.singleLookups;
        synchronized (list) {
            for (StatisticContainer stat : this.singleLookups) {
                stat.writeStats(writer);
            }
        }
    }

    public void writeGlobalStats(Writer writer) throws IOException {
        writer.write("Global lookups: \n");
        super.writeStats(writer);
    }
}

