/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueFactory;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.db.impl.DefaultDHTValueFactory;
import org.limewire.mojito.exceptions.DHTValueException;
import org.limewire.mojito.routing.Version;

public class DHTValueFactoryManager {
    public static final DHTValueFactory defaultFactory = new DefaultDHTValueFactory();
    private final Map<DHTValueType, DHTValueFactory> factories = Collections.synchronizedMap(new HashMap());

    public DHTValueFactory addValueFactory(DHTValueType valueType, DHTValueFactory factory) {
        if (valueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        if (factory == null) {
            throw new NullPointerException("DHTValueFactory is null");
        }
        return this.factories.put(valueType, factory);
    }

    public DHTValueFactory removeValueFactory(DHTValueType valueType) {
        if (valueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return this.factories.remove(valueType);
    }

    public DHTValueFactory getValueFactory(DHTValueType valueType) {
        if (valueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        DHTValueFactory factory = this.factories.get(valueType);
        if (factory != null) {
            return factory;
        }
        return defaultFactory;
    }

    public DHTValue createDHTValue(DHTValueType valueType, Version version, byte[] value) throws DHTValueException {
        if (valueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        if (version == null) {
            throw new NullPointerException("Version is null");
        }
        if (value == null || value.length == 0) {
            return defaultFactory.createDHTValue(valueType, version, value);
        }
        return this.getValueFactory(valueType).createDHTValue(valueType, version, value);
    }
}

