/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;
import org.limewire.http.reactor.HttpChannel;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.Throttle;
import org.limewire.nio.channel.ThrottleWriter;

public class HttpIOSession
implements IOSession {
    private static final Log LOG = LogFactory.getLog(HttpIOSession.class);
    private final Map<String, Object> attributes;
    private SessionBufferStatus bufferStatus;
    private int socketTimeout;
    private AbstractNBSocket socket;
    private HttpChannel channel;
    private int eventMask;
    private ThrottleWriter throttleWriter;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final Executor ioExecutor;

    public HttpIOSession(AbstractNBSocket socket, Executor ioExecutor) {
        if (socket == null) {
            throw new IllegalArgumentException();
        }
        this.attributes = Collections.synchronizedMap(new HashMap());
        this.socketTimeout = 0;
        this.socket = socket;
        this.ioExecutor = ioExecutor;
    }

    public void setHttpChannel(HttpChannel channel) {
        this.channel = channel;
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.channel.closeWhenBufferedOutputHasBeenFlushed();
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public SessionBufferStatus getBufferStatus() {
        return this.bufferStatus;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object obj) {
        this.attributes.put(name, obj);
    }

    @Override
    public void setBufferStatus(SessionBufferStatus status) {
        this.bufferStatus = status;
    }

    @Override
    public synchronized int getEventMask() {
        return this.eventMask;
    }

    @Override
    public synchronized void setEventMask(int ops) {
        if (this.isClosed()) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Attempted to set event mask to " + ops + " on closed session: " + this);
            }
            return;
        }
        this.eventMask = ops;
        this.channel.requestRead((ops & 1) != 0);
        this.channel.requestWrite((ops & 4) != 0);
    }

    @Override
    public synchronized void setEvent(int op) {
        if (this.isClosed()) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Attempted to set event mask to " + op + " on closed session: " + this);
            }
            return;
        }
        this.eventMask |= op;
        if ((op & 1) != 0) {
            this.channel.requestRead(true);
        }
        if ((op & 4) != 0) {
            this.channel.requestWrite(true);
        }
    }

    @Override
    public synchronized void clearEvent(int op) {
        if (this.isClosed()) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Attempted to set event mask to " + op + " on closed session: " + this);
            }
            return;
        }
        this.eventMask &= ~op;
        if ((op & 1) != 0) {
            this.channel.requestRead(false);
        }
        if ((op & 4) != 0) {
            this.channel.requestWrite(false);
        }
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            LOG.warn("Could not set socket timeout", e);
        }
    }

    @Override
    public boolean hasBufferedInput() {
        return this.bufferStatus != null && this.bufferStatus.hasBufferedInput();
    }

    @Override
    public boolean hasBufferedOutput() {
        return this.bufferStatus != null && this.bufferStatus.hasBufferedOutput();
    }

    public void setThrottle(Throttle throttle) {
        assert (NIODispatcher.instance().isDispatchThread()) : "wrong thread: " + Thread.currentThread().getName();
        this.throttleWriter.setThrottle(throttle);
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void shutdown() {
        this.closed.set(true);
        this.socket.close();
    }

    public void setThrottleChannel(ThrottleWriter throttleWriter) {
        this.throttleWriter = throttleWriter;
    }

    @Override
    public int getStatus() {
        throw new UnsupportedOperationException();
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }
}

