/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl.feature;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.AddressFeature;
import org.limewire.friend.api.feature.FeatureInitializer;
import org.limewire.friend.api.feature.FeatureRegistry;
import org.limewire.friend.api.feature.FeatureTransport;
import org.limewire.friend.api.feature.LimewireFeature;
import org.limewire.friend.impl.address.FriendAddress;
import org.limewire.friend.impl.address.FriendAddressRegistry;
import org.limewire.friend.impl.util.PresenceUtils;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.address.AddressEvent;

@EagerSingleton
public class AddressDispatcher
implements EventListener<AddressEvent>,
FeatureTransport.Handler<Address> {
    private static final Log LOG = LogFactory.getLog(AddressDispatcher.class);
    private final FriendAddressRegistry addressRegistry;
    private final Map<String, Address> pendingAddresses;
    private Address localAddress;
    private final Set<FriendConnection> connections;

    @Inject
    public AddressDispatcher(FriendAddressRegistry addressRegistry, FeatureRegistry featureRegistry) {
        this.addressRegistry = addressRegistry;
        this.pendingAddresses = new HashMap<String, Address>();
        this.connections = new HashSet<FriendConnection>();
        new AddressFeatureInitializer().register(featureRegistry);
    }

    @Inject
    void register(ListenerSupport<FriendConnectionEvent> connectionEventListenerSupport, ListenerSupport<AddressEvent> addressEventListenerSupport) {
        connectionEventListenerSupport.addListener(new EventListener<FriendConnectionEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(FriendConnectionEvent event) {
                AddressDispatcher addressDispatcher = AddressDispatcher.this;
                synchronized (addressDispatcher) {
                    switch ((FriendConnectionEvent.Type)((Object)event.getType())) {
                        case CONNECTED: {
                            AddressDispatcher.this.connections.add(event.getSource());
                            break;
                        }
                        case DISCONNECTED: {
                            AddressDispatcher.this.connections.remove(event.getSource());
                        }
                    }
                }
            }
        });
        addressEventListenerSupport.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void featureReceived(String from, Address address) {
        AddressDispatcher addressDispatcher = this;
        synchronized (addressDispatcher) {
            for (FriendConnection connection : this.connections) {
                Friend friend = connection.getFriend(PresenceUtils.parseBareAddress(from));
                if (friend != null) {
                    FriendPresence presence = friend.getPresences().get(from);
                    if (presence != null) {
                        LOG.debugf("updating address on presence {0} to {1}", (Object)presence.getPresenceId(), (Object)address);
                        this.addressRegistry.put(new FriendAddress(presence.getPresenceId()), address);
                        presence.addFeature(new AddressFeature(new FriendAddress(presence.getPresenceId())));
                        continue;
                    }
                    LOG.debugf("address {0} for presence {1} is pending", (Object)address, (Object)from);
                    this.pendingAddresses.put(from, address);
                    continue;
                }
                LOG.debugf("no friend for: {0}", (Object)from);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(AddressEvent event) {
        if (((AddressEvent.Type)((Object)event.getType())).equals((Object)AddressEvent.Type.ADDRESS_CHANGED)) {
            LOG.debugf("new localAddress to publish: {0}", (Object)event);
            AddressDispatcher addressDispatcher = this;
            synchronized (addressDispatcher) {
                this.localAddress = (Address)event.getData();
                for (FriendConnection connection : this.connections) {
                    for (Friend friend : connection.getFriends()) {
                        for (FriendPresence presence : friend.getPresences().values()) {
                            if (!presence.hasFeatures(LimewireFeature.ID)) continue;
                            try {
                                FeatureTransport transport = presence.getTransport(AddressFeature.class);
                                transport.sendFeature(presence, this.localAddress);
                            }
                            catch (FriendException e) {
                                LOG.debugf("couldn't send localAddress", (Object)e);
                            }
                        }
                    }
                }
            }
        }
    }

    private class AddressFeatureInitializer
    implements FeatureInitializer {
        private AddressFeatureInitializer() {
        }

        @Override
        public void register(FeatureRegistry registry) {
            registry.registerPublicInitializer(AddressFeature.ID, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initializeFeature(FriendPresence friendPresence) {
            AddressDispatcher addressDispatcher = AddressDispatcher.this;
            synchronized (addressDispatcher) {
                if (AddressDispatcher.this.localAddress != null) {
                    try {
                        FeatureTransport transport = friendPresence.getTransport(AddressFeature.class);
                        transport.sendFeature(friendPresence, AddressDispatcher.this.localAddress);
                    }
                    catch (FriendException e) {
                        LOG.debugf(e, "couldn't send localAddress to {0}" + friendPresence.getPresenceId(), new Object[0]);
                    }
                }
                if (AddressDispatcher.this.pendingAddresses.containsKey(friendPresence.getPresenceId())) {
                    LOG.debugf("updating address on presence {0} to {1}", (Object)friendPresence.getPresenceId(), (Object)AddressDispatcher.this.localAddress);
                    Address pendingAddress = (Address)AddressDispatcher.this.pendingAddresses.remove(friendPresence.getPresenceId());
                    AddressDispatcher.this.addressRegistry.put(new FriendAddress(friendPresence.getPresenceId()), pendingAddress);
                    friendPresence.addFeature(new AddressFeature(new FriendAddress(friendPresence.getPresenceId())));
                }
            }
        }

        @Override
        public void removeFeature(FriendPresence friendPresence) {
            AddressDispatcher.this.addressRegistry.remove(new FriendAddress(friendPresence.getPresenceId()));
            friendPresence.removeFeature(AddressFeature.ID);
        }
    }
}

